/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.model;

import java.awt.Color;
import java.awt.geom.Point2D;
import oracle.ide.vhv.model.ConnectionDetails;
import oracle.ide.vhv.model.GraphElement;

public abstract class GraphElementShape
implements ConnectionDetails {
    GraphElementShape m_parentShape;
    protected int m_connectionSide;
    GraphElement m_clientObject;
    String m_label;

    protected GraphElementShape(String label, GraphElementShape parent, int connectionSide, GraphElement clientObject) {
        this.m_label = label;
        this.m_parentShape = parent;
        this.m_connectionSide = connectionSide;
        this.m_clientObject = clientObject;
        clientObject.setShape(this);
    }

    public GraphElement getGraphElement() {
        return this.m_clientObject;
    }

    public GraphElementShape getParentShape() {
        return this.m_parentShape;
    }

    public void setParentShape(GraphElementShape gs) {
        this.m_parentShape = gs;
    }

    public String getLabel() {
        return this.m_label;
    }

    public static boolean isDarkColor(Color c) {
        return (c.getRed() + c.getBlue() + c.getGreen()) / 3 < 128;
    }

    public abstract Point2D getLocation();

    public abstract double getHeight();

    public abstract double getWidth();

    public abstract Point2D getTopConnectionPoint();

    public abstract Point2D getRightConnectionPoint();

    public abstract Point2D getBottomConnectionPoint();

    public abstract Point2D getLeftConnectionPoint();

    public int getConnectionSide() {
        return this.m_connectionSide;
    }

    public void setConnectionSide(int connectionSide) {
        this.m_connectionSide = connectionSide;
    }

    public Point2D getConnectionPoint() {
        switch (this.m_connectionSide) {
            case 1: {
                return this.m_parentShape.getTopConnectionPoint();
            }
            case 2: {
                return this.m_parentShape.getRightConnectionPoint();
            }
            case 3: {
                return this.m_parentShape.getBottomConnectionPoint();
            }
            case 4: {
                return this.m_parentShape.getLeftConnectionPoint();
            }
        }
        return null;
    }
}

