/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import javax.swing.JComponent;
import oracle.bali.inspector.editor.ComboBoxEditor;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.TextFieldEditor;

public final class PropertyValueApplierUtil {
    static final String PROPERTY_VALUE_APPLIER_KEY = PropertyValueApplier.class.getName();

    public static PropertyValueApplier retrievePropertyValueApplier(JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException("The Component should not be null");
        }
        if (c instanceof ComboBoxEditor) {
            return ((ComboBoxEditor)c).getPropertyValueApplier();
        }
        if (c instanceof TextFieldEditor) {
            return ((TextFieldEditor)c).getPropertyValueApplier();
        }
        Object o = c.getClientProperty(PROPERTY_VALUE_APPLIER_KEY);
        if (o instanceof PropertyValueApplier) {
            return (PropertyValueApplier)o;
        }
        return null;
    }

    public static void storePropertyValueApplier(PropertyValueApplier applier, JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException("The Component should not be null");
        }
        if (c instanceof ComboBoxEditor) {
            ((ComboBoxEditor)c).setPropertyValueApplier(applier);
            return;
        }
        if (c instanceof TextFieldEditor) {
            ((TextFieldEditor)c).setPropertyValueApplier(applier);
            return;
        }
        c.putClientProperty(PROPERTY_VALUE_APPLIER_KEY, applier);
    }

    private PropertyValueApplierUtil() {
    }
}

