/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.diff.AbstractPropertyFilter;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyManager;

public class DefaultPropertyValueFilter
extends AbstractPropertyFilter {
    private final PropertyManager m_source;
    private final PropertyManager m_target;
    private final boolean m_singleProvider;

    public DefaultPropertyValueFilter(DBObjectProvider dBObjectProvider) {
        this.m_target = this.m_source = dBObjectProvider.getPropertyManager();
        this.m_singleProvider = true;
    }

    public DefaultPropertyValueFilter(DBObjectProvider dBObjectProvider, DBObjectProvider dBObjectProvider2) {
        this(dBObjectProvider.getPropertyManager(), dBObjectProvider2.getPropertyManager());
    }

    public DefaultPropertyValueFilter(PropertyManager propertyManager, PropertyManager propertyManager2) {
        this.m_source = propertyManager;
        this.m_target = propertyManager2;
        this.m_singleProvider = false;
    }

    @Override
    protected boolean isFilteredProperty(Difference difference, DBObject dBObject, DBObject dBObject2, String string) {
        Object object;
        boolean bl = false;
        Object object2 = difference.getOriginalObject();
        if (object2 == null ^ (object = difference.getUpdatedObject()) == null) {
            DBObject dBObject3;
            DBObject dBObject4 = dBObject2 == null ? dBObject : dBObject2;
            DBObject dBObject5 = dBObject3 = dBObject == null ? dBObject2 : dBObject;
            if (object == null) {
                bl = this.isNullValueFiltered(dBObject4, this.m_source, string, dBObject3, object2, this.m_target);
            } else if (object2 == null) {
                bl = this.isNullValueFiltered(dBObject3, this.m_target, string, dBObject4, object, this.m_source);
            }
        }
        return bl;
    }

    private boolean isNullValueFiltered(DBObject dBObject, PropertyManager propertyManager, String string, DBObject dBObject2, Object object, PropertyManager propertyManager2) {
        Nullable.NullBehaviour nullBehaviour;
        Nullable.NullBehaviour nullBehaviour2 = this.getNullBehaviour((DBObject)(this.m_singleProvider ? dBObject : null), dBObject, string, propertyManager);
        boolean bl = Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED_AND_IGNORE.equals((Object)nullBehaviour2) ? true : (Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED.equals((Object)nullBehaviour2) ? (this.m_singleProvider ? true : (nullBehaviour = this.getNullBehaviour(dBObject2, dBObject2, string, propertyManager2)) != Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED) : this.isImplicitDefaultValue(object, dBObject2, string, propertyManager2));
        return bl;
    }

    private Nullable.NullBehaviour getNullBehaviour(DBObject dBObject, DBObject dBObject2, String string, PropertyManager propertyManager) {
        Nullable.NullBehaviour nullBehaviour = Nullable.NullBehaviour.NOT_NULLABLE;
        if (dBObject2 instanceof DataTypeUsage) {
            String[] stringArray;
            if (!(propertyManager instanceof DDLGenerator) && (stringArray = Property.getProperties((String)string)).length == 2 && "attributeValues".equals(stringArray[0])) {
                String string2 = stringArray[1];
                try {
                    DataTypeAttribute dataTypeAttribute;
                    DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)((DataTypeUsage)dBObject2), (boolean)false);
                    if (dataType != null && (dataTypeAttribute = dataType.getDataTypeAttribute(string2)) != null && !dataTypeAttribute.isMandatory()) {
                        nullBehaviour = Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED;
                    }
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)this).log(Level.WARNING, "Couldn't resolve datatype: " + dBException.getMessage());
                }
            }
        } else if (dBObject2 != null) {
            nullBehaviour = propertyManager.getNullBehaviour(dBObject, dBObject2, string);
        }
        return nullBehaviour;
    }

    private boolean isImplicitDefaultValue(Object object, DBObject dBObject, String string, PropertyManager propertyManager) {
        Object object2 = propertyManager.getImplicitDefaultValue(dBObject, string);
        return object2 != null && object2.equals(object);
    }

    @Override
    protected boolean ignoreProperty(DBObject dBObject, String string) {
        return false;
    }
}

