/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.hive.HiveDatabase;
import oracle.javatools.db.hive.HiveDatabaseDescriptor;
import oracle.javatools.db.hive.HiveDatabaseImpl;

public class HiveDatabaseCreator
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String string, String string2, Connection connection) throws DBException {
        HiveDatabaseImpl hiveDatabaseImpl = null;
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string3 = databaseMetaData.getDatabaseProductName();
                if (string3.startsWith("Apache Hive")) {
                    int n = databaseMetaData.getDatabaseMajorVersion();
                    int n2 = databaseMetaData.getDatabaseMinorVersion();
                    int n3 = n == 0 && n2 <= 12 ? 12 : (n == 0 && n2 == 13 ? 13 : 14);
                    hiveDatabaseImpl = new HiveDatabaseImpl(string, string2, connection, n3);
                }
            }
            catch (SQLException sQLException) {
                DBLog.getLogger((Object)((Object)this)).fine(sQLException.getMessage());
            }
        }
        return hiveDatabaseImpl;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        HiveDatabaseDescriptor hiveDatabaseDescriptor = null;
        if (HiveDatabaseImpl.class.isAssignableFrom(clazz)) {
            hiveDatabaseDescriptor = new HiveDatabaseDescriptor(12);
        }
        return hiveDatabaseDescriptor;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(String string, int n) {
        return "Hive".equals(string) ? new HiveDatabaseDescriptor(n) : null;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Database database) {
        return database instanceof HiveDatabase ? new HiveDatabaseDescriptor(database.getDatabaseVersion()) : null;
    }
}

