/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.mysql.MySQL5;
import oracle.javatools.db.mysql.MySQLDatabase;
import oracle.javatools.db.mysql.MySQLDatabaseDescriptor;
import oracle.javatools.db.mysql.MySQLDatabaseImpl;

public class MySQLDatabaseFactory
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String string, String string2, Connection connection) {
        MySQLDatabaseImpl mySQLDatabaseImpl = null;
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string3 = databaseMetaData.getDatabaseProductName();
                if (string3.startsWith("MySQL")) {
                    int n = databaseMetaData.getDatabaseMajorVersion();
                    mySQLDatabaseImpl = n >= 5 ? new MySQL5(string, string2, connection) : new MySQLDatabaseImpl(string, string2, connection);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return mySQLDatabaseImpl;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        if (MySQLDatabase.class.isAssignableFrom(clazz)) {
            return new MySQLDatabaseDescriptor(clazz);
        }
        return null;
    }
}

