/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.ide.util.Assert;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.db.plsql.Trigger;

public class OracleTriggerBuilder
extends OracleDBObjectBuilder<Trigger> {
    OracleTriggerBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "TRIGGER");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"baseObjectID", "baseType", "columnIDs", "code", "enabled", "events", "referencingNewAs", "referencingOldAs", "source", "statementLevel", "timing", "whenClause"})
    public void fillInTrigger(final Trigger trigger) throws DBException {
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)trigger, this.getQueryString(), trigger.getSchema(), trigger);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        trigger.setCode(resultSet.getString(8));
                        String string = resultSet.getString(1);
                        OracleTriggerBuilder.parseBaseType(string, trigger);
                        Trigger.BaseType baseType = trigger.getBaseType();
                        string = resultSet.getString(2);
                        OracleTriggerBuilder.parseTriggerType(string, trigger);
                        OracleTriggerBuilder.parseTriggeringEvent(resultSet.getString(3), trigger);
                        string = resultSet.getString(4);
                        Schema schema = string != null ? OracleTriggerBuilder.this.getSchema(string) : null;
                        OracleTriggerBuilder.parseOwnerAndName(schema, resultSet.getString(5), trigger, (DBObjectProvider)OracleTriggerBuilder.this.getDatabase());
                        if (baseType == Trigger.BaseType.VIEW || baseType == Trigger.BaseType.TABLE && !trigger.isStatementLevel()) {
                            OracleTriggerBuilder.parseReferencingNames(resultSet.getString(6), trigger);
                        }
                        trigger.setWhenClause(resultSet.getString(7));
                        trigger.setEnabled(!"DISABLED".equals(resultSet.getString(9)));
                        ArrayList<NameBasedID> arrayList = new ArrayList<NameBasedID>();
                        string = resultSet.getString(10);
                        while (string != null) {
                            String string2 = resultSet.getString(11);
                            if ("Y".equals(string2) || "YES".equals(string2)) {
                                NameBasedID nameBasedID = new NameBasedID("COLUMN", string, trigger.getBaseObjectID());
                                arrayList.add(nameBasedID);
                            }
                            string = resultSet.next() ? resultSet.getString(10) : null;
                        }
                        trigger.setColumnIDs(arrayList.toArray(new DBObjectID[arrayList.size()]));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)trigger, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        trigger.setSource(this.getSource(trigger));
    }

    protected String getQueryString() {
        if (this.getDatabase().getDatabaseVersion() < 82) {
            return OracleDictionaryQueries.TRIGGER_PROPS_ORACLE8_QUERY;
        }
        return "SELECT /*OracleDictionaryQueries.ALL_TRIGGER_PROPS_QUERY*/\n       A.BASE_OBJECT_TYPE, A.TRIGGER_TYPE, A.TRIGGERING_EVENT, A.TABLE_OWNER, A.TABLE_NAME, A.REFERENCING_NAMES, A.WHEN_CLAUSE, A.TRIGGER_BODY, A.STATUS, B.COLUMN_NAME, B.COLUMN_LIST FROM SYS.ALL_TRIGGERS A, SYS.ALL_TRIGGER_COLS B WHERE A.OWNER = B.TRIGGER_OWNER(+) AND A.TRIGGER_NAME = B.TRIGGER_NAME(+) AND A.OWNER = ? AND A.TRIGGER_NAME = ?";
    }

    private static void parseBaseType(String string, Trigger trigger) {
        Trigger.BaseType baseType = null;
        if (string != null) {
            string = string.trim();
            baseType = Trigger.BaseType.valueOf((String)string);
        }
        trigger.setBaseType(baseType);
    }

    private static void parseTriggerType(String string, Trigger trigger) {
        switch (trigger.getBaseType()) {
            case VIEW: {
                if (!"INSTEAD OF".equals(string)) break;
                trigger.setTiming(Trigger.Timing.INSTEAD_OF);
                break;
            }
            case TABLE: {
                if ("BEFORE STATEMENT".equals(string)) {
                    trigger.setTiming(Trigger.Timing.BEFORE);
                    trigger.setStatementLevel(true);
                    break;
                }
                if ("BEFORE EACH ROW".equals(string)) {
                    trigger.setTiming(Trigger.Timing.BEFORE);
                    trigger.setStatementLevel(false);
                    break;
                }
                if ("AFTER STATEMENT".equals(string)) {
                    trigger.setTiming(Trigger.Timing.AFTER);
                    trigger.setStatementLevel(true);
                    break;
                }
                if (!"AFTER EACH ROW".equals(string)) break;
                trigger.setTiming(Trigger.Timing.AFTER);
                trigger.setStatementLevel(false);
                break;
            }
            case SCHEMA: 
            case DATABASE: {
                if ("BEFORE EVENT".equals(string)) {
                    trigger.setTiming(Trigger.Timing.BEFORE);
                    break;
                }
                if (!"AFTER EVENT".equals(string)) break;
                trigger.setTiming(Trigger.Timing.AFTER);
                break;
            }
        }
    }

    private static void parseTriggeringEvent(String string, Trigger trigger) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if ("OR".equalsIgnoreCase(string2)) continue;
                arrayList.add(string2);
            }
        }
        trigger.setEvents(arrayList.toArray(new String[arrayList.size()]));
    }

    private static void parseOwnerAndName(Schema schema, String string, Trigger trigger, DBObjectProvider dBObjectProvider) {
        SchemaObject schemaObject = null;
        String string2 = "TABLE";
        switch (trigger.getBaseType()) {
            case DATABASE: {
                break;
            }
            case SCHEMA: {
                trigger.setBaseObjectID(schema.getID());
                break;
            }
            case VIEW: {
                string2 = "VIEW";
            }
            case TABLE: {
                try {
                    schemaObject = dBObjectProvider.getObject(string2, schema, string);
                }
                catch (DBException dBException) {
                    Assert.printStackTrace();
                    return;
                }
                if (schemaObject == null) break;
                trigger.setBaseObjectID(schemaObject.getID());
            }
        }
    }

    private static void parseReferencingNames(String string, Trigger trigger) {
        if (string != null) {
            String[] stringArray = new String[2];
            boolean bl = false;
            int n = -1;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (bl) {
                    if (n != -1) {
                        stringArray[n] = string2;
                    }
                    n = -1;
                    bl = false;
                    continue;
                }
                if ("AS".equals(string2)) {
                    bl = true;
                    continue;
                }
                if ("OLD".equals(string2)) {
                    n = 0;
                    continue;
                }
                if ("NEW".equals(string2)) {
                    n = 1;
                    continue;
                }
                n = -1;
            }
            if (!"OLD".equals(stringArray[0])) {
                trigger.setReferencingOldAs(stringArray[0]);
            }
            if (!"NEW".equals(stringArray[1])) {
                trigger.setReferencingNewAs(stringArray[1]);
            }
        }
    }

    private final String getSource(final Trigger trigger) throws DBException {
        StringBuilder stringBuilder;
        String string = null;
        final StringBuffer stringBuffer = new StringBuffer();
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)trigger, "SELECT /*OracleDictionaryQueries.ALL_TRIGGER_SOURCE_QUERY*/\n       TEXT FROM SYS.ALL_SOURCE WHERE TYPE = 'TRIGGER' AND OWNER = ? AND NAME = ? ORDER BY LINE", trigger.getSchema(), trigger);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        if (string != null) {
                            stringBuffer.append(string);
                            if (string.endsWith("\n")) continue;
                            stringBuffer.append('\n');
                            continue;
                        }
                        stringBuffer.append('\n');
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)trigger, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        if (stringBuffer.length() > 0) {
            string = stringBuffer.toString();
        }
        if (string == null) {
            stringBuilder = this.getProvider().getDescriptor().getDDLGenerator((DBObjectProvider)this.getProvider()).getCreateDDL(new DDLOptions(false, false), new DBObject[]{trigger});
            string = stringBuilder.toString();
        }
        stringBuilder = new StringBuilder("CREATE OR REPLACE\n");
        stringBuilder.append(string.trim());
        string = stringBuilder.toString();
        return string;
    }
}

