/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.ora.sql.Keywords;
import oracle.javatools.db.ora.sql.ParserRules;
import oracle.javatools.db.ora.sql.SqlUsageUtil;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

public class OracleSQLQueryBuilderHelper
implements Keywords,
ParserRules {
    private static final String KW_DOT = ".";
    private final String m_source;
    private final List<LexerToken> m_lexerTokens;
    private final SqlEarley m_earleyInstance;
    private final ParseNode m_parseRoot;
    private final Matrix m_matrix;

    private OracleSQLQueryBuilderHelper(SqlEarley sqlEarley, Matrix matrix, List<LexerToken> list, String string, ParseNode parseNode) {
        this.m_source = string;
        this.m_lexerTokens = list;
        this.m_matrix = matrix;
        this.m_earleyInstance = sqlEarley;
        this.m_parseRoot = parseNode;
    }

    public int getTokenStartOffset(int n) {
        return this.m_lexerTokens.get((int)n).begin;
    }

    public int getTokenEndOffset(int n) {
        return this.m_lexerTokens.get((int)n).end;
    }

    public int getNodeStartOffset(ParseNode parseNode) {
        return this.m_lexerTokens.get((int)parseNode.from).begin;
    }

    public int getNodeEndOffset(ParseNode parseNode) {
        int n = parseNode.to;
        return this.m_lexerTokens.get((int)(n - 1)).end - 1;
    }

    public String getSourceFragment(int n, int n2) {
        String string = "";
        if (ModelUtil.hasLength((String)this.m_source)) {
            if (n < 0) {
                n = 0;
            }
            if (n2 > this.m_source.length()) {
                n2 = this.m_source.length() - 1;
            }
            if (n2 >= n) {
                string = this.m_source.substring(n, n2 + 1);
            }
        }
        return string;
    }

    public String getSourceFragment(ParseNode parseNode) {
        int n = this.getNodeStartOffset(parseNode);
        int n2 = this.getNodeEndOffset(parseNode);
        return this.getSourceFragment(n, n2);
    }

    public String getContent(ParseNode parseNode) {
        String string = null;
        if (parseNode != null) {
            string = this.isLeaf(parseNode) ? this.m_lexerTokens.get((int)parseNode.from).content : this.getSourceFragment(parseNode);
        }
        return string;
    }

    public String getContentType(ParseNode parseNode) {
        String string = null;
        if (this.isLeaf(parseNode)) {
            string = this.m_lexerTokens.get((int)parseNode.from).type.toString();
        }
        return string;
    }

    public List<ParseNode> getLeftAndRight(ParseNode parseNode) {
        Set set = parseNode.children();
        int n = Integer.MAX_VALUE;
        ParseNode parseNode2 = null;
        ParseNode parseNode3 = null;
        for (ParseNode parseNode4 : set) {
            if (parseNode4.from < n) {
                if (parseNode2 != null) {
                    parseNode3 = parseNode2;
                }
                parseNode2 = parseNode4;
                n = parseNode4.from;
                continue;
            }
            parseNode3 = parseNode4;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(0, parseNode2);
        arrayList.add(1, parseNode3);
        return arrayList;
    }

    public List<ParseNode> getKeywordExpr(ParseNode parseNode, String string) {
        ArrayList<ParseNode> arrayList = null;
        ParseNode parseNode2 = null;
        ParseNode parseNode3 = null;
        Set set = parseNode.children();
        for (ParseNode parseNode4 : set) {
            if (this.isKeyword(parseNode4, string)) {
                parseNode3 = parseNode4;
                continue;
            }
            parseNode2 = parseNode4;
        }
        if (parseNode3 != null) {
            arrayList = new ArrayList<ParseNode>();
            arrayList.add(0, parseNode3);
            arrayList.add(1, parseNode2);
        }
        return arrayList;
    }

    public List<ParseNode> getOrderedChildren(ParseNode parseNode) {
        ArrayList<ParseNode> arrayList = new ArrayList<ParseNode>();
        if (parseNode != null) {
            Set set = parseNode.children();
            if (set.size() == 0) {
                arrayList.add(parseNode);
            } else {
                for (ParseNode parseNode2 : set) {
                    if (this.isRule(parseNode2)) {
                        arrayList.add(parseNode2);
                        continue;
                    }
                    arrayList.addAll(this.getOrderedChildren(parseNode2));
                }
            }
        }
        return arrayList;
    }

    public int getRuleIndex(List<ParseNode> list, String string) {
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!this.isRule(list.get(i), string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public List<ParseNode> findRuleNodes(ParseNode parseNode, String ... stringArray) {
        List<ParseNode> list = Collections.emptyList();
        List list2 = parseNode.descendants();
        if (list2 != null) {
            for (ParseNode parseNode2 : list2) {
                if (!this.isRule(parseNode2, stringArray)) continue;
                if (list.size() == 0) {
                    list = new ArrayList<ParseNode>();
                }
                list.add(parseNode2);
            }
        }
        return list;
    }

    public ParseNode getRuleNode(List<ParseNode> list, String string) {
        ParseNode parseNode = null;
        int n = this.getRuleIndex(list, string);
        if (n >= 0) {
            parseNode = list.get(n);
        }
        return parseNode;
    }

    public boolean isRule(ParseNode parseNode) {
        boolean bl = false;
        for (int n : parseNode.content()) {
            String string = this.m_earleyInstance.allSymbols[n];
            if (string.indexOf("[") > 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isRule(ParseNode parseNode, String ... stringArray) {
        boolean bl = false;
        if (parseNode != null) {
            block0: for (String string : stringArray) {
                for (int n : parseNode.content()) {
                    if (n < 0 || !string.equals(this.m_earleyInstance.allSymbols[n])) continue;
                    bl = true;
                    break block0;
                }
            }
        }
        return bl;
    }

    public boolean isRule(ParseNode parseNode, List<String> list) {
        return this.isRule(parseNode, list.toArray(new String[list.size()]));
    }

    public int getKeywordIndex(List<ParseNode> list, String ... stringArray) {
        return this.getKeywordIndex(list, 0, stringArray);
    }

    public int getKeywordIndex(List<ParseNode> list, int n, String ... stringArray) {
        int n2 = -1;
        for (int i = n; i < list.size(); ++i) {
            if (!this.isKeyword(list.get(i), stringArray)) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public boolean isKeyword(ParseNode parseNode, String ... stringArray) {
        boolean bl = false;
        Set set = parseNode.children();
        if (set.size() == 0) {
            String string;
            String string2 = this.m_lexerTokens.get((int)parseNode.from).content;
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            for (int i = 0; i < n && !(bl = (string = stringArray2[i]).equalsIgnoreCase(string2)); ++i) {
            }
        }
        return bl;
    }

    public boolean isOperation(ParseNode parseNode) {
        boolean bl = this.isKeyword(parseNode, "+", "-");
        return bl;
    }

    public boolean isLeaf(ParseNode parseNode) {
        boolean bl = parseNode.children().isEmpty();
        return bl;
    }

    public List<List<ParseNode>> getCommaSeparatedList(ParseNode parseNode) {
        List<List<ParseNode>> list = new ArrayList<List<ParseNode>>();
        if (this.isDotSeperatedList(parseNode) || this.isRule(parseNode, "expr")) {
            ArrayList<ParseNode> arrayList = new ArrayList<ParseNode>();
            arrayList.add(parseNode);
            list.add(arrayList);
        } else {
            int n;
            List<ParseNode> list2 = this.getOrderedChildren(parseNode);
            if (list2.size() > 0 && (n = this.getKeywordIndex(list2, "(")) > 0 && this.isKeyword(list2.get(list2.size() - 1), ")")) {
                list2 = list2.subList(n + 1, list2.size() - 1);
            }
            list = this.getCommaSeparatedList(list2);
        }
        return list;
    }

    public List<ParseNode> flattenListTree(String string, ParseNode parseNode) {
        ArrayList<ParseNode> arrayList = new ArrayList<ParseNode>();
        List<ParseNode> list = this.getOrderedChildren(parseNode);
        if (this.isRule(parseNode, string) && list.size() == 3 && this.isKeyword(list.get(1), ",")) {
            arrayList.addAll(this.flattenListTree(string, list.get(0)));
            arrayList.add(list.get(1));
            arrayList.addAll(this.flattenListTree(string, list.get(2)));
        } else {
            arrayList.add(parseNode);
        }
        return arrayList;
    }

    public List<List<ParseNode>> getCommaSeparatedList(List<ParseNode> list) {
        if (list.size() == 1 && this.isRule(list.get(0), "\"expr_list\"")) {
            list = this.flattenListTree("\"expr_list\"", list.get(0));
        }
        ArrayList<List<ParseNode>> arrayList = new ArrayList<List<ParseNode>>();
        int n = this.getKeywordIndex(list, ",");
        if (n == -1) {
            arrayList.add(list);
        } else {
            ArrayList<ParseNode> arrayList2 = new ArrayList<ParseNode>();
            for (int i = 0; i < list.size(); ++i) {
                if (this.isKeyword(list.get(i), ",")) {
                    arrayList.add(arrayList2);
                    arrayList2 = new ArrayList();
                    continue;
                }
                arrayList2.add(list.get(i));
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public boolean isDotSeperatedList(List<ParseNode> list) {
        int n = this.getKeywordIndex(list, KW_DOT);
        int n2 = this.getKeywordIndex(list, "(");
        return n > 0 && n2 == -1;
    }

    public boolean isDotSeperatedList(ParseNode parseNode) {
        List<ParseNode> list = this.getOrderedChildren(parseNode);
        return this.isDotSeperatedList(list);
    }

    public List<ParseNode> getDotSeparatedList(ParseNode parseNode) {
        List<ParseNode> list = this.getOrderedChildren(parseNode);
        ArrayList<ParseNode> arrayList = new ArrayList<ParseNode>();
        int n = this.getKeywordIndex(list, KW_DOT);
        if (n == -1) {
            arrayList.add(parseNode);
        } else {
            arrayList = this.getDotSeparatedList(list);
        }
        return arrayList;
    }

    public List<ParseNode> getDotSeparatedList(List<ParseNode> list) {
        ArrayList<ParseNode> arrayList = new ArrayList();
        int n = this.getKeywordIndex(list, KW_DOT);
        if (n == -1) {
            arrayList = list;
        } else {
            for (int i = 0; i < list.size(); ++i) {
                if (this.isKeyword(list.get(i), KW_DOT)) continue;
                arrayList.add(list.get(i));
            }
        }
        return arrayList;
    }

    public String getRule(int n) {
        return this.m_earleyInstance.allSymbols[n];
    }

    public List<LexerToken> getLexerTokens() {
        return this.m_lexerTokens;
    }

    public ParseNode getRaptorRoot() {
        return this.m_parseRoot;
    }

    public SyntaxError getSyntaxError() {
        String[] stringArray = new String[]{"sql_statements", "subprg_body"};
        SyntaxError syntaxError = SyntaxError.checkSyntax((String)this.m_source, (String[])stringArray, this.m_lexerTokens, (Earley)this.m_earleyInstance, (Matrix)this.m_matrix);
        return syntaxError;
    }

    public ParseNode getNodeAtOffset(int n) {
        return this.getNodeAtOffset(this.m_parseRoot, n);
    }

    private ParseNode getNodeAtOffset(ParseNode parseNode, int n) {
        if (parseNode == null || this.getNodeStartOffset(parseNode) == n) {
            return parseNode;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            if (this.getNodeStartOffset(parseNode2) > n || this.getNodeEndOffset(parseNode2) < n) continue;
            return this.getNodeAtOffset(parseNode2, n);
        }
        return null;
    }

    void print(ParseNode parseNode, int n, String string, PrintWriter printWriter) {
        List<ParseNode> list = this.getOrderedChildren(parseNode);
        int n2 = list.size();
        boolean bl = parseNode.children().size() == 0;
        String string2 = parseNode.topLevel == null ? "<null>" : String.valueOf(parseNode.topLevel.size());
        int[] nArray = parseNode.content();
        String string3 = nArray == null ? "<null>" : String.valueOf(nArray.length);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(" ").append((String)(bl ? "Leaf" : n2 + " children. ")).append(" topCount=").append(string2).append(" childCount=").append(string3).append(" ::");
        if (bl) {
            boolean bl2 = this.isKeyword(parseNode, SqlUsageUtil.RESERVED_WORDS);
            LexerToken lexerToken = this.m_lexerTokens.get(parseNode.from);
            stringBuilder.append("  ").append((Object)(bl2 ? "RESERVED_WORD" : lexerToken.type)).append(" ").append(lexerToken.content);
        }
        printWriter.println(stringBuilder.toString());
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i <= string.length(); ++i) {
            stringBuilder2.append(" ");
        }
        String string4 = stringBuilder2.toString();
        StringBuilder stringBuilder3 = new StringBuilder("rules...");
        boolean bl3 = false;
        for (int n3 : nArray) {
            String string5;
            if (n3 < 0 || (string5 = this.getRule(n3)).indexOf("[") > 0) continue;
            bl3 = true;
            stringBuilder3.append("  " + string5);
        }
        if (parseNode.isAuxiliary()) {
            stringBuilder3.append("  - Auxillary");
        }
        if (bl3) {
            printWriter.println(string4 + stringBuilder3.toString());
        }
        printWriter.println(string4 + this.getContent(parseNode));
        if (!bl) {
            int n4 = 0;
            for (ParseNode parseNode2 : list) {
                this.print(parseNode2, n + 1, string + KW_DOT + n4++, printWriter);
            }
        }
    }

    public List<ParseNode> getQueryRootKids() throws SQLQueryException {
        List<ParseNode> list;
        ParseNode parseNode = this.getRaptorRoot();
        this.checkErrors(parseNode, this.m_source);
        while (parseNode != null && !this.isRule(parseNode, "query_block") && (parseNode = this.getRuleNode(list = this.getOrderedChildren(parseNode), "query_block")) == null) {
            parseNode = this.getRuleNode(list, "subquery");
        }
        return this.getOrderedChildren(parseNode);
    }

    public List<ParseNode> getSelectItemNodes(List<ParseNode> list) throws SQLQueryException {
        ParseNode parseNode;
        List<ParseNode> list2;
        ParseNode parseNode2;
        List<ParseNode> list3 = new ArrayList<ParseNode>();
        if (list != null && !list.isEmpty() && (parseNode2 = this.getRuleNode(list2 = this.getOrderedChildren(parseNode = this.getRuleNode(list, "select_clause")), "select_list")) != null) {
            if (this.isLeaf(parseNode2)) {
                list3.add(parseNode2);
            } else {
                list3 = this.getSelectList(parseNode2);
            }
        }
        return list3;
    }

    public List<ParseNode> getSelectList(ParseNode parseNode) {
        ArrayList<ParseNode> arrayList = new ArrayList<ParseNode>();
        if (this.isRule(parseNode, "select_term")) {
            arrayList.add(parseNode);
        } else if (this.isRule(parseNode, "select_list")) {
            List<ParseNode> list = this.getOrderedChildren(parseNode);
            for (ParseNode parseNode2 : list) {
                arrayList.addAll(this.getSelectList(parseNode2));
            }
        }
        return arrayList;
    }

    void checkErrors(ParseNode parseNode, String string) throws SQLParseException {
        Set set = parseNode.topLevel;
        if (set != null) {
            OracleSQLQueryBuilderHelper.checkErrors(this.getSyntaxError(), string);
        }
    }

    private static void checkErrors(SyntaxError syntaxError, String string) throws SQLParseException {
        if (syntaxError != null) {
            String string2;
            String string3 = syntaxError.getMessage();
            int n = syntaxError.offset;
            int n2 = 0;
            for (int i = 0; i < string.lastIndexOf(10) && n2 != syntaxError.line; ++i) {
                if (string.charAt(i) == '\n') {
                    ++n2;
                }
                ++n;
            }
            StringBuilder stringBuilder = null;
            String[] stringArray = syntaxError.getSuggestions();
            for (int i = 0; i < 3 && i < stringArray.length; ++i) {
                string2 = stringArray[i];
                if (i == 0) {
                    stringBuilder = new StringBuilder(string2);
                    continue;
                }
                stringBuilder.append(',').append(string2);
            }
            String string4 = stringBuilder == null ? "" : stringBuilder.toString();
            string2 = new SQLParseException.ParseError(n, string3, string4);
            throw new SQLParseException(new SQLParseException.ParseError[]{string2}, string);
        }
    }

    public static void checkSyntax(String string) throws SQLParseException {
        SyntaxError syntaxError = SyntaxError.checkSQLQuerySyntax((String)string);
        if (syntaxError != null) {
            OracleSQLQueryBuilderHelper.checkErrors(syntaxError, string);
        }
    }

    public static OracleSQLQueryBuilderHelper getHelper(String string) {
        SqlEarley sqlEarley = SqlEarley.getInstance();
        Matrix matrix = new Matrix((Parser)sqlEarley);
        List list = LexerToken.parse((String)string);
        sqlEarley.parse(list, (Matriceable)matrix);
        ParseNode parseNode = sqlEarley.forest(list, matrix);
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = new OracleSQLQueryBuilderHelper(sqlEarley, matrix, list, string, parseNode);
        Logger logger = DBLog.getLogger(OracleSQLQueryBuilderHelper.class);
        if (logger.isLoggable(Level.FINEST)) {
            StringWriter stringWriter = new StringWriter();
            oracleSQLQueryBuilderHelper.print(parseNode, 0, "0", new PrintWriter((Writer)stringWriter, true));
            logger.finest(stringWriter.toString());
        }
        return oracleSQLQueryBuilderHelper;
    }
}

