/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleInMemoryColumnProperties;
import oracle.javatools.db.ora.OracleInMemoryProperties;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import oracle.javatools.db.ora.sxml.SXMLReaderException;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InMemorySXMLGenerator
extends SXMLFragmentGenerator {
    private static final String NO_INMEMORY = "NO INMEMORY";
    private static final String NONE = "NONE";
    private static final String IM_COL_LIST = "IM_COL_LIST";
    private static final String IM_COL_LIST_ITEM = "IM_COL_LIST_ITEM";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String COMPRESSION = "COMPRESSION";

    @Override
    protected void populateNode(Node node, Document document, Object object) {
        OracleInMemoryColumnProperties[] oracleInMemoryColumnPropertiesArray;
        OracleInMemoryProperties oracleInMemoryProperties = (OracleInMemoryProperties)object;
        Table table = (Table)DBUtil.findParentOfType((DBObject)oracleInMemoryProperties, Table.class);
        OracleInMemoryColumnProperties[] oracleInMemoryColumnPropertiesArray2 = oracleInMemoryColumnPropertiesArray = table == null ? null : (OracleInMemoryColumnProperties[])table.getProperty("OracleInMemoryColumnProperties");
        if (oracleInMemoryColumnPropertiesArray != null) {
            Node node2 = null;
            for (OracleInMemoryColumnProperties oracleInMemoryColumnProperties : oracleInMemoryColumnPropertiesArray) {
                for (DBObjectID dBObjectID : oracleInMemoryColumnProperties.getColumnIDs()) {
                    Object object2;
                    Column column = (Column)table.findOwnedObject(dBObjectID);
                    if (column == null) continue;
                    if (node2 == null) {
                        node2 = this.findOrCreateNode(document, node, IM_COL_LIST);
                    }
                    String string = oracleInMemoryColumnProperties.isInMemory() ? ((object2 = oracleInMemoryColumnProperties.getInMemoryCompression()) == null ? NONE : object2.toString()) : NO_INMEMORY;
                    object2 = this.createNode(document, node2, IM_COL_LIST_ITEM);
                    Node node3 = this.createNode(document, (Node)object2, COLUMN_NAME);
                    node3.setTextContent(column.getName());
                    Node node4 = this.createNode(document, (Node)object2, COMPRESSION);
                    node4.setTextContent(string);
                }
            }
        }
    }

    @Override
    protected void readNode(Node node, Object object) throws SXMLReaderException {
        NodeList nodeList;
        Node node2;
        SXMLReader sXMLReader = (SXMLReader)this.getParentGenerator();
        SystemObject systemObject = sXMLReader.getCurrentObject();
        if (systemObject instanceof Table && (node2 = this.findNode(node, IM_COL_LIST)) != null && (nodeList = node2.getChildNodes()) != null) {
            ArrayList<OracleInMemoryColumnProperties> arrayList = new ArrayList<OracleInMemoryColumnProperties>();
            NameBasedID nameBasedID = new NameBasedID((DBObject)systemObject, (DBObjectID)null);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                String string2;
                Node node3;
                Node node4 = nodeList.item(i);
                if (!IM_COL_LIST_ITEM.equals(node4.getLocalName()) || (node3 = this.findNode(node4, COLUMN_NAME)) == null || !ModelUtil.hasLength((String)(string2 = node3.getTextContent()))) continue;
                OracleInMemoryColumnProperties oracleInMemoryColumnProperties = new OracleInMemoryColumnProperties();
                arrayList.add(oracleInMemoryColumnProperties);
                NameBasedID nameBasedID2 = new NameBasedID("COLUMN", string2, (DBObjectID)nameBasedID);
                oracleInMemoryColumnProperties.setColumnIDs(new DBObjectID[]{nameBasedID2});
                oracleInMemoryColumnProperties.setID((DBObjectID)new NameBasedID("OracleInMemoryColumnProperties", string2, (DBObjectID)nameBasedID));
                Node node5 = this.findNode(node4, COMPRESSION);
                if (node5 == null || NONE.equals(string = node5.getTextContent())) continue;
                if (NO_INMEMORY.equals(string)) {
                    oracleInMemoryColumnProperties.setInMemory(false);
                    continue;
                }
                oracleInMemoryColumnProperties.setInMemoryCompression((OracleInMemoryProperties.InMemoryCompression)DBUtil.findEnumFromString((String)string, OracleInMemoryProperties.InMemoryCompression.class));
            }
            systemObject.setProperty("OracleInMemoryColumnProperties", (Object)arrayList.toArray(new OracleInMemoryColumnProperties[arrayList.size()]));
        }
    }
}

