/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MatViewLogSXMLGenerator
extends SXMLFragmentGenerator {
    @Override
    protected void populateNode(Node node, Document document, Object object) {
        if (object instanceof MaterializedViewLog) {
            MaterializedViewLog materializedViewLog = (MaterializedViewLog)object;
            Node node2 = this.findOrCreateNodeAfter(document, node, "RECORDS", "PARALLEL");
            DBObjectID[] dBObjectIDArray = materializedViewLog.getColumnIDs();
            if (dBObjectIDArray != null && dBObjectIDArray.length > 0) {
                Node node3 = this.findOrCreateNode(document, node2, "COL_LIST");
                for (DBObjectID dBObjectID : dBObjectIDArray) {
                    String string = DBUtil.getDBObjectName((DBObjectID)dBObjectID);
                    Node node4 = this.createNode(document, node3, "COL_LIST_ITEM/NAME");
                    node4.appendChild(document.createTextNode(string));
                }
            }
        }
    }

    @Override
    protected void readNode(Node node, Object object) {
        if (object instanceof MaterializedViewLog) {
            MaterializedViewLog materializedViewLog = (MaterializedViewLog)object;
            ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
            Node node2 = this.findNode(node, "RECORDS/COL_LIST");
            if (node2 != null) {
                SXMLFragmentGenerator.childXMLElementIterator childXMLElementIterator2 = new SXMLFragmentGenerator.childXMLElementIterator(node2);
                while (childXMLElementIterator2.hasNext()) {
                    Node node3 = childXMLElementIterator2.next();
                    String string = this.nodeText(node3, "NAME");
                    NameBasedID nameBasedID = new NameBasedID("COLUMN", string, materializedViewLog.getMasterTableID());
                    arrayList.add((DBObjectID)nameBasedID);
                }
            }
            if (materializedViewLog.getPrimaryKeyLogged() == Boolean.TRUE) {
                this.addOrRemovePKCOls(materializedViewLog, arrayList, false);
            }
            materializedViewLog.setColumnIDs(arrayList.toArray(new DBObjectID[arrayList.size()]));
        }
    }

    private void addOrRemovePKCOls(MaterializedViewLog materializedViewLog, List<DBObjectID> list, boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException("Should not be adding PK cols to MVL Filter cols");
        }
        Table table = this.getMasterTable(materializedViewLog);
        if (table != null) {
            for (Constraint constraint : table.getConstraints()) {
                if (!(constraint instanceof PKConstraint)) continue;
                for (DBObjectID dBObjectID : ((PKConstraint)constraint).getColumnIDs()) {
                    if (bl) {
                        list.add(dBObjectID);
                        continue;
                    }
                    DBObjectID dBObjectID2 = null;
                    String string = DBUtil.getDBObjectName((DBObjectID)dBObjectID);
                    for (DBObjectID dBObjectID3 : list) {
                        String string2 = DBUtil.getDBObjectName((DBObjectID)dBObjectID3);
                        if (!string2.equals(string)) continue;
                        dBObjectID2 = dBObjectID3;
                        break;
                    }
                    if (dBObjectID2 == null) continue;
                    list.remove(dBObjectID2);
                }
                break;
            }
        }
    }

    private Table getMasterTable(MaterializedViewLog materializedViewLog) {
        DBObjectID dBObjectID = materializedViewLog.getMasterTableID();
        Table table = null;
        if (dBObjectID != null) {
            try {
                table = (Table)dBObjectID.resolveID();
            }
            catch (DBException dBException) {
                table = null;
            }
            if (table == null) {
                if ((dBObjectID = (DBObjectID)dBObjectID.copyTo(null)) instanceof BaseObjectID) {
                    ((BaseObjectID)dBObjectID).setProvider(this.getProvider(materializedViewLog));
                    ((BaseObjectID)dBObjectID).setSchemaName(this.getSchemaName(materializedViewLog));
                }
                try {
                    table = (Table)dBObjectID.resolveID();
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)this).warning(dBException.getMessage());
                }
            }
        }
        return table;
    }

    private DBObjectProvider getProvider(MaterializedViewLog materializedViewLog) {
        DBObjectProvider dBObjectProvider = null;
        if (materializedViewLog.getID() instanceof BaseObjectID && ((BaseObjectID)materializedViewLog.getID()).getProvider() != null) {
            dBObjectProvider = ((BaseObjectID)materializedViewLog.getID()).getProvider();
        } else if (this.getParentGenerator() instanceof SXMLReader) {
            SXMLReader sXMLReader = (SXMLReader)this.getParentGenerator();
            dBObjectProvider = sXMLReader.getProvider();
        }
        return dBObjectProvider;
    }

    private String getSchemaName(MaterializedViewLog materializedViewLog) {
        return materializedViewLog.getSchema().getName();
    }
}

