/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.validators.OracleTableValidator;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.db.validators.ViewValidator;

public class MaterializedViewValidator
extends OracleTableValidator<MaterializedView> {
    public MaterializedViewValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected void validateNameInUse(MaterializedView materializedView) throws NameInUseException {
        MaterializedView.PrebuiltType prebuiltType = materializedView.getOnPrebuilt();
        if (prebuiltType == null || prebuiltType == MaterializedView.PrebuiltType.NONE) {
            super.validateNameInUse((DBObject)materializedView);
        } else {
            super.validateNameInUse((DBObject)materializedView, DBObjectValidator.NamespaceType.TYPE);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"SQLQuery"}, level=ValidationLevel.FULL)
    public void validateQuery(MaterializedView materializedView, MaterializedView materializedView2) throws ValidationException {
        ViewValidator.validateQuery((SQLQueryOwner)materializedView2, this.getProvider());
    }

    @DBObjectValidator.PropertyValidator(value={"keyType"}, level=ValidationLevel.FULL)
    public void validateKeyType(MaterializedView materializedView, MaterializedView materializedView2) throws ValidationException {
        SQLQuery sQLQuery;
        if (MaterializedView.RefreshWith.ROWID.equals((Object)materializedView2.getKeyType()) && (sQLQuery = materializedView2.getSQLQuery()) != null && sQLQuery.getFromObjects().length > 0) {
            boolean bl = true;
            if (sQLQuery.getFromObjects().length != 1 || sQLQuery.getFromObjects()[0].getExpression() instanceof JoinObject || sQLQuery.getGroupByObject() != null || sQLQuery.getHierarchicalQueryObject() != null || sQLQuery.getSetOperator() != null) {
                bl = false;
            }
            if (bl) {
                for (SelectObject selectObject : sQLQuery.getSelectObjects()) {
                    Function function;
                    boolean bl2 = false;
                    if (!(selectObject.getExpression() instanceof Function) || !(function = (Function)selectObject.getExpression()).isDistinct() && !function.isGrouping()) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                throw new ValidationException((DBObject)materializedView2, APIBundle.get((String)"MVIEW_ERROR_INVALID_KEY_TYPE_ROWID"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"onPrebuilt"}, level=ValidationLevel.FULL)
    public void validateOnPrebuilt(MaterializedView materializedView, MaterializedView materializedView2) throws ValidationException {
        if (materializedView2.getOnPrebuilt() != null && materializedView == null && materializedView2.getOnPrebuilt() != MaterializedView.PrebuiltType.NONE) {
            Column[] columnArray;
            if (Boolean.TRUE.equals(materializedView2.getProperty("PARTITIONED TABLE"))) {
                throw new ValidationException((DBObject)materializedView2, APIBundle.get((String)"MVIEW_ERROR_PARTITIONS_AND_PREBUILT"));
            }
            DBObjectCriteria dBObjectCriteria = new DBObjectCriteria(Table.class, new String[]{"TABLE", "MATERIALIZED VIEW"});
            dBObjectCriteria.setSchema(DBUtil.getSchema((DBObject)materializedView2));
            dBObjectCriteria.setName(materializedView2.getName());
            Collection collection = null;
            try {
                collection = this.getProvider().listObjects(dBObjectCriteria);
            }
            catch (DBException dBException) {
                this.logException(dBException, Level.FINE);
            }
            if (collection == null || collection.size() != 1) {
                throw new ValidationException((DBObject)materializedView2, APIBundle.get((String)"MVIEW_ERROR_NO_PREBUILT_TABLE"));
            }
            Table table = (Table)collection.iterator().next();
            for (Column column : columnArray = materializedView2.getColumns()) {
                Column column2 = table.getColumn(column.getName());
                if (column2 != null) continue;
                throw new ValidationException((DBObject)materializedView2, APIBundle.format((String)"MVIEW_ERROR_NO_MATCHING_COLUMN", (Object[])new Object[]{column.getName()}));
            }
        }
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("buildType");
        collection.add("cache");
        collection.add("interval");
        collection.add("firstRefresh");
        collection.add("lastRefreshDate");
        collection.add("nextRefreshDate");
        collection.add("refreshMethod");
        collection.add("refreshMode");
        collection.add("queryRewrite");
        collection.add("rollbackSegmentType");
        collection.add("rollbackSegmentName");
        collection.add("staleness");
        collection.add("defaultIndex");
        collection.add("usingConstraints");
        return collection;
    }

    @Override
    public CascadeAction cascadeDelete(DBObject dBObject, MaterializedView materializedView) {
        CascadeAction cascadeAction = CascadeAction.NONE;
        cascadeAction = this.checkSchemaDelete(dBObject, (SchemaObject)materializedView) ? CascadeAction.DELETE : ViewValidator.cascadeDelete(dBObject, (SQLQueryOwner)materializedView, this.getProvider());
        return cascadeAction;
    }

    public CascadeAction cascadeUpdate(Difference difference, MaterializedView materializedView) throws DBException {
        CascadeAction cascadeAction = super.cascadeUpdate(difference, (DBObject)materializedView);
        if (cascadeAction == CascadeAction.UPDATE) {
            ViewValidator.resetDeclarativeQueryString((SQLQueryOwner)materializedView);
        }
        return cascadeAction;
    }
}

