/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.lang.invoke.StringConcatFactory;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationException;

public class SynonymValidator
extends SchemaObjectValidator<Synonym> {
    public SynonymValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("public");
        return collection;
    }

    @DBObjectValidator.PropertyValidator(value={"reference"})
    public void validateReference(Synonym synonym, Synonym synonym2) throws ValidationException {
        DBObjectID dBObjectID = synonym2.getReference();
        if (dBObjectID == null) {
            throw new ValidationException((DBObject)synonym2, APIBundle.format((String)"SYNONYM_ERROR_BAD_REF", (Object[])new Object[]{synonym2.getName(), StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"null"})}));
        }
        if (dBObjectID.equals(synonym2.getID(), false)) {
            throw new ValidationException((DBObject)synonym2, APIBundle.get((String)"SYNONYM_ERROR_LOOP"));
        }
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.SCHEMA;
    }
}

