/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.Collection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.View;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.RelationValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class ViewValidator
extends RelationValidator<View> {
    public ViewValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("forceOnCreate");
        return collection;
    }

    @DBObjectValidator.PropertyValidator(value={"SQLQuery", "queryString"}, path=true, level=ValidationLevel.FULL)
    public void validateView(View view, View view2) throws ValidationException {
        ViewValidator.validateQuery((SQLQueryOwner)view2, this.getProvider());
    }

    @DBObjectValidator.PropertyValidator(value={"restriction"}, level=ValidationLevel.FULL)
    public void validateQueryRestriction(View view, View view2) throws ValidationException {
        OrderByObject[] orderByObjectArray;
        View.Restriction restriction = view2.getRestriction();
        if (restriction != null && view2.isDeclarative() && (orderByObjectArray = view2.getSQLQuery().getOrderByObjects()) != null && orderByObjectArray.length > 0) {
            throw new ValidationException((DBObject)view2, APIBundle.format((String)"VIEW_ORDER_BY_RESTRICTION", (Object[])new Object[]{restriction}));
        }
    }

    @Override
    public CascadeAction cascadeDelete(DBObject dBObject, View view) {
        CascadeAction cascadeAction = CascadeAction.NONE;
        cascadeAction = this.checkSchemaDelete(dBObject, (SchemaObject)view) ? CascadeAction.DELETE : ViewValidator.cascadeDelete(dBObject, (SQLQueryOwner)view, this.getProvider());
        return cascadeAction;
    }

    public CascadeAction cascadeUpdate(Difference difference, View view) throws DBException {
        CascadeAction cascadeAction = super.cascadeUpdate(difference, (DBObject)view);
        if (cascadeAction == CascadeAction.UPDATE) {
            ViewValidator.resetDeclarativeQueryString((SQLQueryOwner)view);
        }
        return cascadeAction;
    }

    public static CascadeAction cascadeDelete(DBObject dBObject, SQLQueryOwner sQLQueryOwner, DBObjectProvider dBObjectProvider) {
        SQLQueryBuilder sQLQueryBuilder;
        Collection collection;
        CascadeAction cascadeAction = CascadeAction.NONE;
        SQLQuery sQLQuery = sQLQueryOwner.getSQLQuery();
        if (sQLQuery != null && sQLQuery.isDeclarative() && (collection = DBUtil.findUsagesIn((DBObject)dBObject, (DBObject)sQLQuery)) != null && !collection.isEmpty() && (sQLQueryBuilder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)dBObjectProvider)) != null) {
            cascadeAction = CascadeAction.UPDATE;
            DBObjectID dBObjectID = DBUtil.getOriginalID((DBObject)sQLQueryOwner);
            if (dBObjectID == null) {
                sQLQueryBuilder.ensureQueryNonDeclarative(sQLQueryOwner);
            } else {
                try {
                    SQLQueryOwner sQLQueryOwner2 = (SQLQueryOwner)dBObjectID.resolveID();
                    if (sQLQueryOwner2 != null) {
                        sQLQueryBuilder.ensureQueryNonDeclarative(sQLQueryOwner2);
                    }
                }
                catch (DBException dBException) {
                    DBLog.getLogger(ViewValidator.class).warning("Couldn't resolve dependent view's ID: " + dBException.getMessage());
                }
            }
        }
        return cascadeAction;
    }

    public static void resetDeclarativeQueryString(SQLQueryOwner sQLQueryOwner) {
        SQLQuery sQLQuery = sQLQueryOwner.getSQLQuery();
        if (sQLQuery.isDeclarative()) {
            sQLQuery.setQueryString(null);
        }
    }

    public static void buildAndResetQueryString(SQLQueryOwner sQLQueryOwner, DBObjectProvider dBObjectProvider) {
        SQLQuery sQLQuery = sQLQueryOwner.getSQLQuery();
        if (sQLQuery != null) {
            if (!sQLQuery.isDeclarative()) {
                DBObject dBObject = null;
                DBObjectID dBObjectID = sQLQueryOwner.getID();
                if (dBObjectID instanceof TemporaryObjectID) {
                    dBObject = TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)dBObjectID));
                }
                Schema schema = dBObject == null ? DBUtil.getSchema((DBObject)sQLQueryOwner) : DBUtil.getSchema((DBObject)dBObject);
                SQLQueryBuilder sQLQueryBuilder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)dBObjectProvider, (Schema)schema);
                try {
                    sQLQueryBuilder.buildQuery(sQLQuery.getQueryString());
                    SQLQuery sQLQuery2 = sQLQueryBuilder.getSQLQuery();
                    sQLQueryOwner.setSQLQuery(sQLQuery2);
                }
                catch (SQLQueryException sQLQueryException) {
                    DBLog.getLogger(ViewValidator.class).fine("Couldn't build query for " + sQLQueryOwner.getName());
                }
            }
            ViewValidator.resetDeclarativeQueryString(sQLQueryOwner);
        }
    }

    public static void validateQuery(SQLQueryOwner sQLQueryOwner, DBObjectProvider dBObjectProvider) throws ValidationException {
        block3: {
            SQLQuery sQLQuery = sQLQueryOwner.getSQLQuery();
            if (sQLQuery == null) {
                throw new ValidationException((DBObject)sQLQueryOwner, APIBundle.get((String)"VIEW_ERROR_MISSING_QUERY"));
            }
            SQLQueryBuilder sQLQueryBuilder = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)sQLQuery, (DBObjectProvider)dBObjectProvider);
            try {
                sQLQueryBuilder.buildQuery(sQLQuery);
            }
            catch (SQLQueryException sQLQueryException) {
                if (!sQLQuery.isDeclarative() && (!sQLQueryBuilder.matchesProvider() || !(sQLQueryException instanceof SQLParseException))) break block3;
                throw new ValidationException((DBObject)sQLQueryOwner, sQLQueryException.getMessage());
            }
        }
    }
}

