/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.ProxySelector;
import oracle.dbtools.http.SessionType;
import oracle.dbtools.http.auth.AuthenticationEngine;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Timeout;

public abstract class Client {
    private SessionType m_type;
    private CloseableHttpClient m_client;
    private AuthenticationEngine m_engine;

    protected Client(SessionType type) {
        this.m_type = type;
        this.init();
    }

    private void init() {
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)60000L)).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
        connMgr.setDefaultSocketConfig(socketConfig);
        connMgr.setDefaultMaxPerRoute(10);
        HttpClientBuilder builder = HttpClients.custom();
        builder.setConnectionManager((HttpClientConnectionManager)connMgr);
        builder.setUserAgent(this.getUserAgent());
        this.initProxy();
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        this.m_client = builder.build();
    }

    protected void initProxy() {
    }

    protected abstract String getUserAgent();

    public AuthenticationEngine getAuthenticationEngine() {
        if (this.m_engine == null) {
            this.m_engine = this.createAuthenticationEngine();
            this.m_engine.init(this);
        }
        return this.m_engine;
    }

    protected final void shutdownClient() {
        this.m_engine.init(this);
    }

    protected abstract AuthenticationEngine createAuthenticationEngine();

    public CloseableHttpResponse executeRequest(HttpUriRequest request) throws ClientProtocolException, IOException {
        return this.m_client.execute((ClassicHttpRequest)request);
    }

    public <T> T executeRequest(HttpUriRequest request, HttpClientResponseHandler<? extends T> handler) throws ClientProtocolException, IOException {
        return (T)this.m_client.execute((ClassicHttpRequest)request, handler);
    }

    public <T> T executeRequest(HttpUriRequest request, HttpClientResponseHandler<? extends T> handler, HttpClientContext clientContext) throws ClientProtocolException, IOException {
        return (T)this.m_client.execute((ClassicHttpRequest)request, (HttpContext)clientContext, handler);
    }

    public final SessionType getConnectionType() {
        return this.m_type;
    }

    public static Reader createReader(ClassicHttpResponse resp) {
        HttpEntity entity = resp.getEntity();
        try {
            return new BufferedReader(new InputStreamReader(entity.getContent()));
        }
        catch (Exception e) {
            return new StringReader("");
        }
    }
}

