/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.http.Client;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionCloseHandler;
import oracle.dbtools.http.SessionCreator;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.http.SessionType;

public abstract class SessionManager
implements SessionCloseHandler {
    private SessionType m_type;
    private Map<String, C> m_conns = new HashMap<String, C>();
    private Client mClient;

    protected SessionManager(SessionType type) {
        this.m_type = type;
    }

    protected SessionType getConnectionType() {
        return this.m_type;
    }

    public synchronized Client getClient() {
        if (this.mClient == null) {
            this.mClient = this.createClient();
        }
        return this.mClient;
    }

    protected abstract Client createClient();

    public abstract String[] listConnections();

    public abstract SessionInfo getConnectionInfo(String var1);

    public abstract void addConnection(String var1, SessionInfo var2) throws SessionException;

    public final void modifyConnection(String name, SessionInfo info) throws SessionException {
        this.closeConnection(name);
        this.modifyConnectionImpl(name, info);
    }

    protected abstract void modifyConnectionImpl(String var1, SessionInfo var2);

    public final void removeConnection(String name) {
        this.closeConnection(name);
        this.removeConnectionImpl(name);
    }

    protected abstract void removeConnectionImpl(String var1);

    protected abstract void notifyConnectionClosed(String var1);

    protected abstract void notifyConnectionOpened(String var1);

    protected boolean closeConnection(C conn) {
        if (conn.close()) {
            this.notifyConnectionClosed(conn.getName());
            return true;
        }
        return false;
    }

    public Session getConnection(String name, boolean force) throws SessionException {
        SessionInfo info;
        C conn = this.m_conns.get(name);
        if (conn == null && (info = this.getConnectionInfo(name)) != null) {
            conn = new C(info);
            this.m_conns.put(name, conn);
        }
        if (conn != null) {
            boolean nowOpen;
            boolean wasClosed = conn.m_conn == null;
            Session cc = conn.getConnection(force);
            boolean bl = nowOpen = conn.m_conn != null;
            if (wasClosed && nowOpen) {
                this.notifyConnectionOpened(conn.getName());
            }
            return cc;
        }
        return null;
    }

    public boolean closeConnection(String name) {
        boolean result = true;
        C conn = this.m_conns.get(name);
        if (conn != null) {
            result = this.closeConnection(conn);
            this.m_conns.remove(name);
        }
        return result;
    }

    @Override
    public void connectionClosed(String name) {
        C conn = this.m_conns.remove(name);
        if (conn != null) {
            this.closeConnection(conn);
        }
    }

    protected class C {
        private SessionInfo m_info;
        private Session m_conn;

        C(SessionInfo info) {
            this.m_info = info;
        }

        String getName() {
            return this.m_info.getName();
        }

        SessionInfo getInfo() {
            return this.m_info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Session getConnection(boolean force) throws SessionException {
            C c = this;
            synchronized (c) {
                if (this.m_conn == null && force) {
                    SessionCreator creator = SessionCreator.createSessionCreator(SessionManager.this);
                    this.m_conn = creator.createSession(this.m_info);
                    this.m_conn.setCloseHandler(SessionManager.this);
                }
            }
            return this.m_conn;
        }

        boolean close() {
            if (this.m_conn != null) {
                this.m_conn.close();
                this.m_conn = null;
            }
            return true;
        }
    }
}

