/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.build;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdevimpl.build.BuildQueue;
import oracle.jdevimpl.compiler.JCompilerUtils;

public class BuildAfterSave
implements EditorListener,
Controller {
    public static final String BUILD_PROJECT_AFTER_SAVE_CMD_NAME = "BUILD_PROJECT_AFTER_SAVE";
    public static final String BUILD_PROJECT_AND_DEPENDENTS_AFTER_SAVE_CMD_NAME = "BUILD_PROJECT_AND_DEPENDENTS_AFTER_SAVE";
    Map<Editor, Listener> editorToListener = new HashMap<Editor, Listener>();
    private Context buildContext;
    private static BuildAfterSave instance;

    private BuildAfterSave() {
    }

    public static synchronized BuildAfterSave getInstance() {
        if (instance == null) {
            instance = new BuildAfterSave();
        }
        return instance;
    }

    public void editorOpened(Editor editor) {
        Context context = editor.getContext();
        if (context == null) {
            return;
        }
        Workspace workspace = context.getWorkspace();
        Project project = context.getProject();
        Node node = context.getNode();
        if (workspace == null || project == null || node == null) {
            return;
        }
        Attributes attrs = project.getAttributes();
        if (attrs != null && !attrs.isSet(ElementAttributes.BUILDABLE)) {
            UnifiedBuildSystem.logger.trace("Project is not buildable");
            return;
        }
        if (!JCompiler.isBuildable((Element)node) && !JCompiler.isCopyable((Element)node, project)) {
            UnifiedBuildSystem.logger.trace("Node is not buildable/copyable");
            return;
        }
        Listener listener = new Listener(workspace, project, node);
        this.editorToListener.put(editor, listener);
        node.addNodeListener((NodeListener)listener);
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        Node node;
        Context context;
        Listener listener = this.editorToListener.remove(editor);
        if (listener != null && (context = editor.getContext()) != null && (node = context.getNode()) != null) {
            node.removeNodeListener((NodeListener)listener);
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        return this.isOurEvent(action);
    }

    public boolean update(IdeAction action, Context context) {
        return this.isOurEvent(action);
    }

    private boolean isOurEvent(IdeAction action) {
        int cmdId = action.getCommandId();
        return cmdId == Ide.findOrCreateCmdID((String)BUILD_PROJECT_AFTER_SAVE_CMD_NAME) || cmdId == Ide.findOrCreateCmdID((String)BUILD_PROJECT_AND_DEPENDENTS_AFTER_SAVE_CMD_NAME);
    }

    public void setBuildContext(Context context) {
        this.buildContext = context;
    }

    private class Listener
    extends NodeListener {
        private Workspace workspace;
        private Project project;
        private Node node;

        private Listener(Workspace workspace, Project project, Node node) {
            this.workspace = workspace;
            this.project = project;
            this.node = node;
        }

        public void nodeSaved(NodeEvent e) {
            Context context = BuildAfterSave.this.buildContext;
            if (context != null) {
                if (this.workspace == context.getWorkspace() || this.project == context.getProject()) {
                    return;
                }
                if (this.workspace == context.getNode() || this.project == context.getNode()) {
                    return;
                }
            }
            if (JCompilerUtils.isBuildAfterSave()) {
                if (this.node == e.getNode() && this.project != null && this.project.containsChild((Element)this.node)) {
                    BuildQueue.queueFile(this.workspace, this.project, this.node);
                } else {
                    UnifiedBuildSystem.logger.trace("BuildAfterSave rejected queueing: wrong node");
                }
            }
        }
    }
}

