/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.build;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.Assert;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdevimpl.build.BuildQueueBuilder;

public class BuildQueue {
    public static final String BUILD_QUEUE_BUILDER_CONTEXT = "BuildQueueBuilderContext";
    private static Timer timer;
    private static int count;
    private static BuildQueueBuilder buildQueueBuilder;
    private static List<Listener> listeners;
    private static List<BuildQueueBuilder.BuildContext> waitingFiles;
    private static boolean shutDown;
    private static ShutdownHook shutdownHook;

    public static synchronized void queueFile(Workspace workspace, Project project, Node node) {
        try {
            if (shutDown || Ide.isQuitting()) {
                UnifiedBuildSystem.logger.trace("BuildQueue rejected queueing because of shutdown");
                return;
            }
            if (workspace == null || project == null || node == null) {
                UnifiedBuildSystem.logger.trace("BuildQueue rejected queueing because of illegal arguments");
                throw new IllegalArgumentException("null argument for BuildQueue.queueFile");
            }
            UnifiedBuildSystem.logger.trace("BuildQueue queueing Node {0}", (Object)node.getLongLabel());
            if (shutdownHook == null) {
                shutdownHook = new ShutdownHook(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean canShutdown() {
                        Class<BuildQueue> clazz = BuildQueue.class;
                        synchronized (BuildQueue.class) {
                            shutDown = true;
                            if (timer != null) {
                                timer.cancel();
                            }
                            if (buildQueueBuilder != null) {
                                buildQueueBuilder.shutDown();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return true;
                        }
                    }

                    public void shutdown() {
                    }
                };
                ExitCommand.addShutdownHook((ShutdownHook)shutdownHook);
            }
            BuildQueue.addWaitingFile(workspace, project, node);
            BuildQueue.processWaitingFiles();
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
        }
    }

    private static synchronized void processWaitingFiles() {
        if (waitingFiles == null || waitingFiles.isEmpty()) {
            UnifiedBuildSystem.logger.trace("BuildQueue.processWaitingFiles, no waiting files");
            return;
        }
        count = 0;
        if (!shutDown && timer == null && buildQueueBuilder == null) {
            timer = new Timer("BuildQueue Timer");
            TimerTask task = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<BuildQueue> clazz = BuildQueue.class;
                    synchronized (BuildQueue.class) {
                        if (shutDown) {
                            this.cancel();
                            timer = null;
                            UnifiedBuildSystem.logger.trace("BuildQueue.timer.run(), cancel due to shutdown");
                        } else if (++count >= 5) {
                            this.cancel();
                            timer = null;
                            UnifiedBuildSystem.logger.trace("BuildQueue.timer.run(), new buildQueueBuilder, call listeners");
                            buildQueueBuilder = new BuildQueueBuilder(BuildQueue.class.getClassLoader());
                            if (listeners != null) {
                                for (Listener listener : listeners) {
                                    listener.queueBusy();
                                }
                            }
                            UnifiedBuildSystem.logger.trace("BuildQueue.timer.run(), add dirty editor files");
                            List editors = EditorManager.getEditorManager().getAllEditors();
                            for (Editor editor : editors) {
                                Context context = editor.getContext();
                                if (context == null) continue;
                                Workspace workspace = context.getWorkspace();
                                Project project = context.getProject();
                                Node node = context.getNode();
                                if (workspace == null || project == null || node == null || !node.isDirty()) continue;
                                BuildQueue.addWaitingFile(workspace, project, node);
                            }
                            UnifiedBuildSystem.logger.trace("BuildQueue.timer.run(), start buildQueueBuilder");
                            buildQueueBuilder.start();
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            };
            timer.schedule(task, 100L, 100L);
            UnifiedBuildSystem.logger.trace("BuildQueue.processWaitingFiles, scheduled new timer task");
        } else if (shutDown) {
            UnifiedBuildSystem.logger.trace("BuildQueue.processWaitingFiles, shutDown happened");
        } else if (timer != null) {
            UnifiedBuildSystem.logger.trace("BuildQueue.processWaitingFiles, timer not null");
        } else {
            UnifiedBuildSystem.logger.trace("BuildQueue.processWaitingFiles, buildQueueBuilder not null");
        }
    }

    private static synchronized void addWaitingFile(Workspace workspace, Project project, Node node) {
        if (waitingFiles == null) {
            waitingFiles = new ArrayList<BuildQueueBuilder.BuildContext>();
        }
        BuildQueueBuilder.BuildContext details = new BuildQueueBuilder.BuildContext();
        details.workspace = workspace;
        details.project = project;
        details.node = node;
        waitingFiles.add(details);
    }

    static synchronized List<BuildQueueBuilder.BuildContext> getWaitingFiles() {
        List<BuildQueueBuilder.BuildContext> currentlyWaitingFiles = waitingFiles;
        waitingFiles = null;
        return currentlyWaitingFiles;
    }

    static synchronized void queueBuildFinished() {
        UnifiedBuildSystem.logger.trace("BuildQueue.queueBuildFinished");
        if (shutdownHook != null) {
            ExitCommand.removeShutdownHook((ShutdownHook)shutdownHook);
            shutdownHook = null;
        }
        if (listeners != null) {
            for (Listener listener : listeners) {
                listener.queueNotBusy();
            }
        }
        buildQueueBuilder = null;
        UnifiedBuildSystem.logger.trace("BuildQueue.queueBuildFinished, buildQueueBuilder is null");
        BuildQueue.processWaitingFiles();
    }

    public static synchronized void addListener(Listener listener) {
        if (listeners == null) {
            listeners = new ArrayList<Listener>();
        }
        listeners.add(listener);
    }

    public static synchronized void removeListener(Listener listener) {
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                listeners = null;
            }
        }
    }

    public static interface Listener {
        public void queueBusy();

        public void queueNotBusy();
    }
}

