/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.nio.charset.Charset;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.json.common.ConnectionPool;

public class Configuration {
    public static final String PARAM_CACHING_ENABLED = "soda.cachingEnabled";
    public static final String PARAM_DROP_DISABLED = "soda.disableDropCollection";
    public static final String PARAM_MAX_LIMIT = "soda.maxLimit";
    public static final String PARAM_DEFAULT_LIMIT = "soda.defaultLimit";
    public static final String PARAM_PRINT_DEBUG_TO_SCREEN = "debug.printDebugToScreen";
    public static final String DEFAULT_ENCODING = "utf-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");
    public static final String ENV_XAP_HOME = "XAPHOME";
    public static final String ENV_CONFIG_FILE = "XAP_CONFIG";
    public static final String ENV_DATABASE = "XAP_DBNAME";
    public static final String ENV_USERPASS = "XAP_DBCONN";
    public static final String LOG_PROPERTIES_FILE = "log_properties";
    private static final String JDBC_DATABASE = "db_uri";
    private static final String JDBC_USERNAME = "db_username";
    private static final String JDBC_PASSWRD = "db_password";
    private static final String POOL_SIZE = "pool_size";
    private static final String CONTAINER_TYPE = "container_type";
    private static final int DEFAULT_CONNECTIONS = 4;
    private String dbUri = null;
    private String dbUser = null;
    private String dbPasswrd = null;
    private int poolSize = 4;
    private String containerType = null;
    private static final String POLL_INTERVAL = "poll_interval";
    private static final String MAX_THREADS = "max_threads";
    private static final long DEFAULT_INTERVAL = 1000L;
    private static final int DEFAULT_THREADS = 4;
    private static final long MIN_POLL_INTERVAL = 100L;
    private static final long MAX_POLL_INTERVAL = 10000L;
    private static final int MIN_NUM_THREADS = 1;
    private static final int MAX_NUM_THREADS = 64;
    private long pollInterval = 1000L;
    private int numThreads = 4;
    private boolean debugMode = false;
    private boolean cacheEnabled = false;
    private boolean dropDisabled = false;
    private boolean printDebugToScreen = false;
    public static final String SERVICE_NAME = "service_name";
    public static final String SERVICE_VERSION = "service_version";
    private static final String DEBUG_SETTING = "debug";
    private String serviceName = null;
    private String serviceVersion = null;
    private static final String PARAM_COOKIE_NAME = "session_cookie";
    private static final String PARAM_COOKIE_VALUE = "cookie_value";
    private String cookieName = null;
    private String cookieValue = null;
    public static final int MAXIMUM_NROWS = 1000;
    public static final int DEFAULT_NROWS = 100;
    public static final int UNLIMITED_ROWS = -1;
    private int limitMax = 1000;
    private int limitDefault = 100;
    private final Properties params;
    private static final Logger log = Logger.getLogger(Configuration.class.getName());

    public Configuration(Properties properties) {
        this.params = properties == null ? new Properties() : properties;
        if (properties != null) {
            this.importParameters(properties);
        } else {
            this.importEnvironment();
        }
    }

    private long getLongParameter(String string, long l) {
        long l2;
        if (string == null) {
            return l;
        }
        try {
            l2 = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            log.warning(numberFormatException.getMessage());
            l2 = l;
        }
        return l2;
    }

    private int convertLimitValue(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if ("unlimited".equalsIgnoreCase(string)) {
            return -1;
        }
        int n2 = this.getIntParameter(string, n);
        if (n2 < 0) {
            log.warning("Invalid value: " + n2);
            return n;
        }
        return n2;
    }

    private int getIntParameter(String string, int n) {
        int n2;
        if (string == null) {
            return n;
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            log.warning(numberFormatException.getMessage());
            n2 = n;
        }
        return n2;
    }

    private synchronized void importParameters(Properties properties) {
        this.dbUri = properties.getProperty(JDBC_DATABASE);
        this.dbUser = properties.getProperty(JDBC_USERNAME);
        this.dbPasswrd = properties.getProperty(JDBC_PASSWRD);
        this.poolSize = this.getIntParameter(properties.getProperty(POOL_SIZE), this.poolSize);
        this.containerType = properties.getProperty(CONTAINER_TYPE);
        this.pollInterval = this.getLongParameter(properties.getProperty(POLL_INTERVAL), this.pollInterval);
        if (this.pollInterval < 100L) {
            this.pollInterval = 100L;
        } else if (this.pollInterval > 10000L) {
            this.pollInterval = 10000L;
        }
        this.numThreads = this.getIntParameter(properties.getProperty(MAX_THREADS), this.numThreads);
        if (this.numThreads < 1) {
            this.numThreads = 1;
        } else if (this.numThreads > 64) {
            this.numThreads = 64;
        }
        this.cookieName = properties.getProperty(PARAM_COOKIE_NAME);
        this.cookieValue = properties.getProperty(PARAM_COOKIE_VALUE);
        this.serviceName = properties.getProperty(SERVICE_NAME);
        this.serviceVersion = properties.getProperty(SERVICE_VERSION);
        String string = properties.getProperty(DEBUG_SETTING);
        if (string != null && string.equalsIgnoreCase("true")) {
            this.debugMode = true;
        }
        this.setLimitDefaultParam(properties.getProperty(PARAM_DEFAULT_LIMIT));
        this.setLimitMaxParam(properties.getProperty(PARAM_MAX_LIMIT));
        this.setCacheEnabledParam(properties.getProperty(PARAM_CACHING_ENABLED));
        this.setDropDisabledParam(properties.getProperty(PARAM_DROP_DISABLED));
        this.setPrintDebugToScreenParam(properties.getProperty(PARAM_PRINT_DEBUG_TO_SCREEN));
    }

    public void setLimitMaxParam(String string) {
        if (string == null) {
            return;
        }
        this.setLimitMax(this.convertLimitValue(string, 1000));
    }

    public void setLimitDefaultParam(String string) {
        if (string == null) {
            return;
        }
        this.setLimitDefault(this.convertLimitValue(string, 100));
    }

    public void setCacheEnabledParam(String string) {
        if (string == null) {
            return;
        }
        this.setCacheEnabled(Boolean.valueOf(string));
    }

    public void setDropDisabledParam(String string) {
        if (string == null) {
            return;
        }
        this.setDropDisabled(Boolean.valueOf(string));
    }

    public void setPrintDebugToScreenParam(String string) {
        if (string == null) {
            return;
        }
        this.setPrintDebugToScreen(Boolean.valueOf(string));
    }

    public void setCacheEnabled(boolean bl) {
        this.cacheEnabled = bl;
    }

    public void setDropDisabled(boolean bl) {
        this.dropDisabled = bl;
    }

    public void setPrintDebugToScreen(boolean bl) {
        this.printDebugToScreen = bl;
    }

    public void setLimitMax(int n) {
        this.limitMax = n > 0 ? n : -1;
    }

    public void setLimitDefault(int n) {
        this.limitDefault = n > 0 ? n : -1;
    }

    private synchronized void importEnvironment() {
        String string = System.getProperty(ENV_USERPASS, null);
        this.dbUri = System.getProperty(ENV_DATABASE, null);
        if (string != null) {
            int n = string.indexOf(47);
            if (n < 0) {
                this.dbUser = string;
                this.dbPasswrd = "";
            } else {
                this.dbUser = string.substring(0, n);
                this.dbPasswrd = n == string.length() ? "" : string.substring(n + 1);
            }
        }
        if (this.dbUri != null) {
            this.params.setProperty(JDBC_DATABASE, this.dbUri);
        }
        if (this.dbUser != null) {
            this.params.setProperty(JDBC_USERNAME, this.dbUser);
        }
        if (this.dbPasswrd != null) {
            this.params.setProperty(JDBC_PASSWRD, this.dbPasswrd);
        }
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public String getCookieValue() {
        return this.cookieValue;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public boolean getDebugSetting() {
        return this.debugMode;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public boolean isDropDisabled() {
        return this.dropDisabled;
    }

    public boolean isPrintDebugToScreen() {
        return this.printDebugToScreen;
    }

    public String getContainerType() {
        return this.containerType;
    }

    public int getLimitMax() {
        return this.limitMax;
    }

    public int getLimitDefault() {
        return this.limitDefault;
    }

    public void setServiceInfo(String string, String string2) {
        if (this.serviceName == null && string != null) {
            this.serviceName = string;
        }
        if (this.serviceVersion == null && string2 != null) {
            this.serviceVersion = string2;
        }
    }

    public String getParameter(String string) {
        String string2 = null;
        if (this.params != null) {
            string2 = this.params.getProperty(string, null);
        }
        if (string2 == null) {
            string2 = System.getProperty(string.toUpperCase());
        }
        return string2;
    }

    protected ConnectionPool createConnectionPool() {
        ConnectionPool connectionPool = this.poolSize <= 0 ? new ConnectionPool(this.dbUri, this.dbUser, this.dbPasswrd) : new ConnectionPool(this.dbUri, this.dbUser, this.dbPasswrd, this.poolSize);
        return connectionPool;
    }
}

