/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class OracleLog {
    private static final String TRACE_PROPERTY = "oracle.soda.trace";
    private static volatile boolean loggingEnabled = false;

    private static void initialize() {
        try {
            String string = OracleLog.getSystemProperty(TRACE_PROPERTY);
            if (string != null && string.equalsIgnoreCase("true")) {
                loggingEnabled = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static String getSystemProperty(final String string) {
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string, null);
            }
        });
        return string2;
    }

    public static boolean isLoggingEnabled() {
        return loggingEnabled;
    }

    public static void enableLogging() {
        loggingEnabled = true;
    }

    static {
        OracleLog.initialize();
    }
}

