/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.parser.DocumentLoader;
import oracle.json.parser.IndexColumn;
import oracle.json.parser.JsonQueryPath;
import oracle.json.parser.PathParser;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;

public class IndexSpecification {
    private final InputStream source;
    private final JsonFactoryProvider jProvider;
    private boolean is_parsed = false;
    private String idxName = null;
    private String language = null;
    private IndexColumn[] columns = new IndexColumn[0];
    private boolean is_unique = false;
    private boolean is_scalarRequired = false;
    private boolean is_lax = false;
    private JsonQueryPath spatial = null;
    private String search_on = null;
    private boolean is_121_text_index_with_lang = false;
    private String dataguide = null;
    private boolean indexNulls = false;
    private boolean force = false;

    public IndexSpecification(JsonFactoryProvider jsonFactoryProvider, InputStream inputStream) {
        this.jProvider = jsonFactoryProvider;
        this.source = inputStream;
    }

    private void makeAndThrowException(QueryMessage queryMessage, Object ... objectArray) throws QueryException {
        QueryException.throwSyntaxException(queryMessage, objectArray);
    }

    private void close() throws QueryException {
        try {
            this.source.close();
        }
        catch (IOException iOException) {
            throw new QueryException(QueryMessage.EX_INVALID_INDEX_SPEC.get(new Object[0]), iOException);
        }
    }

    public String parse(boolean bl, boolean bl2) throws QueryException {
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        QueryException queryException = null;
        try {
            if (this.source == null) {
                this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_SPEC, new Object[0]);
            }
            DocumentLoader documentLoader = new DocumentLoader(this.jProvider, this.source);
            JsonObject jsonObject = (JsonObject)documentLoader.parse();
            this.close();
            ArrayList<IndexColumn> arrayList = new ArrayList<IndexColumn>();
            for (Map.Entry entry : jsonObject.entrySet()) {
                Iterator iterator;
                String string;
                String string2 = (String)entry.getKey();
                JsonValue jsonValue = (JsonValue)entry.getValue();
                JsonValue.ValueType valueType = jsonValue.getValueType();
                if (string2.equalsIgnoreCase("name")) {
                    if (valueType != JsonValue.ValueType.STRING) {
                        this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "index name", "STRING", valueType.toString());
                    }
                    this.idxName = ((JsonString)jsonValue).getString();
                    continue;
                }
                if (string2.equalsIgnoreCase("unique")) {
                    if (valueType == JsonValue.ValueType.TRUE) {
                        this.is_unique = true;
                    } else if (valueType == JsonValue.ValueType.FALSE) {
                        this.is_unique = false;
                    } else {
                        this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "unique", "BOOLEAN", valueType.toString());
                    }
                    bl3 = true;
                    continue;
                }
                if (string2.equalsIgnoreCase("scalarRequired")) {
                    if (valueType == JsonValue.ValueType.TRUE) {
                        this.is_scalarRequired = true;
                    } else if (valueType == JsonValue.ValueType.FALSE) {
                        this.is_scalarRequired = false;
                    } else {
                        this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "scalarRequired", "BOOLEAN", valueType.toString());
                    }
                    if (this.is_lax && this.is_scalarRequired) {
                        this.makeAndThrowException(QueryMessage.EX_SCALAR_AND_LAX, new Object[0]);
                    }
                    bl4 = true;
                    continue;
                }
                if (string2.equalsIgnoreCase("lax")) {
                    if (valueType == JsonValue.ValueType.TRUE) {
                        this.is_lax = true;
                    } else if (valueType == JsonValue.ValueType.FALSE) {
                        this.is_lax = false;
                    } else {
                        this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "lax", "BOOLEAN", valueType.toString());
                    }
                    if (this.is_lax && this.is_scalarRequired) {
                        this.makeAndThrowException(QueryMessage.EX_SCALAR_AND_LAX, new Object[0]);
                    }
                    bl5 = true;
                    continue;
                }
                if (string2.equalsIgnoreCase("indexNulls")) {
                    if (valueType == JsonValue.ValueType.TRUE) {
                        this.indexNulls = true;
                    } else if (valueType == JsonValue.ValueType.FALSE) {
                        this.indexNulls = false;
                    } else {
                        this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "indexNulls", "BOOLEAN", valueType.toString());
                    }
                    bl6 = true;
                    continue;
                }
                if (string2.equalsIgnoreCase("language")) {
                    if (valueType != JsonValue.ValueType.STRING) {
                        this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "language", "STRING", valueType.toString());
                    }
                    this.language = ((JsonString)jsonValue).getString();
                    continue;
                }
                if (string2.equalsIgnoreCase("dataguide")) {
                    if (valueType != JsonValue.ValueType.STRING) {
                        this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "dataguide", "STRING", valueType.toString());
                    }
                    this.dataguide = ((JsonString)jsonValue).getString();
                    if (this.dataguide.equalsIgnoreCase("on") || this.dataguide.equalsIgnoreCase("off")) continue;
                    this.makeAndThrowException(QueryMessage.EX_BAD_DATAGUIDE_VALUE, this.dataguide);
                    continue;
                }
                if (string2.equalsIgnoreCase("search_on")) {
                    if (valueType != JsonValue.ValueType.STRING) {
                        this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "search_on", "STRING", valueType.toString());
                    }
                    this.search_on = ((JsonString)jsonValue).getString();
                    if (this.search_on.equalsIgnoreCase("text") || this.search_on.equalsIgnoreCase("text_value") || this.search_on.equalsIgnoreCase("none")) continue;
                    this.makeAndThrowException(QueryMessage.EX_BAD_SEARCH_ON_VALUE, this.search_on);
                    continue;
                }
                if (string2.equalsIgnoreCase("textIndex121WithLang")) {
                    if (valueType == JsonValue.ValueType.TRUE) {
                        this.is_121_text_index_with_lang = true;
                        continue;
                    }
                    if (valueType == JsonValue.ValueType.FALSE) {
                        this.is_121_text_index_with_lang = false;
                        continue;
                    }
                    this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "textIndex121WithLang", "BOOLEAN", valueType.toString());
                    continue;
                }
                if (string2.equalsIgnoreCase("force") && bl2) {
                    if (valueType == JsonValue.ValueType.TRUE) {
                        this.force = true;
                        continue;
                    }
                    if (valueType == JsonValue.ValueType.FALSE) {
                        this.force = false;
                        continue;
                    }
                    this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "force", "BOOLEAN", valueType.toString());
                    continue;
                }
                if (string2.equalsIgnoreCase("spatial")) {
                    if (valueType != JsonValue.ValueType.STRING) {
                        this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "spatial", "STRING", valueType.toString());
                    }
                    string = ((JsonString)jsonValue).getString();
                    this.spatial = new JsonQueryPath(string);
                    continue;
                }
                if (!string2.equalsIgnoreCase("fields")) continue;
                if (valueType != JsonValue.ValueType.ARRAY) {
                    this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields", "ARRAY", valueType.toString());
                }
                if (!(iterator = (string = (JsonArray)jsonValue).iterator()).hasNext()) {
                    this.makeAndThrowException(QueryMessage.EX_FIELDS_CANNOT_BE_EMPTY, new Object[0]);
                }
                while (iterator.hasNext()) {
                    String[] stringArray;
                    JsonValue jsonValue2 = (JsonValue)iterator.next();
                    if (jsonValue2.getValueType() != JsonValue.ValueType.OBJECT) {
                        this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "field", "OBJECT", jsonValue2.getValueType().toString());
                    }
                    JsonObject jsonObject2 = (JsonObject)jsonValue2;
                    IndexColumn indexColumn = new IndexColumn();
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    int n = 0;
                    boolean bl7 = false;
                    Object object = jsonObject2.entrySet().iterator();
                    while (object.hasNext()) {
                        stringArray = (String[])object.next();
                        String string6 = (String)stringArray.getKey();
                        JsonValue jsonValue3 = (JsonValue)stringArray.getValue();
                        JsonValue.ValueType valueType2 = jsonValue3.getValueType();
                        if (string6.equalsIgnoreCase("path")) {
                            if (valueType2 != JsonValue.ValueType.STRING) {
                                this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields.path", "STRING", valueType2.toString());
                            }
                            string3 = ((JsonString)jsonValue3).getString();
                            continue;
                        }
                        if (string6.equalsIgnoreCase("datatype")) {
                            if (valueType2 != JsonValue.ValueType.STRING) {
                                this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields.datatype", "STRING", valueType2.toString());
                            }
                            string4 = ((JsonString)jsonValue3).getString();
                            continue;
                        }
                        if (string6.equalsIgnoreCase("maxLength")) {
                            JsonNumber jsonNumber;
                            bl7 = true;
                            if (valueType2 != JsonValue.ValueType.NUMBER) {
                                this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields.maxLength", "NUMBER", valueType2.toString());
                            }
                            if (!(jsonNumber = (JsonNumber)jsonValue3).isIntegral()) {
                                this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields.maxLength", "integer", "decimal");
                            }
                            n = jsonNumber.intValue();
                            continue;
                        }
                        if (!string6.equalsIgnoreCase("order")) continue;
                        if (valueType2 == JsonValue.ValueType.STRING) {
                            string5 = ((JsonString)jsonValue3).getString();
                            if (string5.equalsIgnoreCase("asc") || string5.equalsIgnoreCase("desc") || string5.equals("1") || string5.equals("-1")) continue;
                            this.makeAndThrowException(QueryMessage.EX_WRONG_ORDER, string5);
                            continue;
                        }
                        if (valueType2 == JsonValue.ValueType.NUMBER) {
                            string5 = ((JsonNumber)jsonValue3).toString();
                            if (string5.equals("-1") || string5.equals("1")) continue;
                            this.makeAndThrowException(QueryMessage.EX_WRONG_ORDER, string5);
                            continue;
                        }
                        this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields.order", "STRING", valueType2.toString());
                    }
                    if (string3 == null) {
                        this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_MISSING, "fields.path");
                    }
                    if ((stringArray = ((PathParser)(object = new PathParser(string3))).splitAndSQLEscape()) == null) {
                        this.makeAndThrowException(QueryMessage.EX_INDEX_ILLEGAL_PATH, string3);
                    }
                    indexColumn.setPath(stringArray);
                    if (string4 != null) {
                        int n2 = indexColumn.setSqlType(string4);
                        if (n2 == 0) {
                            this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_DTYPE, string4);
                        } else if (n2 != 1 && bl7) {
                            this.makeAndThrowException(QueryMessage.EX_LENGTH_NOT_ALLOWED, string3);
                        }
                    }
                    if (n > 0) {
                        indexColumn.setMaxLength(n);
                    } else if (n < 0) {
                        this.makeAndThrowException(QueryMessage.EX_INVALID_INDEX_DLEN, Integer.toString(n));
                    }
                    indexColumn.setOrder(string5);
                    arrayList.add(indexColumn);
                    indexColumn = null;
                }
            }
            int n = arrayList.size();
            if (n > 0) {
                if (this.language != null) {
                    this.makeAndThrowException(QueryMessage.EX_LANGUAGE_NOT_EXPECTED, new Object[0]);
                }
                this.columns = new IndexColumn[n];
                this.columns = arrayList.toArray(this.columns);
            } else if (n == 0) {
                if (bl3) {
                    this.makeAndThrowException(QueryMessage.EX_FIELDS_REQUIRED, "unique");
                }
                if (bl6) {
                    this.makeAndThrowException(QueryMessage.EX_FIELDS_REQUIRED, "indexNulls");
                }
                if (this.spatial == null) {
                    if (bl4) {
                        this.makeAndThrowException(QueryMessage.EX_FIELDS_OR_SPATIAL_REQUIRED, "scalarRequired");
                    } else if (bl5) {
                        this.makeAndThrowException(QueryMessage.EX_FIELDS_OR_SPATIAL_REQUIRED, "lax");
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new QueryException(QueryMessage.EX_INVALID_INDEX_SPEC.get(new Object[0]), illegalArgumentException);
        }
        catch (JsonParsingException jsonParsingException) {
            throw new QueryException(QueryMessage.EX_INVALID_INDEX_SPEC.get(new Object[0]), (Exception)((Object)jsonParsingException));
        }
        catch (JsonException jsonException) {
            throw new QueryException(QueryMessage.EX_INVALID_INDEX_SPEC.get(new Object[0]), (Exception)((Object)jsonException));
        }
        finally {
            try {
                this.close();
            }
            catch (QueryException queryException2) {
                queryException = queryException2;
            }
        }
        if (queryException != null) {
            throw queryException;
        }
        if (this.columns.length > 0) {
            if (this.spatial != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "fields", "spatial");
            }
            if (this.language != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "fields", "language");
            }
            if (this.search_on != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "fields", "search_on");
            }
            if (this.dataguide != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "fields", "dataguide");
            }
            if (this.is_121_text_index_with_lang) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "fields", "textIndex121WithLang");
            }
        } else if (this.spatial != null) {
            if (this.language != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "spatial", "language");
            }
            if (this.search_on != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "spatial", "search_on");
            }
            if (this.dataguide != null) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "spatial", "dataguide");
            }
            if (this.is_121_text_index_with_lang) {
                this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "spatial", "textIndex121WithLang");
            }
        } else if (this.search_on != null && this.is_121_text_index_with_lang) {
            this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "search_on", "textIndex121WithLang");
        } else if (this.dataguide != null && this.is_121_text_index_with_lang) {
            this.makeAndThrowException(QueryMessage.EX_INCOMPATIBLE_FIELDS, "dataguide", "textIndex121WithLang");
        }
        if (bl && this.idxName == null) {
            this.makeAndThrowException(QueryMessage.EX_INDEX_PROP_MISSING, "name");
        }
        this.is_parsed = true;
        return this.idxName;
    }

    public String parse() throws QueryException {
        return this.parse(true, false);
    }

    public String getName() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.idxName;
    }

    public String getLanguage() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.language;
    }

    public boolean isUnique() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.is_unique;
    }

    public JsonQueryPath getSpatialPath() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.spatial;
    }

    public String getSearchOn() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.search_on;
    }

    public String getDataGuide() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.dataguide;
    }

    public boolean isScalarRequired() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.is_scalarRequired;
    }

    public boolean isLax() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.is_lax;
    }

    public boolean indexNulls() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.indexNulls;
    }

    public boolean force() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.force;
    }

    public IndexColumn[] getColumns() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.columns;
    }

    public boolean is121TextIndexWithLang() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.is_121_text_index_with_lang;
    }

    public static String get121Lexer(String string) throws QueryException {
        String string2 = null;
        if (string == null) {
            string2 = "CTXSYS.JSONREST_ENGLISH_LEXER";
        } else if (string.equalsIgnoreCase("english")) {
            string2 = "CTXSYS.JSONREST_ENGLISH_LEXER";
        } else if (string.equalsIgnoreCase("arabic")) {
            string2 = "CTXSYS.JSONREST_ARABIC_LEXER";
        } else if (string.equalsIgnoreCase("nynorsk")) {
            string2 = "CTXSYS.JSONREST_NYNORSK_LEXER";
        } else if (string.equalsIgnoreCase("bokmal")) {
            string2 = "CTXSYS.JSONREST_BOKMAL_LEXER";
        } else if (string.equalsIgnoreCase("persian")) {
            string2 = "CTXSYS.JSONREST_PERSIAN_LEXER";
        } else if (string.equalsIgnoreCase("croatian")) {
            string2 = "CTXSYS.JSONREST_CROATIAN_LEXER";
        } else if (string.equalsIgnoreCase("serbian")) {
            string2 = "CTXSYS.JSONREST_SERBIAN_LEXER";
        } else if (string.equalsIgnoreCase("danish")) {
            string2 = "CTXSYS.JSONREST_DANISH_LEXER";
        } else if (string.equalsIgnoreCase("slovak")) {
            string2 = "CTXSYS.JSONREST_SLOVAK_LEXER";
        } else if (string.equalsIgnoreCase("finnish")) {
            string2 = "CTXSYS.JSONREST_FINNISH_LEXER";
        } else if (string.equalsIgnoreCase("slovenian")) {
            string2 = "CTXSYS.JSONREST_SLOVENIAN_LEXER";
        } else if (string.equalsIgnoreCase("hebrew")) {
            string2 = "CTXSYS.JSONREST_HEBREW_LEXER";
        } else if (string.equalsIgnoreCase("thai")) {
            string2 = "CTXSYS.JSONREST_THAI_LEXER";
        } else if (string.equalsIgnoreCase("catalan")) {
            string2 = "CTXSYS.JSONREST_CATALAN_LEXER";
        } else if (string.equalsIgnoreCase("korean")) {
            string2 = "CTXSYS.JSONREST_KOREAN_LEXER";
        } else if (string.equalsIgnoreCase("czech")) {
            string2 = "CTXSYS.JSONREST_CZECH_LEXER";
        } else if (string.equalsIgnoreCase("polish")) {
            string2 = "CTXSYS.JSONREST_POLISH_LEXER";
        } else if (string.equalsIgnoreCase("dutch")) {
            string2 = "CTXSYS.JSONREST_DUTCH_LEXER";
        } else if (string.equalsIgnoreCase("portuguese")) {
            string2 = "CTXSYS.JSONREST_PORTUGUESE_LEXER";
        } else if (string.equalsIgnoreCase("romanian")) {
            string2 = "CTXSYS.JSONREST_ROMANIAN_LEXER";
        } else if (string.equalsIgnoreCase("french")) {
            string2 = "CTXSYS.JSONREST_FRENCH_LEXER";
        } else if (string.equalsIgnoreCase("russian")) {
            string2 = "CTXSYS.JSONREST_RUSSIAN_LEXER";
        } else if (string.equalsIgnoreCase("german")) {
            string2 = "CTXSYS.JSONREST_GERMAN_LEXER";
        } else if (string.equalsIgnoreCase("simp-chinese")) {
            string2 = "CTXSYS.JSONREST_SCHINESE_LEXER";
        } else if (string.equalsIgnoreCase("trad-chinese")) {
            string2 = "CTXSYS.JSONREST_TCHINESE_LEXER";
        } else if (string.equalsIgnoreCase("greek")) {
            string2 = "CTXSYS.JSONREST_GREEK_LEXER";
        } else if (string.equalsIgnoreCase("spanish")) {
            string2 = "CTXSYS.JSONREST_SPANISH_LEXER";
        } else if (string.equalsIgnoreCase("hungarian")) {
            string2 = "CTXSYS.JSONREST_HUNGARIAN_LEXER";
        } else if (string.equalsIgnoreCase("swedish")) {
            string2 = "CTXSYS.JSONREST_SWEDISH_LEXER";
        } else if (string.equalsIgnoreCase("italian")) {
            string2 = "CTXSYS.JSONREST_ITALIAN_LEXER";
        } else if (string.equalsIgnoreCase("japanese")) {
            string2 = "CTXSYS.JSONREST_JAPANESE_LEXER";
        } else if (string.equalsIgnoreCase("turkish")) {
            string2 = "CTXSYS.JSONREST_TURKISH_LEXER";
        } else {
            QueryException.throwSyntaxException(QueryMessage.EX_INVALID_INDEX_LANG, string);
        }
        return string2;
    }

    public static String getLexer(String string) throws QueryException {
        String string2 = null;
        if (string == null) {
            string2 = null;
        } else if (string.equalsIgnoreCase("english")) {
            string2 = null;
        } else if (string.equalsIgnoreCase("danish")) {
            string2 = "DANISH";
        } else if (string.equalsIgnoreCase("finnish")) {
            string2 = "FINNISH";
        } else if (string.equalsIgnoreCase("dutch")) {
            string2 = "DUTCH";
        } else if (string.equalsIgnoreCase("portuguese")) {
            string2 = "PORTUGUESE";
        } else if (string.equalsIgnoreCase("romanian")) {
            string2 = "ROMANIAN";
        } else if (string.equalsIgnoreCase("german")) {
            string2 = "GERMAN";
        } else if (string.equalsIgnoreCase("simplified_chinese")) {
            string2 = "SIMPLIFIED_CHINESE";
        } else if (string.equalsIgnoreCase("traditional_chinese")) {
            string2 = "TRADITIONAL_CHINESE";
        } else if (string.equalsIgnoreCase("korean")) {
            string2 = "KOREAN";
        } else if (string.equalsIgnoreCase("swedish")) {
            string2 = "SWEDISH";
        } else if (string.equalsIgnoreCase("japanese")) {
            string2 = "JAPANESE";
        } else if (string.equalsIgnoreCase("german_din")) {
            string2 = "GERMAN_DIN";
        } else if (string.equalsIgnoreCase("norwegian")) {
            string2 = "NORWEGIAN";
        } else if (string.equalsIgnoreCase("catalan")) {
            string2 = "CATALAN";
        } else if (string.equalsIgnoreCase("french")) {
            string2 = "FRENCH";
        } else if (string.equalsIgnoreCase("spanish")) {
            string2 = "SPANISH";
        } else if (string.equalsIgnoreCase("italian")) {
            string2 = "ITALIAN";
        } else if (string.equalsIgnoreCase("brazilian_portuguese")) {
            string2 = "BRAZILIAN_PORTUGUESE";
        } else if (string.equalsIgnoreCase("french_canadian")) {
            string2 = "FRENCH_CANADIAN";
        } else if (string.equalsIgnoreCase("latin_american_spanish")) {
            string2 = "LATIN_AMERICAN_SPANISH";
        } else if (string.equalsIgnoreCase("mexican_spanish")) {
            string2 = "MEXICAN_SPANISH";
        } else {
            QueryException.throwSyntaxException(QueryMessage.EX_INVALID_INDEX_LANG, string);
        }
        return string2;
    }
}

