/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import oracle.json.parser.JsonQueryPath;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;

public class SpatialClause {
    static final String SPATIAL_DEFAULT_UNIT = "mile";
    static final String SPATIAL_DEFAULT_TOLERANCE = "0.05";
    private final JsonQueryPath spatialPath;
    private final String spatialOperator;
    private final String spatialReference;
    private final String spatialDistance;
    private final boolean notFlag;
    private final String errorClause;

    SpatialClause(String string, boolean bl, JsonQueryPath jsonQueryPath, String string2, String string3, String string4) {
        this.spatialOperator = string;
        this.spatialPath = jsonQueryPath;
        this.spatialReference = string2;
        this.spatialDistance = string3;
        this.notFlag = bl;
        this.errorClause = string4;
    }

    public JsonQueryPath getPath() {
        return this.spatialPath;
    }

    public String getOperator() {
        return this.spatialOperator;
    }

    public String getReference() {
        return this.spatialReference;
    }

    public String getDistance() {
        return this.spatialDistance;
    }

    public String getErrorClause() {
        return this.errorClause;
    }

    public boolean isNot() {
        return this.notFlag;
    }

    static String buildDistance(String string, String string2) throws QueryException {
        if (string == null) {
            QueryException.throwSyntaxException(QueryMessage.EX_SYNTAX_ERROR, new Object[0]);
        }
        if (string2 == null) {
            string2 = SPATIAL_DEFAULT_UNIT;
        }
        return "distance=" + string + " unit=" + string2;
    }

    static String sdoOperatorFor(String string) throws QueryException {
        if (string.equals("$near")) {
            return "SDO_WITHIN_DISTANCE";
        }
        if (string.equals("$within")) {
            return "SDO_INSIDE";
        }
        if (string.equals("$intersects")) {
            return "SDO_ANYINTERACT";
        }
        QueryException.throwSyntaxException(QueryMessage.EX_NOT_AN_OPERATOR, string);
        return null;
    }
}

