/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.math.BigDecimal;
import oracle.json.util.ComponentTime;

public class ValueTypePair {
    private String stringValue;
    private boolean booleanValue;
    private BigDecimal numberValue;
    private boolean dateFlag = false;
    private boolean timestampFlag = false;
    private final int type;
    public static final int TYPE_NUMBER = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_BOOLEAN = 3;
    public static final int TYPE_NULL = 4;

    ValueTypePair(int n) {
        this.type = n;
    }

    ValueTypePair(String string, int n) {
        this(n);
        this.stringValue = string;
    }

    ValueTypePair(boolean bl, int n) {
        this(n);
        this.booleanValue = bl;
    }

    ValueTypePair(BigDecimal bigDecimal, int n) {
        this(n);
        this.numberValue = bigDecimal;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public BigDecimal getNumberValue() {
        return this.numberValue;
    }

    public int getType() {
        return this.type;
    }

    void setBooleanValue(boolean bl) {
        this.booleanValue = bl;
    }

    void setStringValue(String string) {
        this.stringValue = string;
    }

    void setNumberValue(BigDecimal bigDecimal) {
        this.numberValue = bigDecimal;
    }

    public boolean isTimestamp() {
        return this.timestampFlag;
    }

    public boolean isDate() {
        return this.dateFlag;
    }

    public static String getStringType(int n) {
        String string;
        switch (n) {
            case 2: {
                string = "String";
                break;
            }
            case 3: {
                string = "Boolean";
                break;
            }
            case 1: {
                string = "Number";
                break;
            }
            case 4: {
                string = "Null";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    static ValueTypePair makeTemporal(ValueTypePair valueTypePair, boolean bl) {
        if (valueTypePair.getType() == 1) {
            BigDecimal bigDecimal = valueTypePair.getNumberValue();
            String string = ComponentTime.millisToString(bigDecimal.longValue());
            valueTypePair = new ValueTypePair(string, 2);
        }
        if (bl) {
            valueTypePair.timestampFlag = true;
        } else {
            valueTypePair.dateFlag = true;
        }
        return valueTypePair;
    }
}

