/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.json.common.MetricsCollector;
import oracle.json.logging.OracleLog;
import oracle.soda.OracleClient;
import oracle.soda.OracleDatabase;
import oracle.soda.OracleException;
import oracle.soda.rdbms.OracleRDBMSMetadataBuilder;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.OracleDatabaseImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;
import oracle.soda.rdbms.impl.cache.CacheOfDescriptorCaches;
import oracle.soda.rdbms.impl.cache.DescriptorCache;

public class OracleRDBMSClient
implements OracleClient {
    private CacheOfDescriptorCaches cacheOfDescriptorCaches;
    private boolean localMetadataCache;
    private final MetricsCollector mcollector = new MetricsCollector();
    private static final String SELECT_USER_NAME = "select SYS_CONTEXT('USERENV','CURRENT_USER') from SYS.DUAL";
    private static final Logger log = Logger.getLogger(OracleRDBMSClient.class.getName());

    public OracleRDBMSClient() {
    }

    public OracleRDBMSClient(Properties properties) {
        this();
        if (properties != null) {
            String string = properties.getProperty("oracle.soda.sharedMetadataCache");
            String string2 = properties.getProperty("oracle.soda.localMetadataCache");
            if (string != null && string.equalsIgnoreCase("true")) {
                this.cacheOfDescriptorCaches = new CacheOfDescriptorCaches(100, 100);
            }
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                this.localMetadataCache = true;
            }
        }
    }

    @Override
    public OracleDatabase getDatabase(Connection connection) throws OracleException {
        return this.getDatabase(connection, false);
    }

    @Override
    public OracleDatabase getDatabase(Connection connection, boolean bl) throws OracleException {
        DescriptorCache descriptorCache;
        OracleConnection oracleConnection;
        block12: {
            String string;
            block11: {
                oracleConnection = null;
                string = null;
                try {
                    if (connection instanceof OracleConnection) {
                        oracleConnection = (OracleConnection)connection;
                        break block11;
                    }
                    if (connection.isWrapperFor(OracleConnection.class)) {
                        oracleConnection = connection.unwrap(OracleConnection.class);
                        break block11;
                    }
                    throw SODAUtils.makeException(SODAMessage.EX_NOT_ORACLE_CONNECTION, new Object[0]);
                }
                catch (SQLException sQLException) {
                    throw new OracleException(sQLException);
                }
            }
            descriptorCache = null;
            if (this.cacheOfDescriptorCaches == null) break block12;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                DatabaseMetaData databaseMetaData = oracleConnection.getMetaData();
                string = databaseMetaData.getURL();
                string = string + "/";
                preparedStatement = oracleConnection.prepareStatement(SELECT_USER_NAME);
                resultSet = preparedStatement.executeQuery();
                preparedStatement.setFetchSize(1);
                string = resultSet.next() ? string + resultSet.getString(1) : null;
            }
            catch (SQLException sQLException) {
                try {
                    throw new OracleException(sQLException);
                }
                catch (Throwable throwable) {
                    for (String string2 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                        if (!OracleLog.isLoggingEnabled()) continue;
                        log.severe(string2);
                    }
                    throw throwable;
                }
            }
            for (String string3 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string3);
            }
            if (string == null) {
                throw SODAUtils.makeException(SODAMessage.EX_UNABLE_TO_FETCH_USER_NAME, new Object[0]);
            }
            descriptorCache = this.cacheOfDescriptorCaches.putIfAbsentAndGet(string);
        }
        return new OracleDatabaseImpl(oracleConnection, descriptorCache, this.mcollector, this.localMetadataCache, bl);
    }

    public OracleRDBMSMetadataBuilder createMetadataBuilder() {
        return CollectionDescriptor.createStandardBuilder();
    }
}

