/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.navigator;

import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.http.auth.AuthenticationFailedException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.CConnectionEvent;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.CConnectionsAdapter;
import oracle.dbtools.raptor.cloud.connection.CloudConnectionType;
import oracle.dbtools.raptor.cloud.connection.CloudTask;
import oracle.dbtools.raptor.cloud.connection.ui.ConnectionEditor;
import oracle.dbtools.raptor.cloud.navigator.CloudConnection;
import oracle.dbtools.raptor.cloud.navigator.CloudFolder;
import oracle.dbtools.raptor.cloud.navigator.CloudObject;
import oracle.dbtools.raptor.cloud.navigator.CloudViewerDetail;
import oracle.dbtools.raptor.cloud.navigator.ExceptionDialogRunnable;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.oviewer.jsoneditor.JSONComponent;
import oracle.dbtools.raptor.sftp.SftpUtil;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class CloudController
implements Controller {
    private static final String NEW_CLOUD_CONN_CMD = "Cloud.NewCloudConnection";
    public static final int NEW_CLOUD_CONN_CMD_ID = Ide.findOrCreateCmdID((String)"Cloud.NewCloudConnection");
    private static final String OPEN_CMD = "Cloud.CONNECT";
    public static final int OPEN_CMD_ID = Ide.findOrCreateCmdID((String)"Cloud.CONNECT");
    private static final String CLOSE_CMD = "Cloud.DISCONNECT";
    public static final int CLOSE_CMD_ID = Ide.findOrCreateCmdID((String)"Cloud.DISCONNECT");
    private static final String STATUS_CMD = "Cloud.DEPLOY_STATUS";
    public static final int STATUS_CMD_ID = Ide.findOrCreateCmdID((String)"Cloud.DEPLOY_STATUS");
    private static final String LOG_CMD = "Cloud.DELETE_LOG";
    public static final int LOG_CMD_ID = Ide.findOrCreateCmdID((String)"Cloud.DELETE_LOG");
    private static final String DELETE_CMD = "Cloud.DELETE_DEPLOY";
    public static final int DELETE_CMD_ID = Ide.findOrCreateCmdID((String)"Cloud.DELETE_DEPLOY");
    private static final String DOWNLOAD_LOG_CMD = "Cloud.DOWNLOAD_LOG";
    public static final int DOWNLOAD_LOG_CMD_ID = Ide.findOrCreateCmdID((String)"Cloud.DOWNLOAD_LOG");

    static boolean isCancel(Throwable throwable) {
        if (throwable instanceof AuthenticationFailedException) {
            return ((AuthenticationFailedException)throwable).isCanceled();
        }
        return false;
    }

    static Controller getInstance() {
        return Holder.CONTROLLER;
    }

    private CloudController() {
        CConnections.getInstance().addListener(new CConnectionsAdapter(){

            @Override
            public void connectionAdded(CConnectionEvent cConnectionEvent) {
            }
        });
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        Element element = context.getElement();
        int n = ideAction.getCommandId();
        if (n == STATUS_CMD_ID) {
            bl = true;
            if (element instanceof CloudObject) {
                String string = ((CloudObject)element).getConnectionName();
                String string2 = ((CloudObject)element).getName();
                SftpUtil sftpUtil = new SftpUtil();
                sftpUtil.updateDeploymentStatus(string, string2, "APPROVED");
                this.refreshEditors((CloudObject)element);
            }
        } else if (n == LOG_CMD_ID) {
            bl = true;
            if (element instanceof CloudObject) {
                String string = ((CloudObject)element).getConnectionName();
                String string3 = ((CloudObject)element).getName();
                SftpUtil sftpUtil = new SftpUtil();
                sftpUtil.clearDeploymentLogs(string, string3);
                this.refreshEditors((CloudObject)element);
            }
        } else if (n == DOWNLOAD_LOG_CMD_ID) {
            bl = true;
            if (element instanceof CloudObject) {
                CloudObject cloudObject = (CloudObject)element;
                String string = (String)ideAction.getValue("Name");
                this.doDownloadLog(cloudObject, string);
            }
        } else if (n == DELETE_CMD_ID) {
            bl = true;
            if (element instanceof CloudObject) {
                String string = ((CloudObject)element).getConnectionName();
                String string4 = ((CloudObject)element).getName();
                SftpUtil sftpUtil = new SftpUtil();
                sftpUtil.updateDeploymentStatus(string, string4, "DELETED");
                this.updateParent(context);
                this.closeEditors((CloudObject)element);
            }
        } else if (n == NEW_CLOUD_CONN_CMD_ID) {
            this.createConnection();
            bl = true;
        } else if (n == 56) {
            if (element instanceof CloudConnection) {
                this.editConnection(((CloudConnection)element).getConnectionName());
                bl = true;
            }
        } else if (n == 20) {
            for (Element element2 : context.getSelection()) {
                if (!(element2 instanceof CloudConnection)) continue;
                this.deleteConnection((CloudConnection)element2, true);
                bl = true;
            }
        } else if (n == OPEN_CMD_ID) {
            if (element instanceof CloudConnection) {
                this.openConnection((CloudConnection)element, context);
            }
            bl = true;
        } else if (n == CLOSE_CMD_ID) {
            if (element instanceof CloudConnection) {
                this.closeConnection((CloudConnection)element);
            }
            bl = true;
        }
        return bl;
    }

    private void doDownloadLog(CloudObject cloudObject, String string) {
        final String string2 = cloudObject.getConnectionName();
        String string3 = cloudObject.getName();
        CloudViewerDetail cloudViewerDetail = cloudObject.getViewers().get("DETAILS");
        JSONComponent jSONComponent = new JSONComponent(cloudViewerDetail, string2);
        jSONComponent.refresh();
        TableModel tableModel = jSONComponent.getTableModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (!"file_name".equalsIgnoreCase((String)tableModel.getValueAt(i, 0))) continue;
            string3 = (String)tableModel.getValueAt(i, 1);
            break;
        }
        String string4 = "LOG_" + string3;
        final Path path = Paths.get("download", string4);
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setSelectedFile(new File(string4));
        int n = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow());
        if (0 == n) {
            final String string5 = string + "-" + string4;
            final File file = uRLFileChooser.getSelectedFile();
            RaptorTask<Void> raptorTask = new RaptorTask<Void>(string5, true, IRaptorTaskRunMode.IDE_STATUSBAR){

                protected Void doWork() throws TaskException {
                    try {
                        SftpUtil sftpUtil = new SftpUtil();
                        sftpUtil.download(string2, path, file);
                        return null;
                    }
                    catch (Exception exception) {
                        Logger.warn(CloudController.class, (Throwable)exception);
                        throw new TaskException((Throwable)exception);
                    }
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    Throwable throwable = raptorTaskEvent.getThrowable();
                    if (!CloudController.isCancel(throwable)) {
                        SwingUtilities.invokeLater(() -> ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable, (String)string5, (String)throwable.getLocalizedMessage(), null));
                    }
                    super.taskFailed(raptorTaskEvent);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    SwingUtilities.invokeLater(() -> {
                        if (Desktop.isDesktopSupported()) {
                            String string2 = CloudBrowserResources.format("DOWNLOAD_OK_ASK_OPEN", file.toString());
                            int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)string2, (String)string5);
                            if (1 == n) {
                                try {
                                    Desktop.getDesktop().open(file);
                                }
                                catch (Exception exception) {
                                    Logger.severe(CloudController.class, (Throwable)exception);
                                }
                            }
                        } else {
                            String string3 = CloudBrowserResources.get("DOWNLOAD_OK");
                            MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string3, (String)string5, null);
                        }
                    });
                    super.taskFinished(raptorTaskEvent);
                }
            });
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
    }

    private void updateParent(Context context) {
        NavigatorTreeNode navigatorTreeNode = this.findTreeNode(context);
        if (navigatorTreeNode != null) {
            NavigatorTreeNode navigatorTreeNode2 = navigatorTreeNode.findAncestorTreeNode(CloudFolder.class, false);
            NavigatorTree navigatorTree = ((NavigatorWindow)context.getView()).getTree();
            navigatorTree.refresh(navigatorTreeNode2);
        }
    }

    private void closeEditors(CloudObject cloudObject) {
        List list = EditorManager.getEditorManager().getAllEditors();
        ArrayList<Editor> arrayList = new ArrayList<Editor>();
        for (Editor editor : list) {
            Context context = editor.getContext();
            Node node = context != null ? context.getNode() : null;
            if (!node.getURL().getPath().contains(cloudObject.getURL().getPath())) continue;
            arrayList.add(editor);
        }
        EditorManager.getEditorManager().closeEditors(arrayList);
    }

    private void refreshEditors(CloudObject cloudObject) {
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list) {
            Context context = editor.getContext();
            Node node = context != null ? context.getNode() : null;
            if (!node.getURL().getPath().contains(cloudObject.getURL().getPath())) continue;
            editor.update(null, new UpdateMessage(UpdateMessage.OBJECT_RELOADED, null));
        }
    }

    private NavigatorTreeNode findTreeNode(Context context) {
        Element element;
        Element[] elementArray;
        NavigatorTreeNode navigatorTreeNode = null;
        View view = context.getView();
        if (view instanceof NavigatorWindow && (navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext(context)) == null && (elementArray = context.getSelection()) != null && elementArray.length == 1 && (element = elementArray[0]) != null) {
            NavigatorTree navigatorTree = ((NavigatorWindow)view).getTree();
            navigatorTreeNode = navigatorTree.findTreeNode(element, navigatorTree.getRoot());
        }
        return navigatorTreeNode;
    }

    private void openConnection(final CloudConnection cloudConnection, final Context context) {
        CloudTask<Void> cloudTask = new CloudTask<Void>(CloudBrowserResources.getString("TASK_CLOUD_CONNECT"), true, IRaptorTaskRunMode.TASKVIEWER){

            @Override
            protected String getConnectionName() {
                return cloudConnection.getConnectionName();
            }

            protected Void doWork() throws TaskException {
                try {
                    cloudConnection.getConnection();
                }
                catch (IOException iOException) {
                    Logger.warn(CloudController.class, (Throwable)iOException);
                    throw new TaskException((Throwable)iOException);
                }
                return null;
            }
        };
        cloudTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable = raptorTaskEvent.getThrowable();
                if (!CloudController.isCancel(throwable)) {
                    ExceptionDialogRunnable exceptionDialogRunnable = new ExceptionDialogRunnable(DatabaseNavigatorResources.getString("CONNECTION_FILTER_CONNECT_ERROR"), throwable);
                    if (SwingUtilities.isEventDispatchThread()) {
                        exceptionDialogRunnable.run();
                    } else {
                        try {
                            SwingUtilities.invokeLater(exceptionDialogRunnable);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                NavigatorTreeNode[] navigatorTreeNodeArray = NavigatorContext.getNavigatorNodesFromContext(context);
                if (navigatorTreeNodeArray.length == 1) {
                    NavigatorTreeNode navigatorTreeNode = navigatorTreeNodeArray[0];
                    NavigatorTree navigatorTree = navigatorTreeNode.getOwningNavigatorTree();
                    navigatorTree.expand(navigatorTreeNode, false);
                }
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)cloudTask);
    }

    private void createConnection() {
        ConnectionEditor.getInstance().createConnection(CloudConnectionType.getInstance());
    }

    private void editConnection(String string) {
        ConnectionEditor.getInstance().editConnection(string, CloudConnectionType.getInstance());
    }

    private void deleteConnection(CloudConnection cloudConnection, boolean bl) {
        String string;
        String string2 = cloudConnection.getConnectionName();
        if (bl && !MessageDialog.confirm(null, (Object)(string = DatabaseNavigatorResources.format("MGR_CONFIRM_DEL", string2)), (String)DatabaseNavigatorResources.getString("MGR_CONFIRM_TITLE"), null, (boolean)true)) {
            return;
        }
        if (this.closeConnection(cloudConnection)) {
            CConnections.getInstance().removeConnection(string2);
        }
    }

    private boolean closeConnection(CloudConnection cloudConnection) {
        String string = cloudConnection.getConnectionName();
        return CConnections.getInstance().closeConnection(string);
    }

    public boolean update(IdeAction ideAction, Context context) {
        Element element = context.getElement();
        boolean bl = context.getSelection().length == 1;
        int n = ideAction.getCommandId();
        if (n == NEW_CLOUD_CONN_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (element instanceof CloudObject) {
            if (((CloudObject)element).getObjectType().equals("DEPLOYMENTS")) {
                if (n == STATUS_CMD_ID) {
                    ideAction.setEnabled(bl);
                    return true;
                }
                if (n == LOG_CMD_ID) {
                    ideAction.setEnabled(bl);
                    return true;
                }
                if (n == DOWNLOAD_LOG_CMD_ID) {
                    String string = ((CloudObject)element).getConnectionName();
                    SessionInfo sessionInfo = CConnections.getInstance().getConnectionInfo(string);
                    SessionInfo.OssInfo ossInfo = sessionInfo.getOssInfo();
                    boolean bl2 = ossInfo != null && ossInfo.isOssEnabled();
                    ideAction.setEnabled(bl && bl2);
                    return true;
                }
                if (n == DELETE_CMD_ID) {
                    ideAction.setEnabled(bl);
                    return true;
                }
            }
        } else if (n == 20) {
            if (element instanceof CloudConnection) {
                ideAction.setEnabled(bl);
                return true;
            }
        } else {
            if (n == OPEN_CMD_ID) {
                if (element instanceof CloudConnection) {
                    ideAction.setEnabled(bl && !((CloudConnection)element).isConnectionOpen());
                }
                return true;
            }
            if (n == CLOSE_CMD_ID) {
                if (element instanceof CloudConnection) {
                    ideAction.setEnabled(bl && ((CloudConnection)element).isConnectionOpen());
                }
                return true;
            }
            if (n == 56 && element instanceof CloudConnection) {
                ideAction.setEnabled(bl && !((CloudConnection)element).isConnectionOpen());
                return true;
            }
        }
        return false;
    }

    private static class Holder {
        private static final CloudController CONTROLLER = new CloudController();

        private Holder() {
        }
    }
}

