/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;

public class DataEditorOptionPanel
extends JPanel
implements LayoutControl {
    private static final long serialVersionUID = -7860081933092101605L;
    private JCheckBox m_AutoCommit = new JCheckBox();
    private JCheckBox m_commitChangesRB = new JCheckBox();
    private JButton m_clearSettingsButton = new JButton();
    private JCheckBox m_useSCNRB = new JCheckBox();

    public DataEditorOptionPanel() {
        try {
            this.initGUI();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(PreferencesArb.getString("DATAEDITOR_OPTIONS_TITLE")));
        ResourceUtils.resButton((AbstractButton)this.m_commitChangesRB, (String)PreferencesArb.getString("POST_EDITS_ROW_CHANGE_TEXT"));
        ResourceUtils.resButton((AbstractButton)this.m_AutoCommit, (String)PreferencesArb.getString("AUTO_COMMIT_CHANGE_TEXT"));
        ResourceUtils.resButton((AbstractButton)this.m_clearSettingsButton, (String)PreferencesArb.getString("CLEAR_SETTINGS_BUTTON_TEXT"));
        ResourceUtils.resButton((AbstractButton)this.m_useSCNRB, (String)PreferencesArb.getString("USE_SCN"));
        this.m_useSCNRB.setSelected(true);
        this.m_AutoCommit.setEnabled(false);
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)new JLabel(PreferencesArb.getString("COMMIT_OPTIONS_TITLE")), LayoutControl.GBC.gbc(0, 0, 2, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add((Component)this.m_commitChangesRB, LayoutControl.GBC.gbc(0, 1, 2, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_AutoCommit, LayoutControl.GBC.gbc(0, 2, 2, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        JLabel jLabel = new JLabel("<html>" + PreferencesArb.getString("CLEAR_SETTINGS_LABEL_TEXT") + "</html>");
        jLabel.setLabelFor(this.m_clearSettingsButton);
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 3, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this.m_clearSettingsButton, LayoutControl.GBC.gbc(1, 3, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_useSCNRB, LayoutControl.GBC.gbc(0, 4, 2, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        this.add((Component)jPanel, LayoutControl.GBC.TITLED_SUB_PANEL);
        this.m_clearSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL;
                ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
                if (extensionRegistry.findExtension("oracle.sqldeveloper") != null && (uRL = extensionRegistry.getSystemDirectory("oracle.sqldeveloper")) != null && URLFileSystem.isDirectory((URL)uRL)) {
                    URL[] uRLArray;
                    for (URL uRL2 : uRLArray = URLFileSystem.list((URL)uRL)) {
                        if (!uRL2.getFile().endsWith("GridSettings.xml") && !uRL2.getFile().endsWith("SavedFilters.xml")) continue;
                        URLFileSystem.delete((URL)uRL2);
                    }
                }
            }
        });
        this.m_commitChangesRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DataEditorOptionPanel.this.m_commitChangesRB.isSelected()) {
                    DataEditorOptionPanel.this.m_AutoCommit.setEnabled(true);
                } else {
                    DataEditorOptionPanel.this.m_AutoCommit.setSelected(false);
                    DataEditorOptionPanel.this.m_AutoCommit.setEnabled(false);
                }
            }
        });
    }

    public void setFromPreferences(DBConfig dBConfig) {
        boolean bl = dBConfig.getBoolean("DATAEDITOR_POSTONROWCHANGE");
        this.m_AutoCommit.setEnabled(bl);
        this.m_commitChangesRB.setSelected(bl);
        this.m_AutoCommit.setSelected(dBConfig.getBoolean("DATAEDITOR_AUTOCOMMIT"));
        this.m_useSCNRB.setSelected(dBConfig.getBoolean("DATAEDITOR_USE_SCN"));
    }

    public void savePreferences(DBConfig dBConfig) {
        dBConfig.putBoolean("DATAEDITOR_POSTONROWCHANGE", this.m_commitChangesRB.isSelected());
        dBConfig.putBoolean("DATAEDITOR_AUTOCOMMIT", this.m_AutoCommit.isSelected());
        dBConfig.putBoolean("DATAEDITOR_USE_SCN", this.m_useSCNRB.isSelected());
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        jDialog.setLayout(new BorderLayout());
        DataEditorOptionPanel dataEditorOptionPanel = new DataEditorOptionPanel();
        jDialog.add((Component)dataEditorOptionPanel, "Center");
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }
}

