/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.config.URLFileChooserPaths;
import oracle.ide.config.IdeSettings;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.config.EnvironOptionsPanel;

public class EnvironOptionsPanelWrapper
extends DefaultTraversablePanel {
    private final EnvironOptionsPanel _delegate;
    private final JCheckBox _jcbPersistChooserPaths = new JCheckBox();
    private boolean _restartRequired;
    private boolean _persistChooserPaths;

    public EnvironOptionsPanelWrapper() {
        this._delegate = new EnvironOptionsPanel();
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        ResourceUtils.resButton((AbstractButton)this._jcbPersistChooserPaths, (String)PreferencesArb.getString("PERSIST_CHOOSER_PATHS"));
        this.add(this._jcbPersistChooserPaths, "First");
        this._jcbPersistChooserPaths.setToolTipText(PreferencesArb.getString("PERSIST_CHOOSER_PATHS_TOOLTIP"));
        this.add((Component)this._delegate, "Center");
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this._persistChooserPaths = dBConfig.getURLFileChooserPaths().usePersistedHash();
        this._jcbPersistChooserPaths.setSelected(this._persistChooserPaths);
        this._delegate.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        boolean bl = this._jcbPersistChooserPaths.isSelected();
        if (bl != this._persistChooserPaths) {
            DBConfig dBConfig = DBConfig.getInstance(traversableContext);
            dBConfig.putBoolean(URLFileChooserPaths.PERSISTENCE_KEY, bl);
            IdeSettings ideSettings = (IdeSettings)traversableContext.find("ide-options");
            ideSettings.setAskExit(true);
        }
        this._delegate.onExit(traversableContext);
    }

    public String getHelpID() {
        return this._delegate.getHelpID();
    }
}

