/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.config.Preferences;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.TriStateCheckBox;
import oracle.javatools.util.Copyable;

public class LicensingEditorConfig
extends HashStructureAdapter
implements Copyable {
    public static final String LICENSINGEDITOR = "LICENSINGEDITOR";
    private static final Logger LOGGER = Logger.getLogger(LicensingEditorConfig.class.getName());
    public static int CHANGE_MANGEMENT_PACK = 0;
    public static int TUNING_PACK = 1;
    public static int DIAGNOSTICS_PACK = 2;
    public static int ADVANCED_COMPRESSION = 3;
    public static int ADVANCED_SECURITY = 4;

    private LicensingEditorConfig(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static LicensingEditorConfig getInstance(PropertyStorage propertyStorage) {
        return new LicensingEditorConfig(LicensingEditorConfig.findOrCreate((PropertyStorage)propertyStorage, (String)LICENSINGEDITOR));
    }

    public static LicensingEditorConfig getInstance(TraversableContext traversableContext) {
        return LicensingEditorConfig.getInstance(traversableContext.getPropertyStorage());
    }

    public static synchronized LicensingEditorConfig getInstance() {
        Preferences preferences = Preferences.getPreferences();
        return LicensingEditorConfig.getInstance((PropertyStorage)preferences);
    }

    public LicensingEditorConfig() {
        super(HashStructure.newInstance());
    }

    public String getCommandLine(String string) {
        List<TriStateCheckBox.State> list = this.getAllElements(string);
        Iterator<TriStateCheckBox.State> iterator = list.iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
        }
        return string2;
    }

    public List<TriStateCheckBox.State> getAllElements(String string) {
        ArrayList<TriStateCheckBox.State> arrayList = new ArrayList<TriStateCheckBox.State>();
        Map<String, List<TriStateCheckBox.State>> map = this.getAllElements();
        List<TriStateCheckBox.State> list = map.get(string);
        if (list != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public TriStateCheckBox.State getLicensingPackSetting(String string, int n) {
        Map<String, List<TriStateCheckBox.State>> map = this.getAllElements();
        List<TriStateCheckBox.State> list = map.get(string);
        if (list != null) {
            return list.get(n);
        }
        return TriStateCheckBox.State.FALSE;
    }

    public void setLicensingPackSetting(String string, TriStateCheckBox.State state, int n) {
        Map<String, List<TriStateCheckBox.State>> map = this.getAllElements();
        List<TriStateCheckBox.State> list = map.get(string);
        if (list != null) {
            list.set(n, state);
        }
        this.putAllElements(map);
    }

    public TriStateCheckBox.State getTuningPackSetting(String string) {
        Map<String, List<TriStateCheckBox.State>> map = this.getAllElements();
        List<TriStateCheckBox.State> list = map.get(string);
        if (list != null) {
            return list.get(TUNING_PACK);
        }
        return TriStateCheckBox.State.FALSE;
    }

    public void setAdvancedCompressionSetting(String string, TriStateCheckBox.State state, int n) {
        Map<String, List<TriStateCheckBox.State>> map = this.getAllElements();
        List<TriStateCheckBox.State> list = map.get(string);
        if (list != null) {
            list.set(n, state);
        }
        this.putAllElements(map);
    }

    public TriStateCheckBox.State getAdvancedCompressionSetting(String string) {
        Map<String, List<TriStateCheckBox.State>> map = this.getAllElements();
        List<TriStateCheckBox.State> list = map.get(string);
        if (list != null) {
            return list.get(ADVANCED_COMPRESSION);
        }
        return TriStateCheckBox.State.FALSE;
    }

    public void setAdvancedSecuritySetting(String string, TriStateCheckBox.State state, int n) {
        Map<String, List<TriStateCheckBox.State>> map = this.getAllElements();
        List<TriStateCheckBox.State> list = map.get(string);
        if (list != null) {
            list.set(n, state);
        }
        this.putAllElements(map);
    }

    public TriStateCheckBox.State getAdvancedSecuritySetting(String string) {
        Map<String, List<TriStateCheckBox.State>> map = this.getAllElements();
        List<TriStateCheckBox.State> list = map.get(string);
        if (list != null) {
            return list.get(ADVANCED_SECURITY);
        }
        return TriStateCheckBox.State.FALSE;
    }

    public void setTuningPackSetting(String string, TriStateCheckBox.State state) {
        Map<String, List<TriStateCheckBox.State>> map = this.getAllElements();
        List<TriStateCheckBox.State> list = map.get(string);
        if (list != null) {
            list.set(1, state);
        }
        this.putAllElements(map);
    }

    public void putAllElements(Map<String, List<TriStateCheckBox.State>> map) {
        HashStructure hashStructure = HashStructure.newInstance();
        for (String string : map.keySet()) {
            List<TriStateCheckBox.State> list = map.get(string);
            ListStructure listStructure = ListStructure.newInstance();
            for (TriStateCheckBox.State state : list) {
                listStructure.add((Object)state.name());
            }
            hashStructure.putListStructure(string, listStructure);
        }
        this._hash.putHashStructure(LICENSINGEDITOR, hashStructure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<TriStateCheckBox.State>> getAllElements() {
        Object object;
        HashStructure hashStructure;
        HashMap hashMap = new HashMap();
        Object object2 = this._hash.getObject(LICENSINGEDITOR);
        if (object2 != null && object2 instanceof HashStructure) {
            hashStructure = (HashStructure)object2;
            for (String string : hashStructure.keySet()) {
                try {
                    object = hashStructure.getOrCreateListStructure(string);
                    ArrayList<TriStateCheckBox.State> arrayList = new ArrayList<TriStateCheckBox.State>();
                    Object object3 = object.iteratorLock();
                    synchronized (object3) {
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            arrayList.add(TriStateCheckBox.State.valueOf((String)((String)e)));
                        }
                    }
                    if (arrayList.size() <= ADVANCED_COMPRESSION) {
                        arrayList.add(TriStateCheckBox.State.PARTIAL);
                    }
                    if (arrayList.size() <= ADVANCED_SECURITY) {
                        arrayList.add(TriStateCheckBox.State.PARTIAL);
                    }
                    hashMap.put(string, arrayList);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, MessageFormat.format(Messages.getString("LicensingConnectionWarning"), string));
                }
            }
        }
        hashStructure = new TreeMap();
        Object[] objectArray = this.getOracleConnections();
        if (objectArray != null) {
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                object = (List)hashMap.get(objectArray[i]);
                if (null == object) {
                    object = (List)hashMap.get(Connections.getDisplayName((String)objectArray[i]));
                }
                if (null == object) {
                    object = new ArrayList();
                    object.add(TriStateCheckBox.State.PARTIAL);
                    object.add(TriStateCheckBox.State.PARTIAL);
                    object.add(TriStateCheckBox.State.PARTIAL);
                    object.add(TriStateCheckBox.State.PARTIAL);
                    object.add(TriStateCheckBox.State.PARTIAL);
                }
                hashStructure.put(objectArray[i], object);
            }
        }
        return hashStructure;
    }

    private String[] getOracleConnections() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray = Connections.getInstance().getConnNames()) {
            if (!Connections.getInstance().isOracle(string)) continue;
            arrayList.add(string);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

