/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.TriStateCheckBox;
import oracle.javatools.ui.checktree.TriStateNode;

public class NavigationFilterTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private static final Border focusBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("Tree.selectionBorderColor"));
    private static final Border normalBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private boolean enableNavigationFilterTree = false;

    public NavigationFilterTree() {
        this._init();
    }

    public NavigationFilterTree(TreeModel treeModel) {
        super(treeModel);
        this._init();
    }

    @Override
    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
    }

    public void setState(boolean bl) {
        Object object;
        Object object2 = object = this.getModel() == null ? null : this.getModel().getRoot();
        if (object instanceof TriStateNode) {
            final TriStateNode triStateNode = (TriStateNode)object;
            final TriStateNode.NodeState nodeState = bl ? TriStateNode.NodeState.YES : TriStateNode.NodeState.NO;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    triStateNode.setNodeState(nodeState, false, true);
                    NavigationFilterTree.this.repaint();
                    NavigationFilterTree.this.fireAccessibleChange(new TreePath(triStateNode));
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                try {
                    EventQueue.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void _init() {
        this.setShowsRootHandles(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                TreePath treePath;
                if (NavigationFilterTree.this.enableNavigationFilterTree && (treePath = NavigationFilterTree.this.getSelectionPath()) != null && keyEvent.getKeyCode() == 32 && treePath.getLastPathComponent() instanceof TriStateNode) {
                    TriStateNode triStateNode = (TriStateNode)treePath.getLastPathComponent();
                    if (triStateNode.getNodeState() == TriStateNode.NodeState.YES) {
                        triStateNode.setNodeState(TriStateNode.NodeState.NO);
                    } else {
                        triStateNode.setNodeState(TriStateNode.NodeState.YES);
                    }
                    NavigationFilterTree.this.repaint();
                    NavigationFilterTree.this.fireAccessibleChange(treePath);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Rectangle rectangle;
                TreePath treePath;
                if (NavigationFilterTree.this.enableNavigationFilterTree && (treePath = NavigationFilterTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && (rectangle = NavigationFilterTree.this.getPathBounds(treePath)).contains(mouseEvent.getPoint())) {
                    NavigationFilterTreeCellRenderer navigationFilterTreeCellRenderer = (NavigationFilterTreeCellRenderer)NavigationFilterTree.this.getCellRenderer();
                    Rectangle rectangle2 = navigationFilterTreeCellRenderer.contentPanel.checkbox.getBounds();
                    rectangle2.translate(rectangle.x, rectangle.y);
                    if (!rectangle2.contains(mouseEvent.getPoint())) {
                        return;
                    }
                    if (treePath.getLastPathComponent() instanceof TriStateNode) {
                        TriStateNode triStateNode = (TriStateNode)treePath.getLastPathComponent();
                        if (triStateNode.getNodeState() == TriStateNode.NodeState.YES) {
                            triStateNode.setNodeState(TriStateNode.NodeState.NO);
                        } else {
                            triStateNode.setNodeState(TriStateNode.NodeState.YES);
                        }
                        NavigationFilterTree.this.repaint();
                        NavigationFilterTree.this.fireAccessibleChange(treePath);
                    }
                }
            }
        });
        this.setCellRenderer(new NavigationFilterTreeCellRenderer());
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enableNavigationFilterTree = bl;
        NavigationFilterTreeCellRenderer navigationFilterTreeCellRenderer = (NavigationFilterTreeCellRenderer)this.getCellRenderer();
        navigationFilterTreeCellRenderer.enableNewFeature(bl);
        this.repaint();
    }

    private void fireAccessibleChange(TreePath treePath) {
        this.setSelectionPath(null);
        this.setSelectionPath(treePath);
    }

    private class NavigationFilterTreeCellRenderer
    implements TreeCellRenderer {
        private ContentPanel contentPanel = null;
        private boolean enableFeature = false;
        private ContentPanel accessibleContentPanel = new ContentPanel();

        NavigationFilterTreeCellRenderer() {
            this.contentPanel = new ContentPanel();
        }

        public void enableNewFeature(boolean bl) {
            this.enableFeature = bl;
        }

        public boolean isNewFeature() {
            return this.enableFeature;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            ContentPanel contentPanel = this.contentPanel;
            if (!SwingUtilities.isEventDispatchThread() && NavigationFilterTree.this.isShowing()) {
                contentPanel = this.accessibleContentPanel;
            }
            this.updateContent(contentPanel, jTree, object, bl);
            return contentPanel.content;
        }

        public void updateContent(ContentPanel contentPanel, JTree jTree, Object object, boolean bl) {
            if (this.isNewFeature()) {
                if (object instanceof TriStateNode) {
                    TriStateNode triStateNode = (TriStateNode)object;
                    if (triStateNode.getNodeState() == TriStateNode.NodeState.YES) {
                        contentPanel.checkbox.setState(TriStateCheckBox.State.TRUE);
                    } else if (triStateNode.getNodeState() == TriStateNode.NodeState.NO) {
                        contentPanel.checkbox.setState(TriStateCheckBox.State.FALSE);
                    } else {
                        contentPanel.checkbox.setState(TriStateCheckBox.State.PARTIAL);
                    }
                    contentPanel.checkbox.setEnabled(true);
                    contentPanel.label.setText(triStateNode.getLabel());
                    contentPanel.label.setIcon(triStateNode.getIcon());
                }
                contentPanel.label.setBackground(bl ? UIManager.getColor("Tree.selectionBackground") : jTree.getBackground());
                contentPanel.label.setForeground(bl ? UIManager.getColor("Tree.selectionForeground") : jTree.getForeground());
                contentPanel.label.setBorder(bl ? focusBorder : normalBorder);
                contentPanel.label.setEnabled(true);
            } else {
                if (object instanceof TriStateNode) {
                    TriStateNode triStateNode = (TriStateNode)object;
                    if (triStateNode.getNodeState() == TriStateNode.NodeState.YES) {
                        contentPanel.checkbox.setState(TriStateCheckBox.State.TRUE);
                    } else if (triStateNode.getNodeState() == TriStateNode.NodeState.NO) {
                        contentPanel.checkbox.setState(TriStateCheckBox.State.FALSE);
                    } else {
                        contentPanel.checkbox.setState(TriStateCheckBox.State.PARTIAL);
                    }
                    contentPanel.label.setText(triStateNode.getLabel());
                    contentPanel.label.setIcon(triStateNode.getIcon());
                    contentPanel.checkbox.setEnabled(false);
                }
                contentPanel.label.setBackground(bl ? UIManager.getColor("Tree.selectionBackground") : jTree.getBackground());
                contentPanel.label.setForeground(bl ? UIManager.getColor("Tree.selectionForeground") : jTree.getForeground());
                contentPanel.label.setBorder(bl ? focusBorder : normalBorder);
                contentPanel.label.setEnabled(false);
            }
        }

        private class ContentPanel {
            private TriStateCheckBox checkbox = new TriStateCheckBox();
            private JLabel label = new JLabel();
            private JPanel content = new CustomAccessibleJPanel();

            ContentPanel() {
                this.checkbox.setFocusable(false);
                this.checkbox.setOpaque(false);
                this.checkbox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                this.label.setFocusable(false);
                this.label.setFont(UIManager.getFont("Tree.font"));
                this.label.setOpaque(true);
                this.content.setLayout(new BorderLayout(1, 0));
                this.content.add((Component)this.checkbox, "Before");
                this.content.add((Component)this.label, "After");
                this.content.setOpaque(false);
                this.label.addPropertyChangeListener("text", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getNewValue() == null) {
                            return;
                        }
                        Object object = propertyChangeEvent.getNewValue().toString();
                        if (ContentPanel.this.checkbox.isSelected()) {
                            object = (String)object + " " + AccessibleState.CHECKED.toDisplayString();
                        }
                        ContentPanel.this.checkbox.putClientProperty((Object)"AccessibleName", object);
                    }
                });
            }

            private class CustomAccessibleJPanel
            extends JPanel {
                private CustomAccessibleJPanel() {
                }

                @Override
                public AccessibleContext getAccessibleContext() {
                    return ContentPanel.this.checkbox.getAccessibleContext();
                }
            }
        }
    }
}

