/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config.homesupport;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import oracle.dbtools.raptor.config.homesupport.OracleHomeSettings;
import oracle.dbtools.raptor.startup.HomeSupport;
import oracle.dbtools.raptor.startup.OracleHomeType;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;

public class OracleClientShutdownHook
implements ShutdownHook {
    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        OracleHomeSettings oracleHomeSettings = OracleHomeSettings.getInstance();
        OracleHomeSettings.OracleHome oracleHome = oracleHomeSettings.getHome();
        if (oracleHomeSettings.isUseOracleClient()) {
            this.updateConfig(oracleHome);
        } else {
            this.updateConfig(null);
        }
    }

    private URL getConfigURL() {
        URL uRL = null;
        String string = Ide.getUserSettingsDirectory();
        if (string != null) {
            URL uRL2 = URLFactory.newDirURL((String)string);
            String string2 = Version.VER_FULL;
            String string3 = HomeSupport.getConfigFileName((String)string2);
            uRL = URLFactory.newURL((URL)uRL2, (String)string3);
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfig(OracleHomeSettings.OracleHome oracleHome) {
        URL uRL = this.getConfigURL();
        if (uRL != null) {
            if (oracleHome == null) {
                URLFileSystem.delete((URL)uRL);
            } else {
                URL uRL2 = oracleHome.getLocation();
                if (uRL2 != null && URLFileSystem.exists((URL)uRL2)) {
                    Properties properties = new Properties();
                    OracleHomeType oracleHomeType = oracleHome.getType();
                    String string = URLFileSystem.getPlatformPathName((URL)uRL2);
                    if (oracleHomeType == OracleHomeType.FULL_HOME) {
                        properties.setProperty(HomeSupport.HOME_LOCATION, string);
                    } else {
                        properties.setProperty(HomeSupport.INSTANT_CLIENT_LOCATION, string);
                    }
                    OutputStreamWriter outputStreamWriter = null;
                    try {
                        outputStreamWriter = new OutputStreamWriter(URLFileSystem.openOutputStream((URL)uRL));
                        properties.store(outputStreamWriter, "Oracle SQL Developer Client Settings");
                    }
                    catch (Exception exception) {
                        Logger.severe(OracleClientShutdownHook.class, (String)exception.getLocalizedMessage());
                    }
                    finally {
                        if (outputStreamWriter != null) {
                            try {
                                ((Writer)outputStreamWriter).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }
    }
}

