/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.connections.db.DatabaseProviderHelper;
import oracle.dbtools.connections.db.PasswordPrompter;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.connections.AuthenticationPanel;
import oracle.dbtools.raptor.connections.ConnectionTypeRegistry;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.raptor.dialogs.conn.ConnectionPrompt;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DBNavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.dialogs.DialogSizeKeeper;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public class ConnectionDialog
extends JPanel {
    private static final int MIN_WIDTH = 780;
    private static final int MIN_HEIGHT = 500;
    private JButton _btnTest = new JButton();
    private JButton _btnSave = new JButton();
    private JButton _btnClear = new JButton();
    private JButton _btnConnect = new JButton();
    private JTable _table = new JTable();
    private JComboBox<ConnectionTypeEntry> _types = new JComboBox();
    private JTextField tfdConnName = new JTextField(15);
    private JLabel lblStatus = new JLabel(ConnectionDialogArb.getString("CONNECTION_DIALOG_STATUS"));
    private SmallSquareButton copyBtn = new SmallSquareButton();
    private JEWTDialog _dlg;
    private KeyAdapter _enterKey;
    private static final String CLEAR = Messages.getString("ConnectionDialog.0");
    private static final String TEST = Messages.getString("ConnectionDialog.1");
    private static final String SAVE = Messages.getString("ConnectionDialog.2");
    private static final String CONNECT = Messages.getString("ConnectionDialog.3");
    public static final String EXCLUSION_CHAR_PATTERN = "^[^<>:\\\"/\\\\|?*()%&'$^~#]*$";
    private DatabaseConnections m_store;
    private String m_initName;
    private CustomColorChoice connColor;

    public ConnectionDialog() {
        this.setLayout(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setBorder(null);
        this.add((Component)jSplitPane, "Center");
        this._table.setPreferredScrollableViewportSize(new Dimension(150, 0));
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ConnectionDialog.this.tableFocusChanged();
            }
        });
        this._table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = ConnectionDialog.this._table.rowAtPoint(point);
                int n2 = ConnectionDialog.this._table.columnAtPoint(point);
                Object object = ConnectionDialog.this._table.getValueAt(n, n2);
                ConnectionDialog.this._table.setToolTipText(object.toString());
            }
        });
        Serializable serializable = new JScrollPane(this._table);
        serializable.setSize(new Dimension(250, 250));
        serializable.setMaximumSize(new Dimension(300, 0));
        serializable.setMinimumSize(new Dimension(200, 0));
        serializable.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        jSplitPane.setLeftComponent((Component)serializable);
        serializable = LayoutControl.GBC.createPanel();
        Serializable serializable2 = LayoutControl.GBC.createPanel();
        Serializable serializable3 = new JLabel();
        ResourceUtils.resLabel((JLabel)serializable3, (Component)this.tfdConnName, (String)"Name");
        serializable2.add((Component)serializable3, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        serializable2.add(this.tfdConnName, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        Object object = new JLabel();
        this.connColor = new CustomColorChoice();
        this.connColor.setTransparentAllowed(true);
        this.connColor.setTransparentLabelUsed(false);
        Object object2 = "Color";
        ResourceUtils.resLabel((JLabel)object, (Component)this.connColor, (String)object2);
        serializable2.add((Component)this.connColor, LayoutControl.GBC.gbc(2, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2CONTROL_COMP));
        serializable2.add((Component)object, LayoutControl.GBC.gbc(3, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP));
        serializable2.add(Box.createHorizontalStrut(8), LayoutControl.GBC.gbc(4, 0, 1, 1, LayoutControl.GBC.Inset.NONE));
        Serializable serializable4 = LayoutControl.GBC.createPanel();
        Object object3 = new JLabel();
        ResourceUtils.resLabel((JLabel)object3, this._types, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_TYPE"));
        ((Container)serializable4).add((Component)object3, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        ((Container)serializable4).add(this._types, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        ((Container)serializable4).add(Box.createGlue(), LayoutControl.GBC.gbc(2, 0, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        serializable2.add((Component)serializable4, LayoutControl.GBC.gbc(0, 1, 4, 1, LayoutControl.GBC.Inset.NONE, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        serializable.add((Component)serializable2, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        serializable2 = new CardLayout();
        serializable3 = new JPanel((LayoutManager)((Object)serializable2));
        object = new IConnectionPanel.StateProvider(){

            @Override
            public void setStatus(String string) {
                ConnectionDialog.this.showStatus(string, false);
            }

            @Override
            public void setErrorState(String string) {
                ConnectionDialog.this.showStatus(string, true);
            }

            @Override
            public String getConnectionName() {
                return ConnectionDialog.this.getConnectionName();
            }
        };
        object2 = ConnectionTypeRegistry.getTabNames();
        serializable4 = new DefaultComboBoxModel<ConnectionTypeEntry>(){

            @Override
            public void setSelectedItem(Object object) {
                if (object != null || this.getSize() == 0) {
                    super.setSelectedItem(object);
                }
            }
        };
        object3 = ((ArrayList)object2).iterator();
        while (object3.hasNext()) {
            String string = (String)object3.next();
            try {
                IConnectionPanel iConnectionPanel = ConnectionTypeRegistry.getPanelFor(string);
                boolean bl = false;
                String[] stringArray = iConnectionPanel.getSupportedDrivers();
                ClassLoader classLoader = null;
                for (String string2 : stringArray) {
                    try {
                        classLoader = RaptorClassLoader.findClassLoader(string2);
                        if (classLoader == null) continue;
                        classLoader.loadClass(string2);
                        bl = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!bl) continue;
                iConnectionPanel.initUI();
                iConnectionPanel.setStatusDisplay((IConnectionPanel.StateProvider)object);
                ConnectionTypeEntry connectionTypeEntry = new ConnectionTypeEntry(string, iConnectionPanel);
                serializable4.addElement(connectionTypeEntry);
                serializable3.add(connectionTypeEntry.getUI(), string);
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)(Messages.getString("ConnectionDialog.7") + string + "\n" + exception.getLocalizedMessage()), (String)Messages.getString("ConnectionDialog.9"), (String)"f1_connectiontype_load_err_html");
            }
        }
        this._types.setModel((ComboBoxModel<ConnectionTypeEntry>)((Object)serializable4));
        this._types.addItemListener(arg_0 -> ConnectionDialog.lambda$new$0((CardLayout)serializable2, (JPanel)serializable3, arg_0));
        serializable.add((Component)serializable3, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
        serializable.add(Box.createHorizontalStrut(8), LayoutControl.GBC.gbc(1, 1, 1, 1, LayoutControl.GBC.Inset.NONE));
        jSplitPane.setRightComponent((Component)serializable);
        this._btnSave.setActionCommand(SAVE);
        ResourceUtils.resButton((AbstractButton)this._btnSave, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_BUTTON_SAVE"));
        this._btnTest.setActionCommand(TEST);
        ResourceUtils.resButton((AbstractButton)this._btnTest, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_BUTTON_TEST"));
        this._btnClear.setActionCommand(CLEAR);
        ResourceUtils.resButton((AbstractButton)this._btnClear, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_BUTTON_CLEAR"));
        this._btnConnect.setActionCommand(CONNECT);
        ResourceUtils.resButton((AbstractButton)this._btnConnect, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_BUTTON_CONNECT"));
        this._enterKey = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                char c = keyEvent.getKeyChar();
                if (n == 10) {
                    ConnectionDialog.this.processButtons(CONNECT);
                }
            }
        };
        serializable = LayoutControl.GBC.createPanel();
        serializable.add(this.lblStatus, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        this.copyBtn.setAction((Action)new AbstractAction("", OracleIcons.getIcon((String)"copy.png")){
            {
                this.putValue("ActionCommandKey", this.getValue("Name"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringSelection stringSelection = new StringSelection(ConnectionDialog.this.lblStatus.getText());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                ClipboardStack.pushCurrentClipboard();
                clipboard.setContents(stringSelection, stringSelection);
                ConnectionDialog.this.copyBtn.setSelected(false);
            }
        });
        this.copyBtn.setToolTipText(oracle.dbtools.raptor.dialogs.Messages.getString((String)"COPY_ERROR_MESSAGE_TOOLTIP"));
        int n = 2;
        serializable3 = KeyStroke.getKeyStroke(83, 128);
        this.getInputMap(n).put((KeyStroke)serializable3, "PRESS");
        this.getActionMap().put("PRESS", this.copyBtn.getAction());
        serializable.add((Component)this.copyBtn, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP));
        this.copyBtn.setVisible(false);
        this.add((Component)serializable, "South");
        serializable = Ide.getMainWindow().getSize();
        this.setMinimumSize(new Dimension(750, 390));
        this.validate();
    }

    public void initDialog(JEWTDialog jEWTDialog) {
        this._dlg = jEWTDialog;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionDialog.this.processButtons(actionEvent.getActionCommand());
            }
        };
        this._dlg.addActionListener(actionListener);
        this._btnSave.addActionListener(actionListener);
        this._btnTest.addActionListener(actionListener);
        this._btnClear.addActionListener(actionListener);
        this._btnConnect.addActionListener(actionListener);
        this._btnSave.setMaximumSize(this._btnSave.getMinimumSize());
        this._btnTest.setMaximumSize(this._btnTest.getMinimumSize());
        this._btnClear.setMaximumSize(this._btnClear.getMinimumSize());
        this._dlg.addCustomButton((Component)this._btnSave);
        this._dlg.addCustomButton((Component)this._btnClear);
        this._dlg.addCustomButton((Component)this._btnTest);
        this._dlg.addCustomButton((Component)this._btnConnect);
        this.tfdConnName.addKeyListener(this._enterKey);
    }

    public void attachEnterKey(Component component) {
        component.addKeyListener(this._enterKey);
        if (component instanceof Container) {
            for (int i = 0; i < ((Container)component).getComponentCount(); ++i) {
                this.attachEnterKey(((Container)component).getComponent(i));
            }
        }
    }

    public Properties getConnectionProperties() {
        Object object;
        Properties properties = new Properties();
        if (this.connColor.getSelectedColor() != null) {
            object = this.connColor.getSelectedColor();
            properties.setProperty("Connection-Color-For-Editors", "" + ((Color)object).getRGB());
        }
        object = (ConnectionTypeEntry)this._types.getSelectedItem();
        return ((ConnectionTypeEntry)object).getConnectionDetail().getConnectionProperties(properties);
    }

    private static List<Properties> getAllConnections(DatabaseConnections databaseConnections) {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        try {
            Collection collection = databaseConnections.listConnections();
            String[] stringArray = collection.toArray(new String[0]);
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            for (String string : stringArray) {
                Properties properties = databaseConnections.getProperties(string);
                properties.setProperty("ConnName", string);
                arrayList.add(properties);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(ConnectionDialog.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    private void setActivePanel(Properties properties) {
        String string = properties.getProperty("RaptorConnectionType");
        ComboBoxModel<ConnectionTypeEntry> comboBoxModel = this._types.getModel();
        int n = comboBoxModel.getSize();
        for (int i = 0; i < n; ++i) {
            ConnectionTypeEntry connectionTypeEntry = (ConnectionTypeEntry)comboBoxModel.getElementAt(i);
            IConnectionPanel iConnectionPanel = connectionTypeEntry.getConnectionDetail();
            if (!ModelUtil.areEqual((Object)string, (Object)iConnectionPanel.getConnectionType())) continue;
            this._types.setSelectedIndex(i);
            connectionTypeEntry.getConnectionDetail().updateProperties(properties);
            break;
        }
    }

    public void tableFocusChanged() {
        if (this._table.getSelectedRow() > -1) {
            Properties properties = ((ConnectionModel)this._table.getModel()).getRowData(this._table.getSelectedRow());
            this.tfdConnName.setText(properties.getProperty("ConnName"));
            String string = properties.getProperty("Connection-Color-For-Editors");
            Color color = Color.LIGHT_GRAY;
            if (string != null) {
                try {
                    color = new Color(Integer.parseInt(string));
                    this.connColor.setClosestSelectedColor(color);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.setActivePanel(properties);
            this._table.requestFocusInWindow();
        }
    }

    public boolean validateInput() {
        boolean bl = true;
        if (this.tfdConnName.getText() == null || this.tfdConnName.getText().trim().length() == 0) {
            MessageDialog.error((Component)this._dlg, (Object)Messages.getString("ConnectionDialog.11"), (String)Messages.getString("ConnectionDialog.12"), null);
            bl = false;
        } else if (!Pattern.matches(EXCLUSION_CHAR_PATTERN, this.tfdConnName.getText())) {
            MessageDialog.error((Component)this._dlg, (Object)Messages.getString("ConnectionDialog.13"), (String)Messages.getString("ConnectionDialog.12"), null);
            bl = false;
        }
        return bl;
    }

    private void processButtons(String string) {
        Object object;
        final ConnectionTypeEntry connectionTypeEntry = (ConnectionTypeEntry)this._types.getSelectedItem();
        Properties properties = new Properties();
        properties.setProperty("ConnName", this.tfdConnName.getText().trim());
        if (this.connColor.getSelectedColor() != null) {
            object = this.connColor.getSelectedColor();
            properties.setProperty("Connection-Color-For-Editors", "" + object.getRGB());
        }
        if (string == CLEAR) {
            connectionTypeEntry.getConnectionDetail().clearEntries();
            this.tfdConnName.setText("");
        } else if (string == TEST) {
            object = new ConnectRunnable(){

                protected Object doWork() throws Exception {
                    ConnectionDialog.this.testConnection(connectionTypeEntry);
                    return null;
                }
            };
            try {
                object.setTitle(Messages.getString("ConnectionDialog.16"));
                object.start(true);
            }
            catch (ProgressException progressException) {}
        } else if (string == SAVE && this.validateInput()) {
            object = this.getConnectionName();
            try {
                int n = this.checkForReplace((String)object, false);
                if (n == 1) {
                    Properties properties2 = this.getConnectionProperties();
                    String string2 = properties2.getProperty("SavePassword");
                    if (string2 != null && string2.equals(Boolean.toString(false))) {
                        Properties properties3 = new Properties();
                        properties3.putAll((Map<?, ?>)properties2);
                        properties3.remove("password");
                        properties2 = properties3;
                    }
                    this.registerConnection((String)object, properties2);
                    ((ConnectionModel)this._table.getModel()).reReadConnections();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        } else if (string == CONNECT && this.validateInput()) {
            object = this.getConnectionName();
            try {
                int n = this.checkForReplace((String)object, true);
                if (n == 1) {
                    ConnectRunnable connectRunnable = new ConnectRunnable((String)object){
                        final /* synthetic */ String val$cName;
                        {
                            this.val$cName = string;
                        }

                        protected Object doWork() throws Exception {
                            return ConnectionDialog.this.testConnection(connectionTypeEntry);
                        }

                        protected void finish(Object object) {
                            if (!this.isCanceled()) {
                                boolean bl;
                                boolean bl2 = bl = object instanceof Boolean && (Boolean)object != false;
                                if (bl) {
                                    try {
                                        final Properties properties = ConnectionDialog.this.getConnectionProperties();
                                        ConnectionDialog.this.registerConnection(this.val$cName, properties);
                                        ((ConnectionModel)ConnectionDialog.this._table.getModel()).reReadConnections();
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                block4: {
                                                    PasswordPrompter passwordPrompter = DatabaseProviderHelper.getPasswordPrompter();
                                                    try {
                                                        Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey(ConnectionDialog.this.m_store.getStoreName(), val$cName);
                                                        String string = connectionKey.getQualifiedName();
                                                        passwordPrompter.cache(properties);
                                                        Connections.getInstance().getConnection(string);
                                                    }
                                                    catch (DBException dBException) {
                                                        Throwable throwable;
                                                        if (passwordPrompter instanceof ConnectionPrompt) {
                                                            ((ConnectionPrompt)passwordPrompter).uncache(properties);
                                                        }
                                                        Throwable throwable2 = throwable = dBException;
                                                        while (throwable instanceof DBException) {
                                                            if ((throwable = throwable.getCause()) == null) continue;
                                                            throwable2 = throwable;
                                                        }
                                                        if (throwable2 instanceof ConnectionCanceledException) break block4;
                                                        ExceptionHandler.handleException((Throwable)throwable2);
                                                    }
                                                }
                                            }
                                        });
                                        ConnectionDialog.this._dlg.setVisible(false);
                                        ConnectionDialog.this._dlg.closeDialog(false);
                                    }
                                    catch (ConnectionException connectionException) {}
                                }
                            } else {
                                ConnectionDialog.this.showStatus(Messages.getString("ConnectionDialog.17"), false);
                            }
                        }
                    };
                    try {
                        connectRunnable.setTitle(Messages.getString("ConnectionDialog.18"));
                        connectRunnable.start(true);
                    }
                    catch (ProgressException progressException) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ConnectionInfo launch(DatabaseConnections databaseConnections, String string) {
        String string2 = databaseConnections != null ? databaseConnections.getStoreName() : "IdeConnections";
        String string3 = ConnectionDialog.launch(string2, string);
        return string3 != null ? new ConnectionInfo(string2, string3) : null;
    }

    private int checkForReplace(String string, boolean bl) throws ConnectionException {
        boolean bl2;
        Properties properties = this.m_store.getProperties(string);
        boolean bl3 = bl2 = (this.m_initName == null || ModelUtil.areDifferent((Object)string, (Object)this.m_initName)) && properties != null;
        if (bl2 && !bl || bl2 && bl && !this.equals(this.getConnectionProperties(), properties)) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.isConnectionFound(string, stringBuffer)) {
                String string2 = MessageFormat.format(Messages.getString("ConnectionDialog.21"), stringBuffer.toString());
                return MessageDialog.confirmOrCancel((Component)this, (Object)string2, (String)Messages.getString("ConnectionDialog.20"));
            }
            return MessageDialog.confirmOrCancel((Component)this, (Object)Messages.getString("ConnectionDialog.19"), (String)Messages.getString("ConnectionDialog.20"));
        }
        return 1;
    }

    private boolean isConnectionFound(String string, StringBuffer stringBuffer) {
        Object object;
        View view = Ide.getMainWindow().getLastActiveView();
        if (!(view instanceof DBNavigatorWindow)) {
            object = Ide.getMainWindow().getVisibleViews();
            for (int i = 0; i < object.size() && !((view = (View)object.get(i)) instanceof DBNavigatorWindow); ++i) {
            }
        }
        if (view instanceof DBNavigatorWindow) {
            object = (DBNavigatorWindow)view;
            NavigatorTreeNode navigatorTreeNode = ((NavigatorWindow)object).getTree().getRoot();
            Iterator<NavigatorTreeNode> iterator = navigatorTreeNode.getChildNodes();
            while (iterator.hasNext()) {
                NavigatorTreeNode navigatorTreeNode2 = iterator.next();
                Element element = navigatorTreeNode2.getElement();
                Iterator<NavigatorTreeNode> iterator2 = navigatorTreeNode.getChildNodes();
                while (iterator2.hasNext()) {
                    NavigatorTreeNode navigatorTreeNode3 = iterator2.next();
                    Element element2 = navigatorTreeNode3.getElement();
                    if (!element2.getClass().getName().equals("oracle.dbtools.raptor.navigator.folders.DatabasesFolder")) continue;
                    stringBuffer.append(navigatorTreeNode3.toString());
                    Iterator<NavigatorTreeNode> iterator3 = navigatorTreeNode.getChildNodes();
                    while (iterator3.hasNext()) {
                        NavigatorTreeNode navigatorTreeNode4 = iterator3.next();
                        Element element3 = navigatorTreeNode4.getElement();
                        if (!(element3 instanceof DatabaseConnection)) continue;
                        String string2 = ((DatabaseConnection)element3).getConnectionName();
                        return string.equals(string2);
                    }
                }
            }
        }
        return false;
    }

    private final boolean testConnection(ConnectionTypeEntry connectionTypeEntry) {
        this.showStatus("", false);
        Properties properties = this.getConnectionProperties();
        this.showStatus(ConnectionDialogArb.getString("CONNECTION_DIALOG_STATUS"), false);
        try {
            connectionTypeEntry.getConnectionDetail().testConnection(properties);
            if (!Thread.currentThread().isInterrupted()) {
                this.showStatus(ConnectionDialogArb.getString("CONNECTION_DIALOG_STATUS_SUCCESS"), false);
            }
            return true;
        }
        catch (ConnectionException connectionException) {
            this.showStatus(ConnectionDialogArb.getString("CONNECTION_DIALOG_STATUS_FAILURE") + connectionException.getLocalizedMessage(), true);
            return false;
        }
    }

    private boolean equals(Properties properties, Properties properties2) {
        boolean bl = false;
        if (properties != null && properties2 != null) {
            String string = properties.getProperty("customUrl");
            String string2 = properties2.getProperty("customUrl");
            String string3 = properties.getProperty("user");
            String string4 = properties2.getProperty("user");
            bl = ModelUtil.areEqual((Object)string, (Object)string2) && ModelUtil.areEqual((Object)string3, (Object)string4);
        }
        return bl;
    }

    public static String launch(String string) {
        return ConnectionDialog.launch("IdeConnections", string);
    }

    public static String launch(String string, String string2) {
        final ConnectionDialog connectionDialog = new ConnectionDialog();
        connectionDialog.setConnectionStore(string);
        if (string2 != null) {
            connectionDialog.setConnectionName(string2);
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)connectionDialog, "f1_idewcxnwelcome_html");
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)connectionDialog, null, (String)Messages.getString("ConnectionDialog.24"), (int)6);
        connectionDialog.initDialog(jEWTDialog);
        jEWTDialog.setModal(true);
        jEWTDialog.pack();
        String string3 = "connection.dialog.size";
        String string4 = Ide.getProperty((String)(string3 + ".width"));
        String string5 = Ide.getProperty((String)(string3 + ".height"));
        if (null == string4) {
            Ide.setProperty((String)(string3 + ".width"), (String)Integer.toString(780));
        }
        if (null == string5) {
            Ide.setProperty((String)(string3 + ".height"), (String)Integer.toString(500));
        }
        new SetMinSizer((Component)jEWTDialog, 780, 500);
        DialogSizeKeeper.attachToComponent((Component)jEWTDialog, (String)"connection.dialog.size");
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        Timer timer = new Timer("Focus", false);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                connectionDialog.tfdConnName.requestFocusInWindow();
            }
        }, 250L);
        jEWTDialog.setVisible(true);
        if (jEWTDialog.isCancelled()) {
            return null;
        }
        return connectionDialog.getConnectionName();
    }

    public static void main(String[] stringArray) {
        ConnectionDialog.launch(null);
    }

    private void registerConnection(String string, Properties properties) throws ConnectionException {
        if (this.m_store.getProperties(string) != null) {
            String string2;
            String string3 = (String)this.m_store.getProperties(string).get("RaptorConnectionType");
            if (!string3.equals(string2 = (String)properties.get("RaptorConnectionType"))) {
                this.m_store.removeConnection(string);
                this.m_store.addConnection(string, properties);
            } else {
                this.m_store.updateConnection(string, string, properties);
            }
        } else {
            this.m_store.addConnection(string, properties);
        }
    }

    private void showStatus(String string, boolean bl) {
        SwingUtilities.invokeLater(() -> {
            if (bl) {
                this.copyBtn.setVisible(true);
                this.lblStatus.setForeground(Color.RED);
            } else {
                this.copyBtn.setVisible(false);
                this.lblStatus.setForeground(Color.BLACK);
            }
            this.lblStatus.setText(string);
            this.lblStatus.getAccessibleContext().setAccessibleName(this.lblStatus.getText());
        });
    }

    private String getConnectionName() {
        return this.tfdConnName.getText().trim();
    }

    private void setConnectionStore(String string) {
        this.m_store = DatabaseConnectionStores.getInstance().getStore(string);
        this._table.setModel(new ConnectionModel(this.m_store));
    }

    public void setConnectionName(String string) {
        ConnectionTypeEntry connectionTypeEntry = (ConnectionTypeEntry)this._types.getSelectedItem();
        Properties properties = Connections.getInstance().getConnectionInfo(this.m_store.getStoreName(), string);
        if (properties != null) {
            this.m_initName = string;
            this.tfdConnName.setText(string);
            this.setActivePanel(properties);
            for (int i = 0; i < this._table.getRowCount(); ++i) {
                Object object = this._table.getValueAt(i, 0);
                if (!((String)this._table.getValueAt(i, 0)).equals(string)) continue;
                this._table.setRowSelectionInterval(i, i);
            }
        }
    }

    private static /* synthetic */ void lambda$new$0(CardLayout cardLayout, JPanel jPanel, ItemEvent itemEvent) {
        Object object;
        if (1 == itemEvent.getStateChange() && (object = itemEvent.getItem()) instanceof ConnectionTypeEntry) {
            String string = ((ConnectionTypeEntry)object).getConnectionType();
            cardLayout.show(jPanel, string);
        }
    }

    private static class ConnectionModel
    extends AbstractTableModel {
        List<Properties> data = null;
        DatabaseConnections m_store;

        public ConnectionModel(DatabaseConnections databaseConnections) {
            this.m_store = databaseConnections;
            this.data = ConnectionDialog.getAllConnections(this.m_store);
        }

        public void setData(ArrayList<Properties> arrayList) {
            assert (arrayList != null);
            this.data = arrayList;
        }

        public void reReadConnections() {
            this.data = ConnectionDialog.getAllConnections(this.m_store);
            this.fireTableStructureChanged();
            this.fireTableDataChanged();
        }

        public List<Properties> getData() {
            return this.data;
        }

        @Override
        public String getColumnName(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = ConnectionDialogArb.getString("CONNECTION_DIALOG_LIST_HEADER_NAME");
                    break;
                }
                case 1: {
                    string = ConnectionDialogArb.getString("CONNECTION_DIALOG_LIST_HEADER_DETAIL");
                }
            }
            return string;
        }

        @Override
        public int getRowCount() {
            return this.data != null ? this.data.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Properties properties = this.getRowData(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = properties.getProperty("ConnName");
                    break;
                }
                case 1: {
                    String string;
                    String string2 = properties.getProperty("hostname");
                    if (string2 != null) {
                        string = properties.getProperty("port");
                        String string3 = properties.getProperty("sid");
                        String string4 = properties.getProperty("serviceName");
                        string3 = string3 != null ? string3 : string4;
                        object = MessageFormat.format("//{0}:{1}/{2}", string2, string != null ? string : "1521", string3);
                    } else {
                        string = properties.getProperty("customUrl");
                        if (string != null) {
                            object = string.substring(string.lastIndexOf(64) + 1);
                        }
                    }
                    string = properties.getProperty("user");
                    if (string == null) {
                        string = "";
                    }
                    object = string + "@" + object;
                }
            }
            return object;
        }

        public Properties getRowData(int n) {
            return this.data.get(n);
        }
    }

    private static class SetMinSizer
    extends ComponentAdapter {
        Component comp;
        int width;
        int height;

        public SetMinSizer(Component component, int n, int n2) {
            this.comp = component;
            this.width = n;
            this.height = n2;
            this.comp.addComponentListener(this);
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            this.comp.setMinimumSize(new Dimension(this.width, this.height));
            this.comp.removeComponentListener(this);
        }
    }

    private static abstract class ConnectRunnable
    extends ProgressRunnable {
        boolean m_canceled;

        private ConnectRunnable() {
        }

        protected void doCancel() {
            super.doCancel();
            this.m_canceled = true;
        }

        boolean isCanceled() {
            return this.m_canceled;
        }
    }

    private static class ConnectionTypeEntry {
        private final String typeName;
        private final Component gui;
        private final IConnectionPanel connPanel;

        private ConnectionTypeEntry(String string, IConnectionPanel iConnectionPanel) {
            this.typeName = string;
            this.connPanel = iConnectionPanel;
            Box box = new Box(1);
            AuthenticationPanel authenticationPanel = iConnectionPanel.getAuthenticationPanel();
            Component component = authenticationPanel.getUI();
            if (component != null) {
                box.add(component);
            }
            box.add((Component)((Object)iConnectionPanel));
            this.gui = box;
        }

        public Component getUI() {
            return this.gui;
        }

        public String getConnectionType() {
            return this.typeName;
        }

        public IConnectionPanel getConnectionDetail() {
            return this.connPanel;
        }

        public String toString() {
            return this.getConnectionType();
        }
    }
}

