/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.util.Map;
import java.util.Properties;
import oracle.dbtools.raptor.connections.AuthenticationPanel;
import oracle.dbtools.raptor.connections.DefaultAuthenticationPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public abstract class IConnectionPanel
extends DefaultTraversablePanel {
    private static final StateProvider NULL_PROVIDER = new StateProvider(){

        @Override
        public void setStatus(String string) {
        }

        @Override
        public void setErrorState(String string) {
        }

        @Override
        public String getConnectionName() {
            return "";
        }
    };
    public static final String NAVIGATOR_CONNECTION_TYPE = "RaptorConnectionType";
    public static final String CONNECTION_NAME_KEY = "ConnName";
    public static final String PROPERTY_NO_PASSWORD_CONNECTION = "NoPasswordConnection";
    public static final String UNSHARED_WORKSHEET_ORIGINAL_CONNECTIONNAME = "UnsharedWorksheetOriginalConnectionName";
    private StateProvider mStateProvider = NULL_PROVIDER;
    private AuthenticationPanel authPanel;

    protected abstract void clear();

    protected abstract void updatePrompts(Properties var1);

    protected abstract void setDefaultPrompts();

    protected abstract Properties getInput(Properties var1);

    public abstract String getConnectionType();

    public abstract String getDriver();

    public final void clearEntries() {
        this.getAuthenticationPanel().clear();
        this.clear();
    }

    public final void updateProperties(Properties properties) {
        this.getAuthenticationPanel().setConnectionDetails(properties);
        this.updatePrompts(properties);
    }

    public final void resetToDefaults() {
        this.getAuthenticationPanel().initializeToDefaults();
        this.setDefaultPrompts();
    }

    public final Properties getConnectionProperties() {
        return this.getConnectionProperties(new Properties());
    }

    public final Properties getConnectionProperties(Properties properties) {
        properties.putAll((Map<?, ?>)this.getAuthenticationPanel().getConnectionDetails());
        return this.getInput(properties);
    }

    public String[] getSupportedDrivers() {
        return new String[]{this.getDriver()};
    }

    public final AuthenticationPanel getAuthenticationPanel() {
        if (this.authPanel == null) {
            this.authPanel = this.createAuthenticationPanel();
        }
        return this.authPanel;
    }

    protected AuthenticationPanel createAuthenticationPanel() {
        return new DefaultAuthenticationPanel();
    }

    public String getUserName() {
        return this.getAuthenticationPanel().getUsername();
    }

    public String getPassword() {
        return this.getAuthenticationPanel().getPassword();
    }

    protected void updatePassword(String string) {
        this.getAuthenticationPanel().updatePassword(string);
    }

    void setStatusDisplay(StateProvider stateProvider) {
        this.mStateProvider = stateProvider != null ? stateProvider : NULL_PROVIDER;
    }

    public final String getConnectionName() {
        return this.mStateProvider.getConnectionName();
    }

    public final void setStatus(String string) {
        this.mStateProvider.setStatus(string);
    }

    public final void setErrorStatus(String string) {
        this.mStateProvider.setErrorState(string);
    }

    protected void testConnection(Properties properties) throws ConnectionException {
        DatabaseConnections.getInstance().testConnection(properties);
    }

    public void initUI() {
    }

    public static interface StateProvider {
        public void setStatus(String var1);

        public void setErrorState(String var1);

        public String getConnectionName();
    }
}

