/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.ConnectionSubPanel;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.util.ResourceUtils;

public class ProxyConnectionPanel
extends ConnectionSubPanel {
    public static final String PROXY_TYPE_USER_NAME = "USER NAME";
    public static final String PROXY_TYPE_DISTINGUISHED_NAME = "DISTINGUISHED NAME";
    public static final String PROXY_TYPE = "PROXY_TYPE";
    public static final String IS_PROXY = "IS_PROXY";
    public static final String PROXY_CANCELLED = "Proxy Cancelled";
    private JCheckBox mEnableProxy = new JCheckBox();
    private JLabel mLblType = new JLabel(ConnectionDialogArb.getString("PROXY_TYPE"));
    private ButtonGroup mGroupType;
    private JRadioButton mBtnUser = new JRadioButton();
    private JRadioButton mBtnDN = new JRadioButton();
    private JLabel mLblUser = new JLabel();
    private JTextField mFldUser = new JTextField();
    private JLabel mLblProxyPwd = new JLabel();
    private JPasswordField mFldProxyPwd = new JPasswordField();
    private JLabel mLblDName = new JLabel();
    private JTextField mFldDName = new JTextField();

    private static int getPadding(JLabel jLabel, JLabel jLabel2) {
        int n = ProxyConnectionPanel.stringWidth(jLabel, jLabel.getText());
        int n2 = ProxyConnectionPanel.stringWidth(jLabel2, jLabel2.getText());
        return n2 > n ? n2 - n : 0;
    }

    private static int stringWidth(JComponent jComponent, String string) {
        return jComponent.getFontMetrics(jComponent.getFont()).stringWidth(string);
    }

    public static ProxyConnectionPanel createProxyPanel() {
        ProxyConnectionPanel proxyConnectionPanel = new ProxyConnectionPanel();
        proxyConnectionPanel.initialize();
        return proxyConnectionPanel;
    }

    private ProxyConnectionPanel() {
    }

    private void initialize() {
        this.mEnableProxy.addItemListener(itemEvent -> {
            Object object = itemEvent.getSource();
            if (object == this.mEnableProxy) {
                this.enableProxyUI(this.mEnableProxy.isSelected());
            }
        });
        this.enableProxyUI(this.mEnableProxy.isSelected());
    }

    @Override
    protected JComponent createUI() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.mEnableProxy, (String)ConnectionDialogArb.getString("PROXY_ENABLE"));
        jPanel.add((Component)this.mEnableProxy, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.mLblType, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        this.mGroupType = new ButtonGroup();
        ResourceUtils.resButton((AbstractButton)this.mBtnUser, (String)CreateDialogArb.getString("PROXY_TYPE_USER"));
        this.mGroupType.add(this.mBtnUser);
        this.mBtnUser.setActionCommand(PROXY_TYPE_USER_NAME);
        this.mBtnUser.setSelected(true);
        ResourceUtils.resButton((AbstractButton)this.mBtnDN, (String)CreateDialogArb.getString("PROXY_LABEL_DN"));
        this.mGroupType.add(this.mBtnDN);
        this.mBtnDN.setActionCommand(PROXY_TYPE_DISTINGUISHED_NAME);
        jPanel2.add((Component)this.mBtnUser, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP));
        jPanel2.add((Component)this.mBtnDN, LayoutControl.GBC.gbc(2, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2CONTROL_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.NONE, LayoutControl.GBC.Anchor.LINE_START));
        ResourceUtils.resLabel((JLabel)this.mLblUser, (Component)this.mFldUser, (String)CreateDialogArb.getString("PROXY_LABEL_USER"));
        jPanel2.add((Component)this.mLblUser, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.mFldUser, LayoutControl.GBC.gbc(1, 1, 2, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        ResourceUtils.resLabel((JLabel)this.mLblProxyPwd, (Component)this.mFldProxyPwd, (String)CreateDialogArb.getString("PROXY_LABEL_PASSWORD"));
        ResourceUtils.resLabel((JLabel)this.mLblDName, (Component)this.mFldDName, (String)CreateDialogArb.getString("PROXY_LABEL_DN"));
        ProxyConnectionPanel.layoutField(jPanel2, this.mLblProxyPwd, this.mFldProxyPwd, 2, ProxyConnectionPanel.getPadding(this.mLblProxyPwd, this.mLblDName));
        this.mBtnUser.addItemListener(itemEvent -> {
            if (this.mBtnUser.isSelected()) {
                jPanel2.remove(this.mLblDName);
                jPanel2.remove(this.mFldDName);
                ProxyConnectionPanel.layoutField(jPanel2, this.mLblProxyPwd, this.mFldProxyPwd, 2, ProxyConnectionPanel.getPadding(this.mLblProxyPwd, this.mLblDName));
                jPanel2.revalidate();
                jPanel2.repaint();
            }
        });
        this.mBtnDN.addItemListener(itemEvent -> {
            if (this.mBtnDN.isSelected()) {
                jPanel2.remove(this.mLblProxyPwd);
                jPanel2.remove(this.mFldProxyPwd);
                ProxyConnectionPanel.layoutField(jPanel2, this.mLblDName, this.mFldDName, 2, ProxyConnectionPanel.getPadding(this.mLblDName, this.mLblProxyPwd));
                jPanel2.revalidate();
                jPanel2.repaint();
            }
        });
        jPanel.add((Component)LayoutControl.GBC.createSubPanel(jPanel2), LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
        return jPanel;
    }

    private static void layoutField(JPanel jPanel, JLabel jLabel, JTextField jTextField, int n, int n2) {
        GridBagConstraints gridBagConstraints = LayoutControl.GBC.gbc(0, n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP);
        gridBagConstraints.ipadx = n2;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)jTextField, LayoutControl.GBC.gbc(1, n, 2, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
    }

    private String getProxyTypeSelected() {
        if (this.mBtnUser.isSelected()) {
            return PROXY_TYPE_USER_NAME;
        }
        return PROXY_TYPE_DISTINGUISHED_NAME;
    }

    private void enableProxyUI(boolean bl) {
        this.mLblType.setEnabled(bl);
        this.mBtnUser.setEnabled(bl);
        this.mBtnDN.setEnabled(bl);
        this.mFldProxyPwd.setEnabled(bl);
        this.mFldUser.setEnabled(bl);
        this.mFldDName.setEnabled(bl);
    }

    @Override
    public void setConnectionDetails(Properties properties) {
        boolean bl = Boolean.valueOf(properties.getProperty(IS_PROXY));
        this.mEnableProxy.setSelected(bl);
        this.enableProxyUI(bl);
        String string = properties.getProperty(PROXY_TYPE);
        if (PROXY_TYPE_DISTINGUISHED_NAME.equals(string)) {
            this.mBtnDN.setSelected(true);
            this.mFldDName.setText(properties.getProperty("PROXY_DISTINGUISHED_NAME"));
            this.mFldUser.setText(properties.getProperty("PROXY_USER_NAME"));
        } else {
            this.mBtnUser.setSelected(true);
            this.mFldUser.setText(properties.getProperty("PROXY_USER_NAME"));
            if (properties.getProperty("PROXY_USER_PASSWORD") != null) {
                this.mFldProxyPwd.setText(properties.getProperty("PROXY_USER_PASSWORD"));
            }
        }
    }

    @Override
    public Properties getConnectionDetails() {
        Properties properties = new Properties();
        boolean bl = this.mEnableProxy.isSelected();
        properties.setProperty(IS_PROXY, Boolean.toString(bl));
        String string = this.getProxyTypeSelected();
        if (string != null) {
            properties.setProperty(PROXY_TYPE, string);
            String string2 = this.mFldUser.getText();
            if (string2 != null) {
                string2 = string2.trim();
            }
            properties.setProperty("PROXY_USER_NAME", string2);
            if (string.equals(PROXY_TYPE_USER_NAME)) {
                char[] cArray = this.mFldProxyPwd.getPassword();
                String string3 = cArray != null ? new String(cArray) : "";
                if ((string3 = string3.trim()).length() > 0) {
                    properties.setProperty("PROXY_USER_PASSWORD", string3);
                }
            } else if (string.equals(PROXY_TYPE_DISTINGUISHED_NAME)) {
                String string4 = this.mFldDName.getText();
                properties.setProperty("PROXY_DISTINGUISHED_NAME", string4);
            }
        }
        return properties;
    }

    @Override
    public void initializeToDefaults() {
        this.clear();
    }

    @Override
    public void clear() {
        this.mEnableProxy.setSelected(false);
        this.mFldDName.setText("");
        this.mFldProxyPwd.setText("");
        this.mFldUser.setText("");
        this.mBtnUser.doClick();
    }
}

