/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.awt.Component;
import java.net.URL;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.connections.impexp.FilenamePanel;
import oracle.dbtools.raptor.connections.impexp.ImpExpFile;
import oracle.dbtools.raptor.connections.impexp.ImpExpResources;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;

public class ExportFilenamePanel
extends FilenamePanel {
    @Override
    protected URL getURLFromNamespace(TraversableContext traversableContext) {
        ImpExpFile impExpFile = (ImpExpFile)traversableContext.get("ImportExport.DESTINATION");
        return impExpFile.getURL();
    }

    @Override
    protected void setURLInNamespace(URL uRL, TraversableContext traversableContext) throws TraversalException {
        ImpExpFile impExpFile = (ImpExpFile)traversableContext.get("ImportExport.DESTINATION");
        impExpFile.setURL(uRL);
        traversableContext.put("ImportExport.DESTINATION", (Object)impExpFile);
    }

    @Override
    boolean isURLAccepted(URL uRL) {
        return JSON_FILTER.accept(uRL);
    }

    @Override
    protected void validateURL(URL uRL) throws TraversalException {
        super.validateURL(uRL);
        if (URLFileSystem.exists((URL)uRL)) {
            if (!MessageDialog.confirm((Component)this.getComponent(), (Object)ConnectionArb.format((String)"IMPEXP_EXISTING_FILE_WARNING", (Object[])new Object[]{URLFileSystem.getPlatformPathName((URL)uRL)}), (String)ConnectionArb.getString((String)"IMPEXP_EXISTING_FILE_TITLE"), null, (boolean)true)) {
                throw new TraversalException(null);
            }
            if (!URLFileSystem.canWrite((URL)uRL)) {
                throw new TraversalException(ImpExpResources.format("ERROR_CANNOT_WRITE_FILE", URLFileSystem.getPlatformPathName((URL)uRL)), ConnectionArb.getString((String)"IMPEXP_BAD_FILE_TITLE"));
            }
        }
    }

    @Override
    public String getHelpID() {
        return "f1_idedexportcxn_html";
    }

    @Override
    protected URLFileChooser.URLFileChooserPanel createChooserPanel() {
        URLFileChooser.URLFileChooserPanel uRLFileChooserPanel = URLFileChooser.createURLFileChooserPanel(1, ImpExpResources.getString("FILENAME_LABEL"), ImpExpResources.getString("CHOOSER_TITLE_EXPORT"), true, true);
        uRLFileChooserPanel.clearChooseableURLFilters();
        uRLFileChooserPanel.addChooseableURLFilter(JSON_FILTER);
        return uRLFileChooserPanel;
    }

    @Override
    protected String getDescriptionText() {
        return ImpExpResources.getString("BOILERPLATE_EXPORT");
    }

    @Override
    protected Boolean getBackButtonState(TraversableContext traversableContext) {
        return null;
    }

    @Override
    protected Boolean getNextButtonState(TraversableContext traversableContext) {
        return Boolean.TRUE;
    }

    @Override
    protected Boolean getFinishButtonState(TraversableContext traversableContext) {
        return Boolean.FALSE;
    }

    @Override
    protected String getUnacceptableFileMessageID() {
        return "IMPEXP_BAD_FILE_ERROR";
    }
}

