/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.awt.Color;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.display.chart.Archiver;
import oracle.dbtools.raptor.controls.display.chart.BarLabelPosition;
import oracle.dbtools.raptor.controls.display.chart.BooleanArchiver;
import oracle.dbtools.raptor.controls.display.chart.BooleanListArchiver;
import oracle.dbtools.raptor.controls.display.chart.ChartFont;
import oracle.dbtools.raptor.controls.display.chart.ChartFontArchiver;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManagerImpl;
import oracle.dbtools.raptor.controls.display.chart.ChartType;
import oracle.dbtools.raptor.controls.display.chart.ColorListArchiver;
import oracle.dbtools.raptor.controls.display.chart.EnumArchiver;
import oracle.dbtools.raptor.controls.display.chart.EnumListArchiver;
import oracle.dbtools.raptor.controls.display.chart.FitlineType;
import oracle.dbtools.raptor.controls.display.chart.GraphType;
import oracle.dbtools.raptor.controls.display.chart.IntegerArchiver;
import oracle.dbtools.raptor.controls.display.chart.LineType;
import oracle.dbtools.raptor.controls.display.chart.LineWidth;
import oracle.dbtools.raptor.controls.display.chart.MarkerShape;
import oracle.dbtools.raptor.controls.display.chart.NumberFormats;
import oracle.dbtools.raptor.controls.display.chart.NumberFormatsArchiver;
import oracle.dbtools.raptor.controls.display.chart.PropertyDef;
import oracle.dbtools.raptor.controls.display.chart.PropertyGroup;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;
import oracle.dbtools.raptor.controls.display.chart.SliceLabelPosition;
import oracle.dbtools.raptor.controls.display.chart.SliceLabelType;
import oracle.dbtools.raptor.controls.display.chart.TransparentColor;
import oracle.dbtools.raptor.controls.display.chart.TransparentColorArchiver;
import oracle.dss.graph.Graph;
import oracle.dss.graph.Series;
import oracle.dss.util.SeriesOutOfRangeException;

class PlotAreaProperties
extends PropertyGroup {
    PlotAreaProperties() {
    }

    @Override
    void register(Map<PropertyType, PropertyDef> map) {
        BitSet bitSet = ChartType.all();
        map.put(PropertyType.PLOT_BACKGROUND_COLOR, new PropertyDef<TransparentColor>(bitSet){
            private TransparentColorArchiver archiver;
            {
                this.archiver = new TransparentColorArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.BACKGROUND_COLOR;
            }

            @Override
            TransparentColor getGraphValue(Graph graph) {
                return new TransparentColor(graph.getPlotArea().isFillTransparent(), graph.getPlotArea().getFillColor());
            }

            @Override
            void setGraphValue(Graph graph, TransparentColor transparentColor) {
                graph.getPlotArea().setFillColor(transparentColor.color());
                graph.getPlotArea().setFillTransparent(transparentColor.transparent().booleanValue());
            }

            @Override
            Archiver<TransparentColor> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_BORDER_COLOR, new PropertyDef<TransparentColor>(bitSet){
            private TransparentColorArchiver archiver;
            {
                this.archiver = new TransparentColorArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FOREGROUND_COLOR;
            }

            @Override
            TransparentColor getGraphValue(Graph graph) {
                return new TransparentColor(graph.getPlotArea().isBorderTransparent(), graph.getPlotArea().getBorderColor());
            }

            @Override
            void setGraphValue(Graph graph, TransparentColor transparentColor) {
                graph.getPlotArea().setBorderColor(transparentColor.color());
                graph.getPlotArea().setBorderTransparent(transparentColor.transparent().booleanValue());
            }

            @Override
            Archiver<TransparentColor> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet2 = ChartType.vBars();
        bitSet2.or(ChartType.hBars());
        bitSet2.or(ChartType.stocks());
        bitSet2.or(ChartType.paretos());
        bitSet2.or(ChartType.lines());
        bitSet2.or(ChartType.areas());
        bitSet2.or(ChartType.combinations());
        bitSet2.or(ChartType.scatters());
        bitSet2.or(ChartType.bubbles());
        map.put(PropertyType.PLOT_HGRID, new PropertyDef<Boolean>(bitSet2){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.GRID;
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getY1MajorTick().getTickStyle() == 5;
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getY1MajorTick().setTickStyle(bl != false ? 5 : 6);
                graph.getY2MajorTick().setTickStyle(bl != false ? 5 : 6);
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_HGRID_COLOR, new PropertyDef<TransparentColor>(bitSet2){
            private TransparentColorArchiver archiver;
            {
                this.archiver = new TransparentColorArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FOREGROUND_COLOR;
            }

            @Override
            TransparentColor getGraphValue(Graph graph) {
                return new TransparentColor(false, graph.getY1MajorTick().getLineColor());
            }

            @Override
            void setGraphValue(Graph graph, TransparentColor transparentColor) {
                graph.getY1MajorTick().setLineColor(transparentColor.color());
                graph.getY2MajorTick().setLineColor(transparentColor.color());
            }

            @Override
            Archiver<TransparentColor> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_HGRID_WIDTH, new PropertyDef<LineWidth>(bitSet2){
            private EnumArchiver<LineWidth> archiver;
            {
                this.archiver = new EnumArchiver(LineWidth.class, (Enum[])LineWidth.values());
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.GRID_WIDTH;
            }

            @Override
            LineWidth getGraphValue(Graph graph) {
                return LineWidth.get(graph.getY1MajorTick().getLineWidth());
            }

            @Override
            void setGraphValue(Graph graph, LineWidth lineWidth) {
                graph.getY1MajorTick().setLineWidth(lineWidth.pixels());
                graph.getY2MajorTick().setLineWidth(lineWidth.pixels());
            }

            @Override
            Archiver<LineWidth> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_VGRID, new PropertyDef<Boolean>(bitSet2){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.GRID;
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getLegendArea().isVisible();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getO1MajorTick().setTickStyle(bl != false ? 0 : 6);
                graph.getX1MajorTick().setTickStyle(bl != false ? 5 : 6);
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_VGRID_COLOR, new PropertyDef<TransparentColor>(bitSet2){
            private TransparentColorArchiver archiver;
            {
                this.archiver = new TransparentColorArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FOREGROUND_COLOR;
            }

            @Override
            TransparentColor getGraphValue(Graph graph) {
                return new TransparentColor(false, graph.getO1MajorTick().getLineColor());
            }

            @Override
            void setGraphValue(Graph graph, TransparentColor transparentColor) {
                graph.getO1MajorTick().setLineColor(transparentColor.color());
                graph.getX1MajorTick().setLineColor(transparentColor.color());
            }

            @Override
            Archiver<TransparentColor> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_VGRID_WIDTH, new PropertyDef<LineWidth>(bitSet2){
            private EnumArchiver<LineWidth> archiver;
            {
                this.archiver = new EnumArchiver(LineWidth.class, (Enum[])LineWidth.values());
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.GRID_WIDTH;
            }

            @Override
            LineWidth getGraphValue(Graph graph) {
                return LineWidth.get(graph.getX1MajorTick().getLineWidth());
            }

            @Override
            void setGraphValue(Graph graph, LineWidth lineWidth) {
                graph.getO1MajorTick().setLineWidth(lineWidth.pixels());
                graph.getX1MajorTick().setLineWidth(lineWidth.pixels());
            }

            @Override
            Archiver<LineWidth> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet3 = ChartType.polars();
        bitSet3.or(ChartType.radars());
        map.put(PropertyType.PLOT_CGRID, new PropertyDef<Boolean>(bitSet3){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.GRID;
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getY1MajorTick().getTickStyle() == 5;
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getY1MajorTick().setTickStyle(bl != false ? 5 : 6);
                graph.getY2MajorTick().setTickStyle(bl != false ? 5 : 6);
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_CGRID_COLOR, new PropertyDef<TransparentColor>(bitSet3){
            private TransparentColorArchiver archiver;
            {
                this.archiver = new TransparentColorArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FOREGROUND_COLOR;
            }

            @Override
            TransparentColor getGraphValue(Graph graph) {
                return new TransparentColor(false, graph.getY1MajorTick().getLineColor());
            }

            @Override
            void setGraphValue(Graph graph, TransparentColor transparentColor) {
                graph.getY1MajorTick().setLineColor(transparentColor.color());
                graph.getY2MajorTick().setLineColor(transparentColor.color());
            }

            @Override
            Archiver<TransparentColor> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_RGRID, new PropertyDef<Boolean>(bitSet3){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.GRID;
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getO1MajorTick().getTickStyle() == 0;
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getO1MajorTick().setTickStyle(bl != false ? 0 : 6);
                graph.getX1MajorTick().setTickStyle(bl != false ? 5 : 6);
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_RGRID_COLOR, new PropertyDef<TransparentColor>(bitSet3){
            private TransparentColorArchiver archiver;
            {
                this.archiver = new TransparentColorArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FOREGROUND_COLOR;
            }

            @Override
            TransparentColor getGraphValue(Graph graph) {
                return new TransparentColor(false, graph.getO1MajorTick().getLineColor());
            }

            @Override
            void setGraphValue(Graph graph, TransparentColor transparentColor) {
                graph.getO1MajorTick().setLineColor(transparentColor.color());
                graph.getX1MajorTick().setLineColor(transparentColor.color());
            }

            @Override
            Archiver<TransparentColor> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_RGRID_WIDTH, new PropertyDef<LineWidth>(bitSet3){
            private EnumArchiver<LineWidth> archiver;
            {
                this.archiver = new EnumArchiver(LineWidth.class, (Enum[])LineWidth.values());
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.GRID_WIDTH;
            }

            @Override
            LineWidth getGraphValue(Graph graph) {
                return LineWidth.get(graph.getO1MajorTick().getLineWidth());
            }

            @Override
            void setGraphValue(Graph graph, LineWidth lineWidth) {
                graph.getO1MajorTick().setLineWidth(lineWidth.pixels());
                graph.getX1MajorTick().setLineWidth(lineWidth.pixels());
            }

            @Override
            Archiver<LineWidth> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet4 = ChartType.vBars();
        bitSet4.or(ChartType.hBars());
        bitSet4.or(ChartType.stocks());
        bitSet4.or(ChartType.paretos());
        bitSet4.or(ChartType.lines());
        bitSet4.or(ChartType.areas());
        bitSet4.or(ChartType.combinations());
        bitSet4.or(ChartType.scatters());
        bitSet4.or(ChartType.bubbles());
        bitSet4.or(ChartType.pies());
        bitSet4.or(ChartType.polars());
        bitSet4.or(ChartType.radars());
        bitSet4.or(ChartType.funnels());
        map.put(PropertyType.PLOT_DATALABELS, new PropertyDef<Boolean>(bitSet4){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getMarkerText().isVisible();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getMarkerText().setVisible(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_DATALABELS_FONT, new PropertyDef<ChartFont>(bitSet4){
            private ChartFontArchiver archiver;
            {
                this.archiver = new ChartFontArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FONT;
            }

            @Override
            ChartFont getGraphValue(Graph graph) {
                return this.archiver.retrieveValue(graph.getMarkerText().getGraphFont());
            }

            @Override
            void setGraphValue(Graph graph, ChartFont chartFont) {
                this.archiver.applyValue(chartFont, graph.getMarkerText().getGraphFont());
            }

            @Override
            Archiver<ChartFont> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_DATALABELS_NUMBER_FORMATS, new PropertyDef<NumberFormats>(bitSet4){
            private NumberFormatsArchiver archiver;
            {
                this.archiver = new NumberFormatsArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.NUMBER_FORMATS;
            }

            @Override
            NumberFormats getGraphValue(Graph graph) {
                return this.archiver.retrieveValue(graph.getMarkerText().getViewFormat(1));
            }

            @Override
            void setGraphValue(Graph graph, NumberFormats numberFormats) {
                this.archiver.applyValue(numberFormats, graph.getMarkerText().getViewFormat(1));
            }

            @Override
            Archiver<NumberFormats> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet5 = ChartType.vBars();
        bitSet5.or(ChartType.hBars());
        bitSet5.or(ChartType.stocks());
        bitSet5.or(ChartType.paretos());
        map.put(PropertyType.PLOT_DATALABELS_BAR_POSITION, new PropertyDef<BarLabelPosition>(bitSet5){
            private EnumArchiver<BarLabelPosition> archiver;
            {
                this.archiver = new EnumArchiver(BarLabelPosition.class, (Enum[])BarLabelPosition.values());
            }

            @Override
            BarLabelPosition getGraphValue(Graph graph) {
                return BarLabelPosition.get(graph.getMarkerText().getMarkerTextPlace());
            }

            @Override
            void setGraphValue(Graph graph, BarLabelPosition barLabelPosition) {
                graph.getMarkerText().setMarkerTextPlace(barLabelPosition.graphConstant());
            }

            @Override
            Archiver<BarLabelPosition> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet6 = ChartType.pies();
        bitSet6.or(ChartType.funnels());
        map.put(PropertyType.PLOT_DATALABELS_SLICE_TYPE, new PropertyDef<SliceLabelType>(bitSet6){
            private EnumArchiver<SliceLabelType> archiver;
            {
                this.archiver = new EnumArchiver(SliceLabelType.class, (Enum[])SliceLabelType.values());
            }

            @Override
            SliceLabelType getGraphValue(Graph graph) {
                return SliceLabelType.get(graph.getSliceLabel().getTextType());
            }

            @Override
            void setGraphValue(Graph graph, SliceLabelType sliceLabelType) {
                graph.getSliceLabel().setTextType(sliceLabelType.graphConstant());
            }

            @Override
            Archiver<SliceLabelType> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_DATALABELS_SLICE_POSITION, new PropertyDef<SliceLabelPosition>(bitSet6){
            private EnumArchiver<SliceLabelPosition> archiver;
            {
                this.archiver = new EnumArchiver(SliceLabelPosition.class, (Enum[])SliceLabelPosition.values());
            }

            @Override
            SliceLabelPosition getGraphValue(Graph graph) {
                return SliceLabelPosition.get(graph.getSlice().getLabelPosition());
            }

            @Override
            void setGraphValue(Graph graph, SliceLabelPosition sliceLabelPosition) {
                graph.getSlice().setLabelPosition(sliceLabelPosition.graphConstant());
            }

            @Override
            Archiver<SliceLabelPosition> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet7 = ChartType.vBars();
        bitSet7.or(ChartType.hBars());
        bitSet7.or(ChartType.stocks());
        bitSet7.or(ChartType.paretos());
        bitSet7.or(ChartType.lines());
        bitSet7.or(ChartType.areas());
        bitSet7.or(ChartType.combinations());
        bitSet7.or(ChartType.scatters());
        bitSet7.or(ChartType.bubbles());
        bitSet7.or(ChartType.pies());
        bitSet7.or(ChartType.polars());
        bitSet7.or(ChartType.radars());
        bitSet7.or(ChartType.funnels());
        bitSet7.or(ChartType.threeDs());
        map.put(PropertyType.PLOT_DATATIPS_TEXT, new PropertyDef<Boolean>(bitSet7){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return (graph.getMarkerTooltipType() & 8) != 0;
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                if (bl.booleanValue()) {
                    graph.setMarkerTooltipType(graph.getMarkerTooltipType() | 8);
                } else {
                    graph.setMarkerTooltipType(graph.getMarkerTooltipType() & 0xFFFFFFF7);
                }
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_DATATIPS_VALUE, new PropertyDef<Boolean>(bitSet7){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return (graph.getMarkerTooltipType() & 1) != 0;
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                if (bl.booleanValue()) {
                    graph.setMarkerTooltipType(graph.getMarkerTooltipType() | 1);
                } else {
                    graph.setMarkerTooltipType(graph.getMarkerTooltipType() & 0xFFFFFFFE);
                }
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet8 = ChartType.stacked();
        map.put(PropertyType.PLOT_DATATIPS_CUMULATIVE_VALUE, new PropertyDef<Boolean>(bitSet8){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return (graph.getMarkerTooltipType() & 2) != 0;
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                if (bl.booleanValue()) {
                    graph.setMarkerTooltipType(graph.getMarkerTooltipType() | 2);
                } else {
                    graph.setMarkerTooltipType(graph.getMarkerTooltipType() & 0xFFFFFFFD);
                }
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet9 = ChartType.pies();
        map.put(PropertyType.PLOT_DATATIPS_PERCENT, new PropertyDef<Boolean>(bitSet9){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return (graph.getMarkerTooltipType() & 4) != 0;
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                if (bl.booleanValue()) {
                    graph.setMarkerTooltipType(graph.getMarkerTooltipType() | 4);
                } else {
                    graph.setMarkerTooltipType(graph.getMarkerTooltipType() & 0xFFFFFFFB);
                }
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet10 = ChartType.vBars();
        bitSet10.or(ChartType.hBars());
        bitSet10.or(ChartType.areas());
        bitSet10.or(ChartType.bubbles());
        bitSet10.or(ChartType.funnels());
        bitSet10.or(ChartType.pies());
        bitSet10.or(ChartType.stocks());
        bitSet10.or(ChartType.threeDs());
        bitSet10.or(ChartType.lines());
        bitSet10.or(ChartType.combinations());
        bitSet10.or(ChartType.scatters());
        bitSet10.or(ChartType.polars());
        bitSet10.or(ChartType.radars());
        bitSet10.or(ChartType.paretos());
        map.put(PropertyType.PLOT_SERIES_OBJECT_COUNT, new PropertyDef<Integer>(bitSet10){
            private IntegerArchiver archiver;
            {
                this.archiver = new IntegerArchiver();
            }

            @Override
            Integer getGraphValue(Graph graph) {
                return graph.getSeriesObjectCount();
            }

            @Override
            void setGraphValue(Graph graph, Integer n) {
                graph.setSeriesObjectCount(n.intValue());
            }

            @Override
            Archiver<Integer> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.PLOT_SERIES_OPTIONS_COLOR, new PropertyDef<List<Color>>(bitSet10){
            private ColorListArchiver archiver;
            {
                this.archiver = new ColorListArchiver(){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<Color> list) {
                        if (list.size() != chartPropertyManagerImpl.get(PropertyType.PLOT_SERIES_OBJECT_COUNT, Integer.class).intValue()) {
                            throw new IllegalArgumentException();
                        }
                    }

                    @Override
                    List<Color> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.PLOT_SERIES_OBJECT_COUNT, Integer.class);
                        ArrayList<Color> arrayList = new ArrayList<Color>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(Color.BLACK);
                        }
                        return arrayList;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.PLOT_SERIES_OBJECT_COUNT};
            }

            @Override
            List<Color> getGraphValue(Graph graph) {
                int n = graph.getSeriesObjectCount();
                Series series = graph.getSeries();
                ArrayList<Color> arrayList = new ArrayList<Color>(n);
                for (int i = 0; i < n; ++i) {
                    try {
                        arrayList.add(series.getColor(i));
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        arrayList.add(Color.WHITE);
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, seriesOutOfRangeException.getStackTrace()[0].toString(), seriesOutOfRangeException);
                    }
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<Color> list) {
                Series series = graph.getSeries();
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        series.setColor(list.get(i), i);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, seriesOutOfRangeException.getStackTrace()[0].toString(), seriesOutOfRangeException);
                    }
                }
            }

            @Override
            Archiver<List<Color>> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet11 = ChartType.vBars();
        bitSet11.or(ChartType.hBars());
        bitSet11.or(ChartType.areas());
        bitSet11.or(ChartType.bubbles());
        bitSet11.or(ChartType.funnels());
        bitSet11.or(ChartType.lines());
        bitSet11.or(ChartType.combinations());
        bitSet11.or(ChartType.scatters());
        map.put(PropertyType.PLOT_SERIES_OPTIONS_FITLINE_TYPE, new PropertyDef<List<FitlineType>>(bitSet11){
            private EnumListArchiver<FitlineType> archiver;
            {
                this.archiver = new EnumListArchiver<FitlineType>(FitlineType.class){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<FitlineType> list) {
                        if (list.size() != chartPropertyManagerImpl.get(PropertyType.PLOT_SERIES_OBJECT_COUNT, Integer.class).intValue()) {
                            throw new IllegalArgumentException();
                        }
                    }

                    @Override
                    List<FitlineType> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.PLOT_SERIES_OBJECT_COUNT, Integer.class);
                        ArrayList<FitlineType> arrayList = new ArrayList<FitlineType>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(FitlineType.LINEAR);
                        }
                        return arrayList;
                    }

                    @Override
                    Object getDefaultItem() {
                        return FitlineType.LINEAR;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.PLOT_SERIES_OBJECT_COUNT};
            }

            @Override
            List<FitlineType> getGraphValue(Graph graph) {
                int n = graph.getSeriesObjectCount();
                Series series = graph.getSeries();
                ArrayList<FitlineType> arrayList = new ArrayList<FitlineType>(n);
                for (int i = 0; i < n; ++i) {
                    try {
                        arrayList.add(FitlineType.get(series.getFitlineType(i)));
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        arrayList.add(FitlineType.NONE);
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, seriesOutOfRangeException.getStackTrace()[0].toString(), seriesOutOfRangeException);
                    }
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<FitlineType> list) {
                Series series = graph.getSeries();
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        series.setFitlineType(list.get(i).graphConstant(), i);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, seriesOutOfRangeException.getStackTrace()[0].toString(), seriesOutOfRangeException);
                    }
                }
            }

            @Override
            Archiver<List<FitlineType>> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet12 = ChartType.lines();
        bitSet12.or(ChartType.combinations());
        bitSet12.or(ChartType.radars());
        bitSet12.or(ChartType.paretos());
        map.put(PropertyType.PLOT_SERIES_OPTIONS_LINE_WIDTH, new PropertyDef<List<LineWidth>>(bitSet12){
            private EnumListArchiver<LineWidth> archiver;
            {
                this.archiver = new EnumListArchiver<LineWidth>(LineWidth.class){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<LineWidth> list) {
                        if (list.size() != chartPropertyManagerImpl.get(PropertyType.PLOT_SERIES_OBJECT_COUNT, Integer.class).intValue()) {
                            throw new IllegalArgumentException();
                        }
                    }

                    @Override
                    List<LineWidth> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.PLOT_SERIES_OBJECT_COUNT, Integer.class);
                        ArrayList<LineWidth> arrayList = new ArrayList<LineWidth>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(LineWidth.THINNEST);
                        }
                        return arrayList;
                    }

                    @Override
                    Object getDefaultItem() {
                        return LineWidth.THIN;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.PLOT_SERIES_OBJECT_COUNT};
            }

            @Override
            List<LineWidth> getGraphValue(Graph graph) {
                int n = graph.getSeriesObjectCount();
                Series series = graph.getSeries();
                ArrayList<LineWidth> arrayList = new ArrayList<LineWidth>(n);
                for (int i = 0; i < n; ++i) {
                    try {
                        arrayList.add(LineWidth.get(series.getLineWidth(i)));
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        arrayList.add(LineWidth.THINNEST);
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, seriesOutOfRangeException.getStackTrace()[0].toString(), seriesOutOfRangeException);
                    }
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<LineWidth> list) {
                Series series = graph.getSeries();
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        series.setLineWidth(list.get(i).pixels(), i);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, seriesOutOfRangeException.getStackTrace()[0].toString(), seriesOutOfRangeException);
                    }
                }
            }

            @Override
            Archiver<List<LineWidth>> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet13 = ChartType.lines();
        bitSet13.or(ChartType.combinations());
        bitSet13.or(ChartType.scatters());
        bitSet13.or(ChartType.polars());
        bitSet13.or(ChartType.radars());
        bitSet13.or(ChartType.paretos());
        map.put(PropertyType.PLOT_SERIES_OPTIONS_MARKER_SHAPE, new PropertyDef<List<MarkerShape>>(bitSet13){
            private EnumListArchiver<MarkerShape> archiver;
            {
                this.archiver = new EnumListArchiver<MarkerShape>(MarkerShape.class){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<MarkerShape> list) {
                        if (list.size() != chartPropertyManagerImpl.get(PropertyType.PLOT_SERIES_OBJECT_COUNT, Integer.class).intValue()) {
                            throw new IllegalArgumentException();
                        }
                    }

                    @Override
                    List<MarkerShape> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.PLOT_SERIES_OBJECT_COUNT, Integer.class);
                        ArrayList<MarkerShape> arrayList = new ArrayList<MarkerShape>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(MarkerShape.AUTOMATIC);
                        }
                        return arrayList;
                    }

                    @Override
                    Object getDefaultItem() {
                        return MarkerShape.AUTOMATIC;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.PLOT_SERIES_OBJECT_COUNT};
            }

            @Override
            List<MarkerShape> getGraphValue(Graph graph) {
                int n = graph.getSeriesObjectCount();
                Series series = graph.getSeries();
                ArrayList<MarkerShape> arrayList = new ArrayList<MarkerShape>(n);
                for (int i = 0; i < n; ++i) {
                    try {
                        arrayList.add(MarkerShape.get(series.getMarkerShape(i)));
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        arrayList.add(MarkerShape.AUTOMATIC);
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, seriesOutOfRangeException.getStackTrace()[0].toString(), seriesOutOfRangeException);
                    }
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<MarkerShape> list) {
                Series series = graph.getSeries();
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        series.setMarkerShape(list.get(i).graphConstant(), i);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, seriesOutOfRangeException.getStackTrace()[0].toString(), seriesOutOfRangeException);
                    }
                }
            }

            @Override
            Archiver<List<MarkerShape>> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet14 = ChartType.lines();
        bitSet14.or(ChartType.radars());
        map.put(PropertyType.PLOT_SERIES_OPTIONS_LINE_TYPE, new PropertyDef<List<LineType>>(bitSet14){
            private EnumListArchiver<LineType> archiver;
            {
                this.archiver = new EnumListArchiver<LineType>(LineType.class){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<LineType> list) {
                        if (list.size() != chartPropertyManagerImpl.get(PropertyType.PLOT_SERIES_OBJECT_COUNT, Integer.class).intValue()) {
                            throw new IllegalArgumentException();
                        }
                    }

                    @Override
                    List<LineType> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.PLOT_SERIES_OBJECT_COUNT, Integer.class);
                        ArrayList<LineType> arrayList = new ArrayList<LineType>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(LineType.LINE);
                        }
                        return arrayList;
                    }

                    @Override
                    Object getDefaultItem() {
                        return LineType.LINE;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.PLOT_SERIES_OBJECT_COUNT};
            }

            @Override
            List<LineType> getGraphValue(Graph graph) {
                int n = graph.getSeriesObjectCount();
                Series series = graph.getSeries();
                ArrayList<LineType> arrayList = new ArrayList<LineType>(n);
                for (int i = 0; i < n; ++i) {
                    try {
                        arrayList.add(LineType.get(series.getMarkerType(i)));
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        arrayList.add(LineType.LINE);
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, seriesOutOfRangeException.getStackTrace()[0].toString(), seriesOutOfRangeException);
                    }
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<LineType> list) {
                Series series = graph.getSeries();
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        series.setMarkerType(list.get(i).graphConstant(), i);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, seriesOutOfRangeException.getStackTrace()[0].toString(), seriesOutOfRangeException);
                    }
                }
            }

            @Override
            Archiver<List<LineType>> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet15 = ChartType.combinations();
        map.put(PropertyType.PLOT_SERIES_OPTIONS_GRAPH_TYPE, new PropertyDef<List<GraphType>>(bitSet15){
            private EnumListArchiver<GraphType> archiver;
            {
                this.archiver = new EnumListArchiver<GraphType>(GraphType.class){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<GraphType> list) {
                        if (list.size() != chartPropertyManagerImpl.get(PropertyType.PLOT_SERIES_OBJECT_COUNT, Integer.class).intValue()) {
                            throw new IllegalArgumentException();
                        }
                    }

                    @Override
                    List<GraphType> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.PLOT_SERIES_OBJECT_COUNT, Integer.class);
                        ArrayList<GraphType> arrayList = new ArrayList<GraphType>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(GraphType.LINE);
                        }
                        return arrayList;
                    }

                    @Override
                    Object getDefaultItem() {
                        return GraphType.LINE;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.PLOT_SERIES_OBJECT_COUNT};
            }

            @Override
            List<GraphType> getGraphValue(Graph graph) {
                int n = graph.getSeriesObjectCount();
                Series series = graph.getSeries();
                ArrayList<GraphType> arrayList = new ArrayList<GraphType>(n);
                for (int i = 0; i < n; ++i) {
                    try {
                        arrayList.add(GraphType.get(series.getMarkerType(i)));
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        arrayList.add(GraphType.BAR);
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, seriesOutOfRangeException.getStackTrace()[0].toString(), seriesOutOfRangeException);
                    }
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<GraphType> list) {
                Series series = graph.getSeries();
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        series.setMarkerType(list.get(i).graphConstant(), i);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, seriesOutOfRangeException.getStackTrace()[0].toString(), seriesOutOfRangeException);
                    }
                }
            }

            @Override
            Archiver<List<GraphType>> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet16 = ChartType.paretos();
        map.put(PropertyType.PLOT_SERIES_OPTIONS_ASSIGNED_TO_Y2, new PropertyDef<List<Boolean>>(bitSet16){
            private BooleanListArchiver archiver;
            {
                this.archiver = new BooleanListArchiver(){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<Boolean> list) {
                        if (list.size() != chartPropertyManagerImpl.get(PropertyType.PLOT_SERIES_OBJECT_COUNT, Integer.class).intValue()) {
                            throw new IllegalArgumentException();
                        }
                    }

                    @Override
                    List<Boolean> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.PLOT_SERIES_OBJECT_COUNT, Integer.class);
                        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(false);
                        }
                        return arrayList;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.PLOT_SERIES_OBJECT_COUNT};
            }

            @Override
            List<Boolean> getGraphValue(Graph graph) {
                int n = graph.getSeriesObjectCount();
                Series series = graph.getSeries();
                ArrayList<Boolean> arrayList = new ArrayList<Boolean>(n);
                for (int i = 0; i < n; ++i) {
                    try {
                        arrayList.add(series.isAssignedToY2(i));
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        arrayList.add(true);
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, seriesOutOfRangeException.getStackTrace()[0].toString(), seriesOutOfRangeException);
                    }
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<Boolean> list) {
                Series series = graph.getSeries();
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        series.setAssignedToY2(list.get(i).booleanValue(), i);
                        continue;
                    }
                    catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, seriesOutOfRangeException.getStackTrace()[0].toString(), seriesOutOfRangeException);
                    }
                }
            }

            @Override
            Archiver<List<Boolean>> archiver() {
                return this.archiver;
            }
        });
    }
}

