/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.awt.FlowLayout;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.dbtools.raptor.controls.display.chart.AbstractActionPanel;
import oracle.dbtools.raptor.controls.display.chart.AbstractLayoutPanel;
import oracle.dbtools.raptor.controls.display.chart.ChartArb;
import oracle.dbtools.raptor.controls.display.chart.TransparentColor;

class TransparentColorPanel
extends AbstractActionPanel<TransparentColor> {
    private JCheckBox transparentCheck;
    private JColorChooser colorChooser;

    TransparentColorPanel(boolean bl) {
        super(1);
        JPanel jPanel = null;
        if (bl) {
            jPanel = new JPanel(new FlowLayout());
            jPanel.setBorder(new TitledBorder(ChartArb.getString("TEXT_STYLE_LABEL")));
            this.transparentCheck = new JCheckBox(ChartArb.getString("TRANSPARENT_LABEL"));
            jPanel.add(this.transparentCheck);
        }
        this.colorChooser = new JColorChooser();
        int n = 0;
        if (jPanel != null) {
            this.addComponent(jPanel, n++, 0, 0, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.LEFT);
        }
        this.addComponent(this.colorChooser, n++, 0, 0, AbstractLayoutPanel.SizeToFit.BOTH, AbstractLayoutPanel.Align.LEFT);
    }

    @Override
    void setValue(TransparentColor transparentColor) {
        if (this.transparentCheck != null) {
            this.transparentCheck.setSelected(transparentColor.transparent());
        }
        this.colorChooser.setColor(transparentColor.color());
    }

    @Override
    TransparentColor value() {
        return new TransparentColor(this.transparentCheck != null ? this.transparentCheck.isSelected() : false, this.colorChooser.getColor());
    }

    @Override
    String title() {
        return ChartArb.getString("EDIT_COLOR");
    }
}

