/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.headless;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.core.ImportSummaryWriter;
import oracle.dbtools.importer.core.ImportXMLUtil;
import oracle.dbtools.importer.readers.IDataReadable;
import oracle.dbtools.importer.writers.ImportWriteStream;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.data.core.ImportUserConfig;
import oracle.dbtools.raptor.data.headless.ImportHeadlessResources;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.data.validators.LoadFieldValidator;
import oracle.dbtools.raptor.data.writers.ImportGenerator;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.IHeadlessCommand;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;
import oracle.dbtools.raptor.headless.LogHandler;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;

public class ImportCommand
extends IHeadlessCommand {
    private Type _type;
    private String _configXML;
    private String _logFile;
    private String _tgtFile;
    private String _connDisplayName;
    private String _connName;
    private String _qualifiedTableName;
    private String _owner;
    private String _tableName;
    private String _dataFile;
    private BasicDBObject _dbo;
    private boolean _isHelp;
    private boolean _isShow;
    private boolean _isValidate;
    protected ArrayList<ExtractObject> _extractObjects = new ArrayList();
    protected ImportUserConfig _config;
    private ImportProperties _iProps;
    private HeadlessCore _headless;
    private ImportXMLUtil _util;
    private PrintWriter _out;
    private static String _term = "\n";
    Logger LOGGER = Logger.getLogger(this.getClass().getName());

    public ImportCommand(Type type, HeadlessCore headlessCore) {
        this._type = type;
        this._headless = headlessCore;
    }

    @Override
    public void getConfig() throws InvalidCommandArgumentException {
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        try {
            this._util = new ImportXMLUtil();
            this._util.setImport(Boolean.valueOf(true));
            String string = "UTF-8";
            FileInputStream fileInputStream = new FileInputStream(new File(this._configXML));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
            this._util.parseXML(inputStreamReader, true);
            inputStreamReader.close();
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            exitCode = ExitCode.EXIT_SEVERE;
            String string = ImportHeadlessResources.format("IMPORT_VALIDATION_COMPLETED", exitCode.toStringTranslated()) + _term;
            this.LOGGER.log(Level.SEVERE, string + exitCode.getMessage());
            throw new InvalidCommandArgumentException(string + string);
        }
    }

    @Override
    public void doCommand() throws TaskException {
        ImportWriteStream importWriteStream;
        ImportWriteStream importWriteStream2;
        LoadField loadField;
        URL uRL;
        URL uRL2;
        BasicDBObject basicDBObject = (BasicDBObject)this._util.getPropertyValueObject(ImportKeys.DBOBJECT);
        boolean bl = false;
        if (this._connName != null && this._connName.length() > 0) {
            bl = true;
        } else {
            this._connName = this._util.getPropertyValue(ImportKeys.CONNECTION_NAME);
        }
        if (this._qualifiedTableName != null && this._qualifiedTableName.length() != 0) {
            bl = true;
            if (this._owner == null || this._owner.length() == 0) {
                this._owner = basicDBObject.getSchemaName();
            } else if (this._tableName == null || this._tableName.length() == 0) {
                this._tableName = basicDBObject.getObjectName();
            }
        } else if (bl) {
            this._owner = basicDBObject.getSchemaName();
            this._tableName = basicDBObject.getObjectName();
        }
        if (bl) {
            uRL2 = DBURLFormatHelper.getURL("sqldev.nav", this._connName, null, this._owner, "TABLE");
            uRL = DBURLFormatHelper.getURL(uRL2, this._tableName);
            basicDBObject = new BasicDBObject(uRL);
        }
        String string = this._dataFile = this._dataFile != null && this._dataFile.length() != 0 ? this._dataFile : this._util.getPropertyValue(ImportKeys.FILE_PATH);
        if (this._isShow) {
            this._util.reconcileConfigForShow(this._configXML);
            ImportSummaryWriter.showConfig((PrintWriter)this.getOutputWriter(), (ImportProperties)this._util.getProperties());
            return;
        }
        uRL2 = this._util.reconcileConfig(this._configXML, ((Boolean)this._util.getPropertyValueObject(ImportKeys.IS_EXISTING_TABLE)).booleanValue(), this._connName, basicDBObject, this._dataFile);
        this._iProps = this._util.getProperties();
        uRL = this._util.getDataReader();
        DataPreviewGizmo dataPreviewGizmo = new DataPreviewGizmo((IDataReadable)uRL);
        dataPreviewGizmo = new DataPreviewGizmo((IDataReadable)uRL);
        dataPreviewGizmo.setDataFormat((ImportDataFormat)this._util.getPropertyValueObject(ImportKeys.IMPORT_DATA_FORMAT));
        dataPreviewGizmo.initTable();
        uRL.showPreviewMessages(false);
        dataPreviewGizmo.populateDataTable();
        uRL.showPreviewMessages(true);
        this._iProps.put(ImportKeys.GIZMO, (Object)dataPreviewGizmo);
        dataPreviewGizmo.setProperties(this._iProps);
        Object object = "";
        switch (1.$SwitchMap$oracle$dbtools$data$loadservice$ExitCode[uRL2.ordinal()]) {
            case 1: {
                object = ImportHeadlessResources.getString("VAL_SUCCESS");
                this.printMessage(new String[]{object});
                break;
            }
            case 2: {
                object = ImportHeadlessResources.getString("VAL_WARNING");
                this.printMessage(new String[]{object});
                this.printMessage(uRL2.getMessage() + _term);
                this.LOGGER.log(Level.WARNING, uRL2.getMessage() + _term);
                this.LOGGER.log(Level.WARNING, (String)object);
                break;
            }
            case 3: {
                object = ImportHeadlessResources.getString("VAL_ERROR") + _term;
                this.printMessage(new String[]{object});
                this.printMessage(uRL2.getMessage() + _term);
                this.LOGGER.log(Level.WARNING, uRL2.getMessage() + _term);
                this.LOGGER.log(Level.WARNING, (String)object);
                return;
            }
            default: {
                object = ImportHeadlessResources.getString("VAL_SEVERE") + _term;
                this.printMessage(new String[]{object});
                this.printMessage(uRL2.getMessage() + _term);
                this.LOGGER.log(Level.WARNING, uRL2.getMessage() + _term);
                this.LOGGER.log(Level.WARNING, (String)object);
                return;
            }
        }
        LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        StringBuffer stringBuffer = new StringBuffer();
        LoadFieldValidator[] loadFieldValidatorArray = new LoadFieldValidator[loadFile.getFieldCount()];
        for (int i = 0; i < loadFile.getFieldCount(); ++i) {
            loadField = loadFile.getField(i);
            if (!this.isSelected(loadField)) continue;
            loadFieldValidatorArray[i] = new LoadFieldValidator(this._iProps, loadField);
            loadFieldValidatorArray[i].runAllTests();
            importWriteStream2 = loadFieldValidatorArray[i].getHighestExitCode();
            if (importWriteStream2 == ExitCode.EXIT_SUCCESS) continue;
            importWriteStream = ImportHeadlessResources.getString("IMPORT_SEV_WARN");
            if (importWriteStream2.getSeverity() == ExitCode.EXIT_ERROR.getSeverity()) {
                importWriteStream = ImportHeadlessResources.getString("IMPORT_SEV_ERROR");
            } else if (importWriteStream2.getSeverity() == ExitCode.EXIT_SEVERE.getSeverity()) {
                importWriteStream = ImportHeadlessResources.getString("IMPORT_SEV_SEVERE");
            }
            stringBuffer.append(ImportHeadlessResources.getString("FIELD_VAL") + " " + loadFieldValidatorArray[i].getLoadField().getName() + " " + (String)importWriteStream + _term + " " + ImportHeadlessResources.getString("STATUS") + " ");
            stringBuffer.append(loadFieldValidatorArray[i].getStatus());
            if (importWriteStream2.getSeverity() <= uRL2.getSeverity()) continue;
            String string2 = uRL2.getMessage();
            uRL2 = importWriteStream2;
            uRL2.setMessage(string2);
        }
        this._iProps.put(ImportKeys.VALIDATORS, (Object)loadFieldValidatorArray);
        String string3 = "";
        object = "";
        switch (1.$SwitchMap$oracle$dbtools$data$loadservice$ExitCode[uRL2.ordinal()]) {
            case 1: {
                object = ImportHeadlessResources.getString("FLD_VAL_SUCCESS");
                this.printMessage(new String[]{object});
                break;
            }
            case 2: {
                object = ImportHeadlessResources.getString("FLD_VAL_WARNING");
                this.printMessage("" + stringBuffer);
                this.printMessage(new String[]{object});
                this.LOGGER.log(Level.WARNING, "" + stringBuffer);
                this.LOGGER.log(Level.WARNING, (String)object);
                break;
            }
            case 3: {
                object = ImportHeadlessResources.getString("FLD_VAL_ERROR") + _term;
                this.printMessage("" + stringBuffer);
                this.printMessage(new String[]{object});
                this.LOGGER.log(Level.WARNING, "" + stringBuffer);
                this.LOGGER.log(Level.WARNING, (String)object);
                this.printMessage(ImportHeadlessResources.format("EXIT", ImportResources.getString((String)"EXIT_ERROR_LABEL")));
                return;
            }
            default: {
                object = ImportHeadlessResources.getString("FLD_VAL_SEVERE") + _term;
                this.printMessage("" + stringBuffer);
                this.printMessage(new String[]{object});
                this.printMessage(ImportHeadlessResources.format("EXIT", ImportResources.getString((String)"EXIT_SEVERE_LABEL")));
                this.LOGGER.log(Level.WARNING, "" + stringBuffer);
                this.LOGGER.log(Level.WARNING, (String)object);
                return;
            }
        }
        if (this._isValidate) {
            return;
        }
        try {
            this._iProps.put(ImportKeys.CONNECTION_NAME, (Object)this._connName);
            this._iProps.put(ImportKeys.DBOBJECT, (Object)basicDBObject);
            loadField = (GenericTable)this._iProps.get(ImportKeys.TABLE);
            for (Column column : importWriteStream2 = (ImportWriteStream)this._iProps.get(ImportKeys.SELECTED_COLUMNS)) {
                Column column2 = loadField.getTable().getColumnByName(column.getName());
                column2.setSourceColumnName(column.getSourceColumnName());
                column2.setSourceColID(column.getSourceColID());
            }
            this._iProps.put(ImportKeys.TABLE, (Object)loadField);
            importWriteStream = this.createPrintStream();
            this._iProps.put(ImportKeys.IMPORT_WRITE_STREAM, (Object)importWriteStream);
            this._iProps.put(ImportKeys.IS_BATCH, (Object)true);
            this._iProps.put(ImportKeys.ERROR_LIMIT, (Object)5);
            this._iProps.put(ImportKeys.REPLACE_GEN_FILES, (Object)true);
            this._iProps.put(ImportKeys.SEND_TO_WORKSHEET, (Object)true);
            ImportDataFormat importDataFormat = (ImportDataFormat)this._util.getPropertyValueObject(ImportKeys.IMPORT_DATA_FORMAT);
            this._iProps.put(ImportKeys.PAGEID, (Object)importDataFormat.getPageId());
            this._iProps.put(ImportKeys.WORKSHEET_NAME, (Object)importDataFormat.getWorksneet());
            ImportGenerator importGenerator = new ImportGenerator(this._iProps);
            uRL2 = importGenerator.gen();
            switch (1.$SwitchMap$oracle$dbtools$data$loadservice$ExitCode[uRL2.ordinal()]) {
                case 1: {
                    string3 = ImportResources.getString((String)"EXIT_SUCCESS_LABEL");
                    this.LOGGER.log(Level.INFO, string3);
                    break;
                }
                case 2: {
                    string3 = ImportResources.getString((String)"EXIT_WARNING_LABEL");
                    this.LOGGER.log(Level.WARNING, string3 + ": " + uRL2.getMessage());
                    break;
                }
                case 3: {
                    string3 = ImportResources.getString((String)"EXIT_ERROR_LABEL");
                    this.LOGGER.log(Level.WARNING, string3 + ": " + uRL2.getMessage());
                    break;
                }
                default: {
                    string3 = ImportResources.getString((String)"EXIT_SEVERE_LABEL");
                    this.LOGGER.log(Level.SEVERE, string3 + ": " + uRL2.getMessage());
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            uRL2 = ExitCode.EXIT_SEVERE;
            uRL2.setMessage(exception.getMessage());
            string3 = ImportResources.getString((String)"EXIT_SEVERE_LABEL");
        }
        this.printMessage(uRL2.getMessage());
        if (uRL2.getShortMessage().length() > 0) {
            this.printMessage(uRL2.getShortMessage());
        }
        this.printMessage(ImportHeadlessResources.format("EXIT", string3));
    }

    private boolean isSelected(LoadField loadField) {
        Column[] columnArray = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        Column column = loadField.getColumn();
        for (Column column2 : columnArray) {
            if (column.getName() != column2.getName()) continue;
            return true;
        }
        return false;
    }

    private ImportWriteStream createPrintStream() throws IOException, UnsupportedEncodingException {
        String string = Ide.getEnvironOptions().getEncoding();
        LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        File file = new File(loadFile.getName());
        String string2 = file.getName();
        string2 = string2.replace(".", "-");
        ImportWriteStream importWriteStream = new ImportWriteStream(string2, string, System.getProperty("user.dir"), null);
        return importWriteStream;
    }

    private void printMessage(String ... stringArray) {
        ImportCommand.printLines(this.getOutputWriter(), stringArray);
    }

    private PrintWriter getOutputWriter() {
        if (this._out == null) {
            this._out = new PrintWriter(new PrintWriter(System.out));
        }
        return this._out;
    }

    protected static void printLines(PrintWriter printWriter, String ... stringArray) {
        for (String string : stringArray) {
            int n;
            if (string == null) break;
            int n2 = 0;
            while ((n = string.indexOf(_term, n2)) >= 0) {
                printWriter.write(string, n2, n - n2);
                n2 = n + 1;
                printWriter.println();
            }
            printWriter.write(string, n2, string.length() - n2);
            printWriter.println();
        }
        printWriter.flush();
    }

    @Override
    public String getHelpKey() {
        return "HELP_STRING_UTILITY_IMPORT";
    }

    @Override
    public boolean processToolItem(String string, List<String> list) throws InvalidCommandArgumentException {
        if ("CONN".equalsIgnoreCase(string) || "C".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(ImportHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this._connDisplayName = list.get(0);
            return true;
        }
        if ("TABLE".equalsIgnoreCase(string) || "T".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(ImportHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this._qualifiedTableName = list.get(0);
            return true;
        }
        if ("DATA".equalsIgnoreCase(string) || "D".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(ImportHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this._dataFile = list.get(0);
            return true;
        }
        if ("SHOW".equalsIgnoreCase(string) || "S".equalsIgnoreCase(string)) {
            if (list.size() != 0) {
                throw new InvalidCommandArgumentException(ImportHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this._isShow = true;
            return true;
        }
        if ("VALIDATE".equalsIgnoreCase(string) || "V".equalsIgnoreCase(string)) {
            if (list.size() != 0) {
                throw new InvalidCommandArgumentException(ImportHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this._isValidate = true;
            return true;
        }
        return false;
    }

    @Override
    public void handleLog() throws InvalidCommandArgumentException {
        if (this._logFile != null && this._logFile.length() > 0) {
            LogHandler logHandler = LogHandler.getInstance();
            logHandler.setLogFile(this._logFile, this._headless);
        }
    }

    public String getHelp() {
        return ImportHeadlessResources.getString(this.getHelpKey());
    }

    public boolean isHelp() {
        return this._isHelp;
    }

    public void isHelp(boolean bl) {
        this._isHelp = bl;
    }

    @Override
    public void validateParse() throws InvalidCommandArgumentException {
        if (this._configXML == null || this._configXML.length() == 0) {
            throw new InvalidCommandArgumentException(ImportHeadlessResources.getString("CONFIG_MISSING"));
        }
        Object object = new File(this._configXML);
        if (((File)object).isDirectory() || !((File)object).isFile()) {
            throw new InvalidCommandArgumentException(ImportHeadlessResources.format("CONFIG_INVALID", this._configXML));
        }
        if (this._logFile != null && this._logFile.length() > 0 && !this._logFile.equalsIgnoreCase("stderr")) {
            object = new File(this._logFile);
            if (((File)object).isFile()) {
                ((File)object).delete();
            }
            TargetFormat targetFormat = new TargetFormat(2, 1, false);
            targetFormat.setSaveAsType(0);
            targetFormat.setSaveAs(this._logFile);
            int n = targetFormat.validateSaveAs();
            if (n != 0) {
                throw new InvalidCommandArgumentException(targetFormat.getValidationMessage());
            }
        }
        if (this._connDisplayName != null && this._connDisplayName.length() > 0) {
            this._connName = this.getConnectionName(this._connDisplayName);
            if (this._connName == null) {
                throw new InvalidCommandArgumentException(ImportHeadlessResources.format("CONN_INVALID", this._connDisplayName));
            }
        }
        if (this._qualifiedTableName != null && this._qualifiedTableName.length() != 0 && ((String[])(object = this._qualifiedTableName.split("\\."))).length > 0) {
            if (((String[])object).length == 2) {
                this._owner = !((String)object[0]).startsWith("\"") && !((String)object[0]).endsWith("\"") ? ((String)object[0]).toUpperCase() : object[0];
                this._tableName = !((String)object[1]).startsWith("\"") && !((String)object[1]).endsWith("\"") ? ((String)object[1]).toUpperCase() : object[1];
            } else if (((Object)object).length == 1) {
                this._tableName = !((String)object[0]).startsWith("\"") && !((String)object[0]).endsWith("\"") ? ((String)object[0]).toUpperCase() : object[0];
            }
            if (((Object)object).length > 2) {
                throw new InvalidCommandArgumentException(ImportHeadlessResources.format("TABLE_INVALID", this._qualifiedTableName));
            }
        }
        if (this._dataFile != null && this._dataFile.length() > 0 && (((File)(object = new File(this._dataFile))).isDirectory() || !((File)object).isFile())) {
            throw new InvalidCommandArgumentException(ImportHeadlessResources.format("DATA_INVALID", this._dataFile));
        }
    }

    private String getConnectionName(String string) {
        String string2 = null;
        for (String string3 : Connections.getInstance().getConnNames()) {
            String string4 = Connections.getDisplayName(string3);
            if (!string4.equals(string)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    @Override
    public void validate() throws InvalidCommandArgumentException {
    }

    @Override
    public String getType() {
        return this._type.toString();
    }

    public void setConfigXML(String string) {
        this._configXML = string;
    }

    public String getConfigXML() {
        return this._configXML;
    }

    protected void validateConfig(URL uRL, String string) throws InvalidCommandArgumentException {
        String string2 = this._config.getString("ImportConfig");
        if (string2 == null) {
            string2 = ImportHeadlessResources.getString("XML_FILE_NO_KEY");
        }
        if (!string2.equals(string)) {
            throw new InvalidCommandArgumentException(ImportHeadlessResources.format("XML_FILE_ERROR_MESSAGE", uRL.getFile(), "\"" + string + "\"", string2));
        }
    }

    public void setLogFile(String string) {
        this._logFile = string;
    }

    public String getLogFile() {
        return this._logFile;
    }

    public void setTgtFile(String string) {
        this._tgtFile = string;
    }

    public String getTgtFile() {
        return this._tgtFile;
    }

    public static enum Type {
        IMPORT;

    }
}

