/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.importer.core.DataType;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.raptor.data.core.ColumnChangeEvent;
import oracle.dbtools.raptor.data.ui.ColumnListRenderer;
import oracle.dbtools.raptor.data.ui.ColumnPropertyPanel;

public class KnownColumnPropertiesPanel
extends ColumnPropertyPanel {
    private static final long serialVersionUID = -5738627397607366539L;
    private JComboBox columnCombo;
    private ColumnListRenderer renderer = new ColumnListRenderer();
    private GridBagConstraints nameFieldConstraints = new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0);
    private ItemListener columnListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Column column;
            if (itemEvent.getStateChange() == 2 && ((column = (Column)((JComboBox)itemEvent.getSource()).getSelectedItem()).getType().equals(DataType.DATE.toString()) || column.getType().equals(DataType.TIMESTAMP.toString()) || column.getType().equals(DataType.TIMESTAMPTZ.toString()) || column.getType().equals(DataType.TIMESTAMPLTZ.toString()))) {
                KnownColumnPropertiesPanel.this.setDateMask((String)KnownColumnPropertiesPanel.this.dateMask.getEditor().getItem());
            }
            if (itemEvent.getStateChange() == 1) {
                String string;
                column = (Column)((JComboBox)itemEvent.getSource()).getSelectedItem();
                switch (string = column.getType()) {
                    case "DATE": {
                        KnownColumnPropertiesPanel.this.removePrecisionScale();
                        KnownColumnPropertiesPanel.this.addDateMask();
                        KnownColumnPropertiesPanel.this.setDateMaskModel(string.toString());
                        break;
                    }
                    case "INTEGER": {
                        KnownColumnPropertiesPanel.this.removePrecisionScale();
                        KnownColumnPropertiesPanel.this.removeDateMask();
                        break;
                    }
                    case "NUMBER": {
                        KnownColumnPropertiesPanel.this.removePrecisionScale();
                        KnownColumnPropertiesPanel.this.addPrecisionScale();
                        KnownColumnPropertiesPanel.this.enableScale();
                        KnownColumnPropertiesPanel.this.removeDateMask();
                        break;
                    }
                    case "CLOB": {
                        KnownColumnPropertiesPanel.this.removePrecisionScale();
                        KnownColumnPropertiesPanel.this.removeDateMask();
                        break;
                    }
                    case "TIMESTAMP": 
                    case "TIMESTAMP WITH TIME ZONE": 
                    case "TIMESTAMP WITH LOCAL TIME ZONE": {
                        KnownColumnPropertiesPanel.this.removePrecisionScale();
                        KnownColumnPropertiesPanel.this.addPrecision();
                        KnownColumnPropertiesPanel.this.addDateMask();
                        KnownColumnPropertiesPanel.this.setDateMaskModel(string);
                        break;
                    }
                    default: {
                        KnownColumnPropertiesPanel.this.removePrecisionScale();
                        KnownColumnPropertiesPanel.this.addPrecision();
                        KnownColumnPropertiesPanel.this.removeDateMask();
                    }
                }
                KnownColumnPropertiesPanel.this.refreshColumn(column);
                KnownColumnPropertiesPanel.this.column.refreshData(column);
                KnownColumnPropertiesPanel.this.firelisteners(new ColumnChangeEvent(column));
            }
        }
    };
    private JComboBox<Column> box;

    public Column getCurrentSelection() {
        return (Column)this.box.getSelectedItem();
    }

    public KnownColumnPropertiesPanel(ImportProperties importProperties) {
        super(importProperties);
        this.typeField = new JTextField();
        this.add(this.typeField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        ((JTextField)this.typeField).setEnabled(false);
        this.precisionField = new JTextField();
        this.add(this.precisionField, this.precisionTextfieldConstraints);
        ((JTextField)this.precisionField).setEnabled(false);
        this.enabled(false);
    }

    protected void refreshColumn(Column column) {
        Column column2 = this.m_table.getColumnByName(column.getName());
        String string = column2.getType() == null ? "" : column2.getType();
        ((JTextField)this.typeField).setText(string);
        this.scaleField.setText(String.valueOf(column2.getScale()));
        this.setPrecision(column2.getPrecision());
        this.nullCheck.setSelected(column2.isNullable());
        this.defaultField.setText(column2.getDefault() != null ? column2.getDefault() : "");
        this.commentArea.setText(column2.getComment() != null ? column2.getComment() : "");
        this.setDateMaskModel(string, column2.getFormat());
    }

    @Override
    void setTable(GenericTable genericTable) {
        this.m_table = genericTable.getTable();
    }

    public void setTable(GenericTable genericTable, boolean bl) {
        this.m_table = genericTable.getTable();
        if (bl) {
            this.box = new JComboBox<Column>(this.m_table.getColumns().toArray(new Column[this.m_table.getColumns().size()]));
            this.box.setRenderer(this.renderer);
            if (this.columnCombo != null) {
                this.remove(this.columnCombo);
            }
            this.box.addItemListener(this.columnListener);
            this.add(this.box, this.nameFieldConstraints);
            Column column = (Column)this.box.getSelectedItem();
            if (column.getType().equals(DataType.DATE.toString()) || column.getType().equals(DataType.TIMESTAMP.toString()) || column.getType().equals(DataType.TIMESTAMPTZ.toString()) || column.getType().equals(DataType.TIMESTAMPLTZ.toString())) {
                this.addDateMask();
            }
            this.refreshColumn(column);
            this.validate();
        }
    }

    @Override
    void switchColumn(Column column) {
        String string = column.getName();
    }

    @Override
    void setColumnName(String string) {
        this.setSelectedName(string);
    }

    @Override
    void setDataType(String string) {
        ((JTextField)this.typeField).setText(string);
    }

    @Override
    public Column getColumnDetails() {
        Column column = (Column)this.box.getSelectedItem();
        if (DataType.DATE.toString().equalsIgnoreCase(column.getType()) || DataType.TIMESTAMP.toString().equalsIgnoreCase(column.getType()) || DataType.TIMESTAMPTZ.toString().equalsIgnoreCase(column.getType()) || DataType.TIMESTAMPLTZ.toString().equalsIgnoreCase(column.getType())) {
            column.setFormat((String)this.dateMask.getEditor().getItem());
        }
        return column;
    }

    @Override
    void setColumn(Column column) {
        this.column = column;
        String string = column.getFormat();
        this.setColumnName(column.getName());
        this.setPrecision(column.getPrecision());
        this.setScale(column.getScale());
        this.setNullable(column.isNullable());
        this.defaultField.setText(column.getDefault());
        this.setComment(column.getComment());
        if (DataType.DATE.toString().equalsIgnoreCase(this.column.getType()) || DataType.TIMESTAMP.toString().equalsIgnoreCase(this.column.getType()) || DataType.TIMESTAMPTZ.toString().equalsIgnoreCase(this.column.getType()) || DataType.TIMESTAMPLTZ.toString().equalsIgnoreCase(this.column.getType())) {
            this.setDateMaskModel(column.getType(), string);
        }
        this.setDataType(column.getType());
    }

    private void setSelectedName(String string) {
        ComboBoxModel<Column> comboBoxModel = this.box.getModel();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            if (!((Column)comboBoxModel.getElementAt(i)).getName().equals(string)) continue;
            this.box.setSelectedIndex(i);
        }
    }
}

