/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.validators;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.importer.core.DataType;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.Ide;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.util.ModelUtil;

public class LoadFieldValidator {
    private LoadField _loadField;
    private ImportProperties _iProps;
    private String _term = Ide.getEnvironOptions().getLineBreakSequence();
    HashMap<Test, Result> _tests = new HashMap();

    public LoadFieldValidator(ImportProperties importProperties, LoadField loadField) {
        this._iProps = importProperties;
        this._loadField = loadField;
    }

    public void runAllTests() {
        if (this._iProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE).booleanValue()) {
            this.run(Test.MAPPED);
            this.run(Test.HAS_FORMAT);
            this.run(Test.COMPATIBLE_DATA);
        } else {
            this.run(Test.MAPPED);
            this.run(Test.COLUMN_NAME);
            this.run(Test.HAS_FORMAT);
            this.run(Test.COMPATIBLE_DATA);
        }
    }

    public void runDdlTests() {
        this.run(Test.MAPPED);
        this.run(Test.COLUMN_NAME);
        this.run(Test.HAS_FORMAT);
    }

    public void runDataTests() {
        this.run(Test.COMPATIBLE_DATA);
    }

    public LoadField getLoadField() {
        return this._loadField;
    }

    public ExitCode getHighestExitCode() {
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        for (Result result : this._tests.values()) {
            ExitCode exitCode2 = result.getExitCode();
            if (exitCode2 == null || exitCode.getSeverity() >= exitCode2.getSeverity()) continue;
            exitCode = exitCode2;
        }
        return exitCode;
    }

    public String getStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Result result : this._tests.values()) {
            ExitCode exitCode = result.getExitCode();
            if (exitCode == null || exitCode.getSeverity() <= 0) continue;
            stringBuffer.append(result.getMessage() + this._term);
        }
        return stringBuffer.toString();
    }

    public ExitCode run(Test test) {
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        switch (test) {
            case MAPPED: {
                exitCode = this.validateMapping();
                break;
            }
            case COLUMN_NAME: {
                exitCode = this.validateColumnName();
                break;
            }
            case HAS_DATATYPE: {
                exitCode = ExitCode.EXIT_SUCCESS;
                break;
            }
            case HAS_SIZE: {
                exitCode = this.columnHasSize();
                break;
            }
            case HAS_FORMAT: {
                exitCode = this.dateHasFormat();
                break;
            }
            case SUPPORTED_DATATYPE: {
                exitCode = this.dataTypeSupported();
                break;
            }
            case COMPATIBLE_DATA: {
                exitCode = this.compatibleData();
            }
        }
        this._tests.put(test, new Result(exitCode));
        return exitCode;
    }

    public ExitCode getExitCode(Test test) {
        return this._tests.get((Object)test) != null ? this._tests.get((Object)test).getExitCode() : null;
    }

    public String getStatus(Test test) {
        return this._tests.get((Object)test) != null ? this._tests.get((Object)test).getMessage() : "";
    }

    private Column getTableColumn() {
        GenericTable genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
        return genericTable.getTable().getColumnByName(this._loadField.getColumn().getName());
    }

    private ExitCode validateMapping() {
        ExitCode exitCode = (ExitCode)this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        Column column = this._loadField.getColumn();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (Column column2 : exitCode) {
            if (column.getSourceColID() != column2.getSourceColID() && column.getName().equals(column2.getName())) {
                if (!bl) {
                    bl = true;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(column2.getSourceColumnName());
                continue;
            }
            if (!column.getName().equals(column2.getName())) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(column2.getSourceColumnName());
        }
        if (bl) {
            ExitCode exitCode2 = ExitCode.EXIT_SEVERE;
            exitCode2.setMessage(DataImportArb.format("DUPLICATE_COLUMNS_MAPPED_ERROR", stringBuffer.toString(), column.getName()));
            return exitCode2;
        }
        return ExitCode.EXIT_SUCCESS;
    }

    private ExitCode validateColumnName() {
        DBObject dBObject;
        BasicDBObject basicDBObject = null;
        if (this._iProps.get(ImportKeys.DBOBJECT) != null) {
            basicDBObject = (BasicDBObject)this._iProps.get(ImportKeys.DBOBJECT);
        }
        if (basicDBObject != null && (dBObject = new DBObject(basicDBObject.getURL())) != null) {
            Database database = dBObject.getDatabase();
            try {
                database.validateName("COLUMN", this._loadField.getColumn().getName());
            }
            catch (InvalidNameException invalidNameException) {
                ExitCode exitCode = ExitCode.EXIT_SEVERE;
                exitCode.setMessage(DataImportArb.getString("COLUMN_NAME_INVALID"));
                return exitCode;
            }
        }
        return ExitCode.EXIT_SUCCESS;
    }

    private ExitCode columnHasSize() {
        Column column = this._loadField.getColumn();
        String string = column.getType();
        if ((DataType.VARCHAR2.toString().equals(string) || DataType.CHAR.toString().equals(string) || DataType.NCHAR.toString().equals(string) || DataType.NVARCHAR2.toString().equals(string)) && column.getPrecision() <= 0) {
            ExitCode exitCode = ExitCode.EXIT_ERROR;
            exitCode.setMessage(DataImportArb.get("COLUMN_SIZE_INVALID"));
            return exitCode;
        }
        return ExitCode.EXIT_SUCCESS;
    }

    private ExitCode dateHasFormat() {
        Locale locale = (Locale)this._iProps.get(ImportKeys.LOCALE);
        Column column = this._loadField.getColumn();
        if (ModelUtil.hasLength((String)column.getType()) && DataType.DATE.toString().equals(column.getType())) {
            String string = column.getFormat();
            if (string != null) {
                string = string.trim();
            }
            if (ModelUtil.hasLength((String)string)) {
                try {
                    OraDATEFormat oraDATEFormat = new OraDATEFormat(string, OraLocaleInfo.getInstance((Locale)locale));
                }
                catch (ParseException parseException) {
                    ExitCode exitCode = ExitCode.EXIT_ERROR;
                    exitCode.setMessage(DataImportArb.format("FORMAT_INVALID", string));
                    return exitCode;
                }
            } else {
                ExitCode exitCode = ExitCode.EXIT_WARNING;
                exitCode.setMessage(DataImportArb.getString("FORMAT_MISSING"));
                return exitCode;
            }
            return ExitCode.EXIT_SUCCESS;
        }
        if (ModelUtil.hasLength((String)column.getType()) && DataType.TIMESTAMP.toString().equals(column.getType())) {
            String string = column.getFormat();
            if (ModelUtil.hasLength((String)string)) {
                try {
                    OraTIMESTAMPFormat oraTIMESTAMPFormat = new OraTIMESTAMPFormat(string, OraLocaleInfo.getInstance((Locale)locale));
                }
                catch (ParseException parseException) {
                    ExitCode exitCode = ExitCode.EXIT_ERROR;
                    exitCode.setMessage(DataImportArb.format("FORMAT_INVALID", string));
                    return exitCode;
                }
            } else {
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setMessage(DataImportArb.getString("FORMAT_MISSING"));
                return exitCode;
            }
            return ExitCode.EXIT_SUCCESS;
        }
        if (ModelUtil.hasLength((String)column.getType()) && (DataType.TIMESTAMPTZ.toString().equals(column.getType()) || DataType.TIMESTAMPLTZ.toString().equals(column.getType()))) {
            String string = column.getFormat();
            if (ModelUtil.hasLength((String)string)) {
                try {
                    OraTIMESTAMPTZFormat oraTIMESTAMPTZFormat = new OraTIMESTAMPTZFormat(string, OraLocaleInfo.getInstance((Locale)locale));
                }
                catch (ParseException parseException) {
                    ExitCode exitCode = ExitCode.EXIT_ERROR;
                    exitCode.setMessage(DataImportArb.format("FORMAT_INVALID", string));
                    return exitCode;
                }
            } else {
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setMessage(DataImportArb.getString("FORMAT_MISSING"));
                return exitCode;
            }
        }
        return ExitCode.EXIT_SUCCESS;
    }

    private ExitCode dataTypeSupported() {
        List list = DataType.getValuesAsList();
        Column column = this._loadField.getColumn();
        if (ModelUtil.hasLength((String)column.getType()) && !list.contains(column.getType())) {
            ExitCode exitCode = ExitCode.EXIT_WARNING;
            exitCode.setMessage(DataImportArb.format("DATA_TYPE_NOT_SUPPORTED", column.getType()));
            return exitCode;
        }
        return ExitCode.EXIT_SUCCESS;
    }

    private ExitCode compatibleData() {
        DataPreviewGizmo dataPreviewGizmo = (DataPreviewGizmo)this._iProps.get(ImportKeys.GIZMO);
        Column column = this._loadField.getColumn();
        boolean bl = dataPreviewGizmo.validateData(column, (Locale)this._iProps.get(ImportKeys.LOCALE));
        ExitCode exitCode = ExitCode.EXIT_WARNING;
        if (bl) {
            if (column != null && this._iProps.getValueBoolean(ImportKeys.IS_CART).booleanValue() && column.getType() == "CLOB") {
                exitCode.setMessage(DataImportArb.getString("LOB_WARNING"));
                return exitCode;
            }
            return ExitCode.EXIT_SUCCESS;
        }
        exitCode.setMessage(DataImportArb.getString("DATA_NOT_COMPAT"));
        return exitCode;
    }

    public static boolean containsWhiteSpace(String string) {
        for (char c : string.toCharArray()) {
            if (!Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }

    public static enum Test {
        MAPPED,
        COLUMN_NAME,
        HAS_DATATYPE,
        HAS_SIZE,
        HAS_FORMAT,
        SUPPORTED_DATATYPE,
        COMPATIBLE_DATA;

    }

    private class Result {
        private ExitCode _exitCode;
        private String _message;

        Result(ExitCode exitCode) {
            this._exitCode = exitCode;
            this._message = exitCode.getMessage();
        }

        ExitCode getExitCode() {
            return this._exitCode;
        }

        String getMessage() {
            return this._message;
        }
    }
}

