/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.sql.PreparedStatement;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.writers.ImportGenModel;
import oracle.dbtools.raptor.data.writers.ImportGen;
import oracle.dbtools.util.Logger;

public abstract class ImportGenExec
extends ImportGen {
    private ImportProperties _iProps;
    private ImportGenModel _iGenModel;
    private boolean _isValid = false;
    private boolean _isIgnoreAllErrors = false;

    public abstract boolean doImport();

    public ExitCode getExitCode() {
        return this._iGenModel.getExitCode();
    }

    public void setExitCode(ExitCode exitCode) {
        this._iGenModel.setExitCode(exitCode);
    }

    @Override
    public boolean start(ImportProperties importProperties, ImportGenModel importGenModel) {
        return this.start(importProperties, importGenModel, false);
    }

    @Override
    public boolean start(ImportProperties importProperties, ImportGenModel importGenModel, boolean bl) {
        if (importProperties == null || importGenModel == null) {
            return false;
        }
        this._iProps = importProperties;
        this._iGenModel = importGenModel;
        super.start(importProperties, importGenModel, bl);
        if (!this._iGenModel.isExitCodeSuccess()) {
            return false;
        }
        return this.validate();
    }

    public boolean validate() {
        this._iGenModel.setExitCode(ExitCode.EXIT_SUCCESS);
        this._isValid = true;
        return this._isValid;
    }

    @Override
    public boolean process() {
        this._iGenModel.isCancel(this.doImport());
        String string = this._iGenModel.getTaskFullName() + ". ";
        if (this._iGenModel.isExitCodeSuccess() && !this._iGenModel.isCancel()) {
            string = string + ImportResources.getString((String)"TASK_SUCCEEDED_AND_COMMITTED");
        } else {
            string = string + ImportResources.getString((String)"TASK_CANCELLED_ROLLBACK");
            string = string + " " + this._iGenModel.getExitCode().getShortMessage() + " " + this._iGenModel.getExitCode().getMessage();
        }
        if (this._iGenModel.isBatch()) {
            this.outBad(string);
        }
        return this._iGenModel.isExitCodeSuccess();
    }

    public final void rollbackTask() {
        try {
            if (!this._iGenModel.getConn().isClosed() && this._iGenModel.isConnLocked()) {
                this._iGenModel.getConn().rollback();
                if (this._iGenModel.isTableCreated() && !this._isIgnoreAllErrors) {
                    String string = this._iGenModel.getDropTableStatementForPrepare();
                    PreparedStatement preparedStatement = this._iGenModel.getConn().prepareStatement(string);
                    preparedStatement.execute();
                    this._iGenModel.getConn().commit();
                }
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    public void commitTask() {
        try {
            if (this._iGenModel.isConnLocked()) {
                this._iGenModel.getConn().commit();
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    private void outBad(String string) {
        try {
            this._iGenModel.getStream().printlnBad(string);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }
}

