/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.ui.cell;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerModel;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.datatypes.ui.cell.CellRendererHelper;

public class SpinnerCellRenderer
extends JSpinner
implements TableCellRenderer {
    private Color unselectedForeground;
    private Color unselectedBackground;

    public SpinnerCellRenderer() {
        this.init();
    }

    public SpinnerCellRenderer(SpinnerModel spinnerModel) {
        super(spinnerModel);
        this.init();
    }

    private void init() {
        this.setOpaque(true);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return null;
        }
        JComponent jComponent = this;
        this.setValue(object);
        JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.getEditor();
        JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
        if (CellRendererHelper.isReadOnly(jTable, n)) {
            JFormattedTextField.AbstractFormatter abstractFormatter = jFormattedTextField.getFormatter();
            String string = jFormattedTextField.getText();
            if (abstractFormatter != null) {
                try {
                    string = abstractFormatter.valueToString(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            jComponent = CellRendererHelper.getTextField(string, 4);
        }
        CellRendererHelper.setupLook(jComponent, jTable, bl, bl2, jFormattedTextField, this.unselectedForeground, this.unselectedBackground);
        return jComponent;
    }
}

