/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.ui.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StructureType;
import oracle.dbtools.raptor.datatypes.ui.control.AbstractTreeTableModel;
import oracle.dbtools.raptor.datatypes.ui.control.TreeTableModel;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;

public class CompositeTypeTableModel
extends AbstractTreeTableModel {
    protected static final DataValueNode[] nullNodes = null;
    public static final int NAME_ID = 0;
    public static final int DATAVALUE_ID = 1;
    public static final int DATATYPE_ID = 2;
    protected static String[] cNames = new String[]{"Name", "Value", "Type"};
    protected static Class[] cTypes = new Class[]{TreeTableModel.class, String.class, DataType.class};
    protected boolean isValid = true;
    protected DataValueNode reloadNode;
    int reloadCount;

    public CompositeTypeTableModel(DataType dataType) {
        super(null);
        this.root = new DataValueNode(dataType.getDataValue(null));
    }

    @Override
    public int getChildCount(Object object) {
        ArrayList<DataValueNode> arrayList = this.getChildren(object);
        return arrayList.size();
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.getChildren(object).get(n);
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((DataValueNode)object).isLeaf();
    }

    @Override
    public int getColumnCount() {
        return cNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return cNames[n];
    }

    @Override
    public Class getColumnClass(int n) {
        return cTypes[n];
    }

    @Override
    public Object getValueAt(Object object, int n) {
        DataValueNode dataValueNode = (DataValueNode)object;
        switch (n) {
            case 0: {
                return dataValueNode.getName();
            }
            case 1: {
                return dataValueNode.getDataValue();
            }
            case 2: {
                return dataValueNode.getDataType();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        if (this.isEditable()) {
            if (n == 1) {
                return true;
            }
            return super.isCellEditable(object, n);
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
        if (n == 1) {
            DataValueNode dataValueNode = (DataValueNode)object2;
            DataValue dataValue = dataValueNode.getDataType().getDataValue(object);
            if (dataValueNode.isLeaf()) {
                dataValueNode.setNodeValue(dataValue, true);
            } else {
                dataValueNode.setNodeValue(dataValue, false);
                this.reloadChildren(dataValueNode);
            }
        } else {
            super.setValueAt(object, object2, n);
        }
    }

    public StructureType getStructureType(Object object) {
        DataValueNode dataValueNode = (DataValueNode)object;
        return dataValueNode.getDataType().getStructureType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadChildren(Object object) {
        DataValueNode dataValueNode = (DataValueNode)object;
        CompositeTypeTableModel compositeTypeTableModel = this;
        synchronized (compositeTypeTableModel) {
            ++this.reloadCount;
        }
        new Thread(new DataValueNodeLoader(dataValueNode)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLoading() {
        this.isValid = false;
        CompositeTypeTableModel compositeTypeTableModel = this;
        synchronized (compositeTypeTableModel) {
            while (this.reloadCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.isValid = true;
    }

    public boolean isReloading() {
        return this.reloadCount > 0;
    }

    public TreePath getPathLoading() {
        DataValueNode dataValueNode = this.reloadNode;
        if (dataValueNode != null) {
            return new TreePath(dataValueNode.getPath());
        }
        return null;
    }

    public Object getNodeLoading() {
        return this.reloadNode;
    }

    protected DataValue getDataValue(Object object) {
        DataValueNode dataValueNode = (DataValueNode)object;
        return dataValueNode.getDataValue();
    }

    protected ArrayList<DataValueNode> getChildren(Object object) {
        DataValueNode dataValueNode = (DataValueNode)object;
        return dataValueNode.getChildren();
    }

    public void setValue(Object object) {
        this.root = object instanceof DataValue ? new DataValueNode((DataValue)object) : ((DataValueNode)this.root).getDataType().getDataValue(object);
    }

    public Object getValue() {
        return ((DataValueNode)this.root).getDataValue();
    }

    public boolean isEditable() {
        return true;
    }

    public void addElement(Object object) {
        DataValueNode dataValueNode = (DataValueNode)object;
        dataValueNode.addChild(true);
    }

    public void removeElements(Object object, ArrayList arrayList) {
        DataValueNode dataValueNode = (DataValueNode)object;
        dataValueNode.removeChildren(arrayList, true);
    }

    public void insertElements(Object object, ArrayList arrayList) {
        DataValueNode dataValueNode = (DataValueNode)object;
        dataValueNode.insertChildren(arrayList, true);
    }

    public void dupElements(Object object, ArrayList arrayList) {
        DataValueNode dataValueNode = (DataValueNode)object;
        dataValueNode.dupChildren(arrayList, true);
    }

    class DataValueNodeLoader
    implements Runnable {
        DataValueNode node;

        DataValueNodeLoader(DataValueNode dataValueNode) {
            this.node = dataValueNode;
            dataValueNode.setChildren(dataValueNode.createChildren(), true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<DataValueNode> arrayList = this.node.getChildren();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                if (!arrayList.get(i).isLeaf()) {
                    CompositeTypeTableModel.this.reloadNode = arrayList.get(i);
                    this.loadChildren(arrayList.get(i));
                    CompositeTypeTableModel.this.reloadNode = null;
                }
                if (CompositeTypeTableModel.this.isValid) continue;
                i = 0;
            }
            if (CompositeTypeTableModel.this.isValid) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DataValueNodeLoader.this.node.setChildren(DataValueNodeLoader.this.node.getChildren(), true);
                        CompositeTypeTableModel compositeTypeTableModel = CompositeTypeTableModel.this;
                        synchronized (compositeTypeTableModel) {
                            --CompositeTypeTableModel.this.reloadCount;
                            CompositeTypeTableModel.this.notifyAll();
                        }
                    }
                });
            } else {
                CompositeTypeTableModel compositeTypeTableModel = CompositeTypeTableModel.this;
                synchronized (compositeTypeTableModel) {
                    --CompositeTypeTableModel.this.reloadCount;
                    CompositeTypeTableModel.this.notifyAll();
                }
            }
        }

        protected void loadChildren(DataValueNode dataValueNode) {
            if (!dataValueNode.isLeaf()) {
                final ArrayList<DataValueNode> arrayList = dataValueNode.createChildren();
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    if (!arrayList.get(i).isLeaf()) {
                        arrayList.get(i).loadChildren();
                    }
                    if (CompositeTypeTableModel.this.isValid) continue;
                    i = 0;
                }
                if (CompositeTypeTableModel.this.isValid) {
                    final DataValueNode dataValueNode2 = dataValueNode;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            dataValueNode2.setChildren(arrayList, true);
                            dataValueNode2.nodeChanged();
                        }
                    });
                }
            }
        }
    }

    class DataValueNode {
        protected String name;
        protected DataValue dataValue;
        protected DataType dataType;
        private DataValueNode parent;
        protected ArrayList<DataValueNode> children;
        protected boolean dirty;

        protected DataValueNode(DataValue dataValue) {
            this(null, dataValue);
        }

        protected DataValueNode(DataValueNode dataValueNode, DataValue dataValue) {
            this.parent = dataValueNode;
            this.dataType = dataValue.getDataType();
            this.dataValue = dataValue;
            this.name = dataValue.getName();
            this.children = new ArrayList(0);
            this.dirty = false;
        }

        protected void setNodeValue(DataValue dataValue, boolean bl) {
            this.dataValue = dataValue;
            this.makeClean();
            if (bl) {
                this.propogateNodeChanged();
            }
        }

        public String getName() {
            if (this.name == null && this.parent != null && this.parent.getDataType().getStructureType() == StructureType.TABLE) {
                String string = "[" + this.parent.children.indexOf(this) + "]";
                return string;
            }
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public DataValue getDataValue() {
            if (this.dirty && !this.isLeaf()) {
                LinkedList<DataValue> linkedList = new LinkedList<DataValue>();
                for (int i = 0; i < this.children.size(); ++i) {
                    linkedList.add(this.children.get(i).getDataValue());
                }
                this.dataValue = NamedDataValue.getNamedDataValue((String)this.name, (DataValue)this.getDataType().getDataValue(linkedList));
                this.dirty = false;
            }
            return NamedDataValue.getNamedDataValue((String)this.name, (DataValue)this.dataValue);
        }

        public ArrayList<DataValue> getDataValueChildren() {
            ArrayList<DataValue> arrayList = new ArrayList<DataValue>(this.children.size());
            for (DataValueNode dataValueNode : this.children) {
                arrayList.add(dataValueNode.getDataValue());
            }
            return arrayList;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public DataValueNode getParent() {
            return this.parent;
        }

        public boolean isLeaf() {
            return this.getDataType().getStructureType() == StructureType.PRIMITIVE;
        }

        protected ArrayList<DataValueNode> getChildren() {
            return this.children;
        }

        protected int getChildCount() {
            return this.children == null ? 0 : this.children.size();
        }

        protected void loadChildren() {
            this.children = this.createChildren();
            for (int i = this.children.size() - 1; i >= 0; --i) {
                Thread.yield();
                if (!this.children.get(i).isLeaf()) {
                    this.children.get(i).loadChildren();
                }
                if (CompositeTypeTableModel.this.isValid) continue;
                i = 0;
            }
        }

        protected ArrayList<DataValueNode> createChildren() {
            ArrayList<DataValueNode> arrayList = new ArrayList<DataValueNode>();
            List list = this.dataValue.getComponents();
            if (list != null) {
                for (DataValue dataValue : list) {
                    arrayList.add(new DataValueNode(this, dataValue));
                }
            }
            return arrayList;
        }

        protected boolean loadedChildren() {
            return this.isLeaf() || this.children != null;
        }

        public DataValueNode[] getPath() {
            return this.getPathToRoot(this, 0);
        }

        protected DataValueNode[] getPathToRoot(DataValueNode dataValueNode, int n) {
            DataValueNode[] dataValueNodeArray;
            if (dataValueNode == null) {
                if (n == 0) {
                    return nullNodes;
                }
                dataValueNodeArray = new DataValueNode[n];
            } else {
                dataValueNodeArray = this.getPathToRoot(dataValueNode.getParent(), ++n);
                dataValueNodeArray[dataValueNodeArray.length - n] = dataValueNode;
            }
            return dataValueNodeArray;
        }

        protected void setChildren(ArrayList<DataValueNode> arrayList, boolean bl) {
            this.children = arrayList;
            if (bl) {
                this.structureChanged();
                if (this.parent != null) {
                    this.parent.propogateNodeChanged();
                }
            }
        }

        protected synchronized void propogateNodeChanged() {
            this.nodeChanged();
            if (this.parent != null) {
                this.parent.propogateNodeChanged();
            }
        }

        protected void nodeChanged() {
            DataValueNode dataValueNode = this.getParent();
            if (dataValueNode != null) {
                Object[] objectArray = dataValueNode.getPath();
                int[] nArray = new int[]{CompositeTypeTableModel.this.getIndexOfChild(dataValueNode, this)};
                Object[] objectArray2 = new Object[]{this};
                CompositeTypeTableModel.this.fireTreeNodesChanged(CompositeTypeTableModel.this, objectArray, nArray, objectArray2);
            } else {
                CompositeTypeTableModel.this.fireTreeNodesChanged(CompositeTypeTableModel.this, this.getPath(), null, null);
            }
        }

        protected void structureChanged() {
            CompositeTypeTableModel.this.fireTreeStructureChanged(CompositeTypeTableModel.this, this.getPath(), null, null);
        }

        protected void childrenChanged(int[] nArray) {
            int n;
            if (nArray != null && nArray.length > 0 && (n = nArray[0]) < this.children.size()) {
                int[] nArray2 = new int[this.children.size() - n];
                int n2 = 0;
                int n3 = n;
                while (n3 < this.children.size()) {
                    nArray2[n2++] = n3++;
                }
                Object[] objectArray = new DataValueNode[nArray2.length];
                for (int i = 0; i < nArray2.length; ++i) {
                    objectArray[i] = this.children.get(nArray2[i]);
                }
                CompositeTypeTableModel.this.fireTreeNodesChanged(CompositeTypeTableModel.this, this.getPath(), nArray2, objectArray);
            }
        }

        protected void makeDirty() {
            this.dirty = true;
            if (this.parent != null) {
                this.parent.makeDirty();
            }
        }

        protected void makeClean() {
            this.dirty = false;
            if (this.parent != null) {
                this.parent.makeDirty();
            }
        }

        protected boolean isDirty() {
            return this.dirty;
        }

        protected void addChild(boolean bl) {
            DataValueNode dataValueNode2;
            ArrayList<DataValue> arrayList = new ArrayList<DataValue>(this.children.size() + 1);
            for (DataValueNode dataValueNode2 : this.children) {
                arrayList.add(dataValueNode2.getDataValue());
            }
            DataValue dataValue = ((DataType)((NamedValue)this.getDataType().getTypeComponents().iterator().next()).getValue()).getDataValue(null);
            arrayList.add(dataValue);
            dataValueNode2 = this.getDataType().getDataValue(arrayList);
            DataValueNode dataValueNode3 = new DataValueNode(this, dataValue);
            this.children.add(dataValueNode3);
            int[] nArray = new int[]{this.children.size() - 1};
            Object[] objectArray = new Object[]{dataValueNode3};
            if (bl) {
                CompositeTypeTableModel.this.fireTreeNodesInserted(CompositeTypeTableModel.this, this.getPath(), nArray, objectArray);
            }
            this.setNodeValue((DataValue)dataValueNode2, true);
        }

        protected void removeChildren(ArrayList arrayList, boolean bl) {
            int n;
            int[] nArray = new int[arrayList.size()];
            int n2 = 0;
            for (Object e : arrayList) {
                n = this.children.indexOf(e);
                if (n >= 0) {
                    nArray[n2++] = n;
                    continue;
                }
                return;
            }
            ArrayList<DataValue> arrayList2 = this.getDataValueChildren();
            for (int i = nArray.length - 1; i >= 0; --i) {
                arrayList2.remove(nArray[i]);
            }
            DataValue dataValue = this.getDataType().getDataValue((Object)arrayList2);
            for (n = nArray.length - 1; n >= 0; --n) {
                this.children.remove(nArray[n]);
            }
            if (bl) {
                CompositeTypeTableModel.this.fireTreeNodesRemoved(CompositeTypeTableModel.this, this.getPath(), nArray, arrayList.toArray(new Object[arrayList.size()]));
                this.childrenChanged(nArray);
            }
            this.setNodeValue(dataValue, true);
        }

        protected void insertChildren(ArrayList arrayList, boolean bl) {
            DataValue dataValue;
            int n;
            int n2;
            int[] nArray = new int[arrayList.size()];
            int n3 = 0;
            for (Object e : arrayList) {
                n2 = this.children.indexOf(e);
                if (n2 >= 0) {
                    nArray[n3++] = n2;
                    continue;
                }
                return;
            }
            int n4 = -1;
            int n5 = -1;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = nArray[n2];
                if (n != n4 + 1) {
                    n5 = nArray[n2] + n2;
                }
                n4 = n;
                nArray[n2] = ++n5;
            }
            ArrayList<DataValue> arrayList2 = this.getDataValueChildren();
            for (n = 0; n < nArray.length; ++n) {
                dataValue = ((DataType)((NamedValue)this.getDataType().getTypeComponents().iterator().next()).getValue()).getDataValue(null);
                arrayList2.add(nArray[n], dataValue);
            }
            DataValue dataValue2 = this.getDataType().getDataValue(arrayList2);
            dataValue = new DataValueNode[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                dataValue[i] = new DataValueNode(this, arrayList2.get(nArray[i]));
                this.children.add(nArray[i], (DataValueNode)dataValue[i]);
            }
            if (bl) {
                CompositeTypeTableModel.this.fireTreeNodesInserted(CompositeTypeTableModel.this, this.getPath(), nArray, (Object[])dataValue);
                this.childrenChanged(nArray);
            }
            this.setNodeValue(dataValue2, true);
        }

        protected void dupChildren(ArrayList arrayList, boolean bl) {
            int n;
            int[] nArray = new int[arrayList.size()];
            DataValue[] dataValueArray = new DataValue[arrayList.size()];
            int n2 = 0;
            for (Object e : arrayList) {
                DataValueNode dataValueNode = (DataValueNode)e;
                n = this.children.indexOf(dataValueNode);
                if (n >= 0) {
                    nArray[n2] = n;
                    dataValueArray[n2++] = ((DataType)((NamedValue)this.getDataType().getTypeComponents().iterator().next()).getValue()).getDataValue((Object)dataValueNode.getDataValue());
                    continue;
                }
                return;
            }
            int n3 = -1;
            int n4 = -1;
            for (int i = 0; i < nArray.length; ++i) {
                n = nArray[i];
                if (n != n3 + 1) {
                    n4 = nArray[i] + i;
                }
                n3 = n;
                nArray[i] = ++n4;
            }
            ArrayList<DataValue> arrayList2 = this.getDataValueChildren();
            for (n = 0; n < nArray.length; ++n) {
                arrayList2.add(nArray[n], dataValueArray[n]);
            }
            DataValue dataValue = this.getDataType().getDataValue(arrayList2);
            Object[] objectArray = new DataValueNode[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[i] = new DataValueNode(this, arrayList2.get(nArray[i]));
                this.children.add(nArray[i], (DataValueNode)objectArray[i]);
            }
            if (bl) {
                CompositeTypeTableModel.this.fireTreeNodesInserted(CompositeTypeTableModel.this, this.getPath(), nArray, objectArray);
                this.childrenChanged(nArray);
            }
            this.setNodeValue(dataValue, true);
        }
    }
}

