/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dbdiff.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.border.TitledPane;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLFormatHelper;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.extract.ui.panels.DdlOptionsPanel;
import oracle.ide.util.ResourceUtils;

public class DbDiffDdlOptionsPanel
extends DdlOptionsPanel {
    private static final long serialVersionUID = 1L;
    public static int PREFERENCES_COMPARE = 2;
    private JPanel _optionsPanel;
    private JCheckBox _generateSchema = new JCheckBox();
    private JCheckBox _generateConstraints = new JCheckBox();
    private JCheckBox _generateConstraintIndexes = new JCheckBox();
    private JCheckBox _generateRefConstraints = new JCheckBox();
    private JCheckBox _generatePasswordValue = new JCheckBox();
    private JCheckBox _generateSQLTerminator = new JCheckBox();
    private JCheckBox _generateComments = new JCheckBox();
    private JCheckBox _ignorePhysicalAttributes = new JCheckBox();
    private JCheckBox _ignoreSegmentAttributes = new JCheckBox();
    private JCheckBox _ignoreStorage = new JCheckBox();
    private JCheckBox _ignoreTableColumnPosition = new JCheckBox();
    private JCheckBox _ignoreTablespace = new JCheckBox();
    private JCheckBox _ignorePartitioning = new JCheckBox();
    private JCheckBox _ignoreHighValues = new JCheckBox();
    private JCheckBox _logicalCompare = new JCheckBox();
    private JCheckBox _statistics = new JCheckBox();
    private JRadioButton _ignoreSchema = new JRadioButton();
    private JRadioButton _maintainSchema = new JRadioButton();
    private JRadioButton _matchConstraintsByName = new JRadioButton();
    private JRadioButton _matchConstraintsByDef = new JRadioButton();
    private JCheckBox _reportConstraintNameDifferences = new JCheckBox();
    private ButtonGroup SCHEMA = new ButtonGroup();
    private ButtonGroup MATCHER = new ButtonGroup();
    private ItemListener _ignoreSegmentListener;
    private ItemListener _ignoreStorageListener;
    private ItemListener _ignoreTablespaceListener;

    public DbDiffDdlOptionsPanel(DDLFormat dDLFormat) {
        super(dDLFormat);
        this.initRadioGroups();
        this.initPhysical();
    }

    public DbDiffDdlOptionsPanel(int n) {
        super(n);
        this.initRadioGroups();
        this.initPhysical();
    }

    private void initRadioGroups() {
        this.MATCHER.add(this._matchConstraintsByName);
        this.MATCHER.add(this._matchConstraintsByDef);
        this._matchConstraintsByDef.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                boolean bl2 = bl = itemEvent.getStateChange() == 1;
                if (bl) {
                    DbDiffDdlOptionsPanel.this._reportConstraintNameDifferences.setEnabled(true);
                } else {
                    DbDiffDdlOptionsPanel.this._reportConstraintNameDifferences.setEnabled(false);
                }
            }
        });
        this.SCHEMA.add(this._ignoreSchema);
        this.SCHEMA.add(this._maintainSchema);
        this._maintainSchema.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                boolean bl2 = bl = itemEvent.getStateChange() == 1;
                if (bl) {
                    DbDiffDdlOptionsPanel.this._generateSchema.setSelected(true);
                }
            }
        });
    }

    private void initPhysical() {
        this._ignoreSegmentListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                boolean bl2 = bl = itemEvent.getStateChange() == 1;
                if (bl) {
                    DbDiffDdlOptionsPanel.this._ignoreStorage.setSelected(true);
                    DbDiffDdlOptionsPanel.this._ignoreTablespace.setSelected(true);
                } else {
                    DbDiffDdlOptionsPanel.this._ignoreStorage.setSelected(false);
                    DbDiffDdlOptionsPanel.this._ignoreTablespace.setSelected(false);
                }
            }
        };
        this._ignoreSegmentAttributes.addItemListener(this._ignoreSegmentListener);
        this._ignoreStorageListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                boolean bl2 = bl = itemEvent.getStateChange() == 1;
                if (!bl) {
                    DbDiffDdlOptionsPanel.this._ignoreSegmentAttributes.removeItemListener(DbDiffDdlOptionsPanel.this._ignoreSegmentListener);
                    DbDiffDdlOptionsPanel.this._ignoreSegmentAttributes.setSelected(false);
                    DbDiffDdlOptionsPanel.this._ignoreSegmentAttributes.addItemListener(DbDiffDdlOptionsPanel.this._ignoreSegmentListener);
                }
            }
        };
        this._ignoreStorage.addItemListener(this._ignoreStorageListener);
        this._ignoreTablespaceListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                boolean bl2 = bl = itemEvent.getStateChange() == 1;
                if (!bl) {
                    DbDiffDdlOptionsPanel.this._ignoreSegmentAttributes.removeItemListener(DbDiffDdlOptionsPanel.this._ignoreSegmentListener);
                    DbDiffDdlOptionsPanel.this._ignoreSegmentAttributes.setSelected(false);
                    DbDiffDdlOptionsPanel.this._ignoreSegmentAttributes.addItemListener(DbDiffDdlOptionsPanel.this._ignoreSegmentListener);
                }
            }
        };
        this._ignoreTablespace.addItemListener(this._ignoreTablespaceListener);
    }

    @Override
    public DDLFormat getFormat() {
        super.getFormat();
        this._format.setGenerateSchema(this._generateSchema.isSelected());
        this._format.setGenerateConstraints(this._generateConstraints.isSelected());
        this._format.setGenerateConstraintIndexes(this._generateConstraintIndexes.isSelected());
        this._format.setGenerateRefConstraints(this._generateRefConstraints.isSelected());
        this._format.setGeneratePasswordValue(this._generatePasswordValue.isSelected());
        this._format.setGenerateSQLTerminator(this._generateSQLTerminator.isSelected());
        this._format.setGenerateComments(this._generateComments.isSelected());
        this._format.setIgnorePhysicalAttributes(this._ignorePhysicalAttributes.isSelected());
        this._format.setIgnoreSchema(this._ignoreSchema.isSelected());
        this._format.setIgnoreSegmentAttributes(this._ignoreSegmentAttributes.isSelected());
        this._format.setIgnoreStorage(this._ignoreStorage.isSelected());
        this._format.setIgnoreTableColumnPosition(this._ignoreTableColumnPosition.isSelected());
        this._format.setIgnoreTablespace(this._ignoreTablespace.isSelected());
        this._format.setIgnorePartitioning(this._ignorePartitioning.isSelected());
        this._format.setIgnoreHighValues(this._ignoreHighValues.isSelected());
        this._format.setLogicalCompare(this._logicalCompare.isSelected());
        this._format.setMatchConstraintsByName(this._matchConstraintsByName.isSelected());
        if (this._matchConstraintsByName.isSelected()) {
            this._format.setReportConstraintNameDifferences(false);
        } else {
            this._format.setReportConstraintNameDifferences(this._reportConstraintNameDifferences.isSelected());
        }
        this._format.setStatistics(this._statistics.isSelected());
        return this._format;
    }

    @Override
    public void setFormat(DDLFormat dDLFormat) {
        super.setFormat(dDLFormat);
        this._generateSchema.setSelected(dDLFormat.getGenerateSchema());
        this._generateConstraints.setSelected(dDLFormat.getGenerateConstraints());
        this._generateConstraintIndexes.setSelected(dDLFormat.getGenerateConstraintIndexes());
        this._generateRefConstraints.setSelected(dDLFormat.getGenerateRefConstraints());
        this._generatePasswordValue.setSelected(dDLFormat.getGeneratePasswordValue());
        this._generateSQLTerminator.setSelected(dDLFormat.getGenerateSQLTerminator());
        this._generateComments.setSelected(dDLFormat.getGenerateComments());
        this._ignorePhysicalAttributes.setSelected(dDLFormat.getIgnorePhysicalAttributes());
        this._ignoreSchema.setSelected(dDLFormat.getIgnoreSchema());
        this._maintainSchema.setSelected(!dDLFormat.getIgnoreSchema());
        this._ignoreSegmentAttributes.setSelected(dDLFormat.getIgnoreSegmentAttributes());
        this._ignoreStorage.setSelected(dDLFormat.getIgnoreStorage());
        this._ignoreTableColumnPosition.setSelected(dDLFormat.getIgnoreTableColumnPosition());
        this._ignoreTablespace.setSelected(dDLFormat.getIgnoreTablespace());
        this._ignorePartitioning.setSelected(dDLFormat.getIgnorePartitioning());
        this._ignoreHighValues.setSelected(dDLFormat.getIgnoreHighValues());
        this._logicalCompare.setSelected(dDLFormat.getLogicalCompare());
        this._matchConstraintsByName.setSelected(dDLFormat.getMatchConstraintsByName());
        this._matchConstraintsByDef.setSelected(!dDLFormat.getMatchConstraintsByName());
        if (dDLFormat.getMatchConstraintsByName()) {
            this._reportConstraintNameDifferences.setSelected(false);
            this._reportConstraintNameDifferences.setEnabled(false);
        } else {
            this._reportConstraintNameDifferences.setSelected(dDLFormat.getReportConstraintNameDifferences());
            this._reportConstraintNameDifferences.setEnabled(true);
        }
        this._statistics.setSelected(dDLFormat.getStatistics());
    }

    public JPanel getPanel() {
        this._format.setShowGenerateOptionsEnabled(true);
        this._format.setShowCompareOptionsEnabled(true);
        this._format.setShowIgnorePhysicalAttributes(false);
        this.setFormat(this._format);
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(6, 0, 0, 0);
        Insets insets2 = new Insets(6, 8, 0, 0);
        Insets insets3 = new Insets(6, 16, 0, 0);
        Insets insets4 = new Insets(6, 24, 0, 0);
        int n = 0;
        this._optionsPanel = new JPanel(new GridBagLayout());
        this.setGenerateButtons();
        this._optionsPanel.add((Component)this._generateComments, new GridBagConstraints(0, n, 1, 1, 0.7, 0.0, 18, 0, insets, 0, 0));
        this._optionsPanel.add((Component)this._generateSchema, new GridBagConstraints(1, n, 1, 1, 0.7, 0.0, 18, 0, insets4, 0, 0));
        this._optionsPanel.add((Component)this._generateConstraints, new GridBagConstraints(2, n, 1, 1, 0.7, 0.0, 18, 0, insets4, 0, 0));
        this._optionsPanel.add((Component)this._generatePasswordValue, new GridBagConstraints(0, ++n, 1, 1, 0.7, 0.0, 18, 0, insets, 0, 0));
        this._optionsPanel.add((Component)this._generateConstraintIndexes, new GridBagConstraints(1, n, 1, 1, 0.7, 0.0, 18, 0, insets4, 0, 0));
        this._optionsPanel.add((Component)this._generateRefConstraints, new GridBagConstraints(2, n, 1, 1, 0.7, 0.0, 18, 0, insets4, 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this._optionsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 8, 0, 8), 0, 0));
        String string = this._usage != PREFERENCES ? DDLResources.getString("DDL_GEN_OPTIONS") : DDLResources.getString("DIFF_DDL_GEN_OPTIONS");
        JLabel jLabel = new JLabel(string);
        TitledPane titledPane = new TitledPane((Component)jLabel, (Component)jPanel2);
        jPanel.add((Component)titledPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setCompareButtons();
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this._ignoreSchema, new GridBagConstraints(0, 0, 1, 1, 0.7, 0.0, 18, 0, insets, 0, 0));
        jPanel3.add((Component)this._maintainSchema, new GridBagConstraints(0, 1, 1, 1, 0.7, 0.0, 18, 0, insets, 0, 0));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 8, 0, 8), 0, 0));
        JLabel jLabel2 = new JLabel(DDLResources.getString("SCHEMA_GROUP"));
        TitledPane titledPane2 = new TitledPane((Component)jLabel2, (Component)jPanel5);
        jPanel4.add((Component)this._matchConstraintsByName, new GridBagConstraints(0, 1, 2, 1, 0.7, 0.0, 18, 0, insets, 0, 0));
        jPanel4.add((Component)this._matchConstraintsByDef, new GridBagConstraints(0, 0, 1, 1, 0.7, 0.0, 18, 0, insets, 0, 0));
        jPanel4.add((Component)this._reportConstraintNameDifferences, new GridBagConstraints(1, 0, 1, 1, 0.7, 0.0, 18, 0, insets2, 0, 0));
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.add((Component)jPanel4, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 8, 0, 8), 0, 0));
        JLabel jLabel3 = new JLabel(DDLResources.getString("MATCH_CONS_GROUP"));
        TitledPane titledPane3 = new TitledPane((Component)jLabel3, (Component)jPanel6);
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        jPanel7.add((Component)titledPane2, new GridBagConstraints(0, 0, 1, 1, 0.7, 0.0, 18, 2, insets, 0, 0));
        jPanel7.add((Component)titledPane3, new GridBagConstraints(1, 0, 1, 1, 0.7, 0.0, 18, 2, insets4, 0, 0));
        jPanel7.add((Component)this._logicalCompare, new GridBagConstraints(1, 1, 1, 1, 0.7, 0.0, 18, 0, insets4, 0, 0));
        jPanel7.add((Component)this._ignoreTableColumnPosition, new GridBagConstraints(1, 2, 1, 1, 0.7, 0.0, 18, 0, insets4, 1, 0));
        jPanel7.add((Component)this._ignoreHighValues, new GridBagConstraints(1, 3, 1, 1, 0.7, 0.0, 18, 0, insets4, 0, 0));
        jPanel7.add((Component)this._ignoreSegmentAttributes, new GridBagConstraints(0, 1, 1, 1, 0.7, 0.0, 18, 0, insets, 0, 0));
        jPanel7.add((Component)this._ignoreStorage, new GridBagConstraints(0, 2, 1, 1, 0.7, 0.0, 18, 0, insets3, 0, 0));
        jPanel7.add((Component)this._ignoreTablespace, new GridBagConstraints(0, 3, 1, 1, 0.7, 0.0, 18, 0, insets3, 0, 0));
        jPanel7.add((Component)this._ignorePartitioning, new GridBagConstraints(0, 4, 1, 1, 0.7, 0.0, 18, 0, insets, 0, 0));
        JPanel jPanel8 = new JPanel(new GridBagLayout());
        jPanel8.add((Component)jPanel7, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 8, 0, 8), 0, 0));
        JLabel jLabel4 = new JLabel(DDLResources.getString("COMPARISON_OPTIONS"));
        TitledPane titledPane4 = new TitledPane((Component)jLabel4, (Component)jPanel8);
        jPanel.add((Component)titledPane4, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 2, new Insets(this._usage == WIZARD ? 8 : 16, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void setGenerateButtons() {
        ResourceUtils.resButton((AbstractButton)this._generateSchema, (String)DDLFormatHelper.getLabelText(DDLFormat.GEN_SCHEMA));
        ResourceUtils.resButton((AbstractButton)this._generateConstraints, (String)DDLFormatHelper.getLabelText(DDLFormat.GEN_CON));
        ResourceUtils.resButton((AbstractButton)this._generateConstraintIndexes, (String)DDLFormatHelper.getLabelText(DDLFormat.GEN_CON_IDX));
        ResourceUtils.resButton((AbstractButton)this._generateRefConstraints, (String)DDLFormatHelper.getLabelText(DDLFormat.GEN_REF_CON));
        ResourceUtils.resButton((AbstractButton)this._generatePasswordValue, (String)DDLFormatHelper.getLabelText(DDLFormat.GEN_PASS));
        ResourceUtils.resButton((AbstractButton)this._generateSQLTerminator, (String)DDLFormatHelper.getLabelText(DDLFormat.GEN_SQL_TERM));
        ResourceUtils.resButton((AbstractButton)this._generateComments, (String)DDLFormatHelper.getLabelText(DDLFormat.GEN_COMMENTS));
    }

    private void setCompareButtons() {
        ResourceUtils.resButton((AbstractButton)this._ignoreSchema, (String)DDLFormatHelper.getLabelText(DDLFormat.IGN_SCHEMA));
        ResourceUtils.resButton((AbstractButton)this._maintainSchema, (String)DDLFormatHelper.getLabelText(DDLFormat.MAINTAIN_SCHEMA));
        ResourceUtils.resButton((AbstractButton)this._ignorePhysicalAttributes, (String)DDLFormatHelper.getLabelText(DDLFormat.IGN_PHYS));
        ResourceUtils.resButton((AbstractButton)this._ignoreSegmentAttributes, (String)DDLFormatHelper.getLabelText(DDLFormat.IGN_SEG_ATTR));
        ResourceUtils.resButton((AbstractButton)this._ignoreStorage, (String)DDLFormatHelper.getLabelText(DDLFormat.IGN_STG));
        ResourceUtils.resButton((AbstractButton)this._ignoreTableColumnPosition, (String)DDLFormatHelper.getLabelText(DDLFormat.IGN_TBL_COL_POS));
        ResourceUtils.resButton((AbstractButton)this._ignoreTablespace, (String)DDLFormatHelper.getLabelText(DDLFormat.IGN_TABLESPACE));
        ResourceUtils.resButton((AbstractButton)this._ignorePartitioning, (String)DDLFormatHelper.getLabelText(DDLFormat.IGN_PARTITIONING));
        ResourceUtils.resButton((AbstractButton)this._ignoreHighValues, (String)DDLFormatHelper.getLabelText(DDLFormat.IGN_HIGH_VALUES));
        ResourceUtils.resButton((AbstractButton)this._logicalCompare, (String)DDLFormatHelper.getLabelText(DDLFormat.LOG_COMPARE));
        ResourceUtils.resButton((AbstractButton)this._matchConstraintsByName, (String)DDLFormatHelper.getLabelText(DDLFormat.MATCH_CONS_BY_NAME));
        ResourceUtils.resButton((AbstractButton)this._matchConstraintsByDef, (String)DDLFormatHelper.getLabelText(DDLFormat.MATCH_CONS_BY_DEF));
        ResourceUtils.resButton((AbstractButton)this._reportConstraintNameDifferences, (String)DDLFormatHelper.getLabelText(DDLFormat.RPT_CONS_NAME_DIFF));
        ResourceUtils.resButton((AbstractButton)this._statistics, (String)DDLFormatHelper.getLabelText(DDLFormat.STATS));
    }

    public boolean getGenerateConstraints() {
        return this._generateConstraints.isSelected();
    }

    public boolean getGenerateConstraintIndexes() {
        return this._generateConstraintIndexes.isSelected();
    }

    public boolean getGenerateRefConstraints() {
        return this._generateRefConstraints.isSelected();
    }

    public boolean getGeneratePasswordValue() {
        return this._generatePasswordValue.isSelected();
    }

    public boolean getGenerateSchema() {
        return this._generateSchema.isSelected();
    }

    public boolean getGenerateSQLTerminator() {
        return this._generateSQLTerminator.isSelected();
    }

    public boolean getGenerateComments() {
        return this._generateComments.isSelected();
    }

    public boolean getIgnorePhysicalAttributes() {
        return this._ignorePhysicalAttributes.isSelected();
    }

    public boolean getIgnoreSchema() {
        return this._ignoreSchema.isSelected();
    }

    public boolean getIgnoreSegmentAttributes() {
        return this._ignoreSegmentAttributes.isSelected();
    }

    public boolean getIgnoreStorage() {
        return this._ignoreStorage.isSelected();
    }

    public boolean getIgnoreTableColumnPosition() {
        return this._ignoreTableColumnPosition.isSelected();
    }

    public boolean getIgnorePartitioning() {
        return this._ignorePartitioning.isSelected();
    }

    public boolean getIgnoreHighValues() {
        return this._ignoreHighValues.isSelected();
    }

    public boolean getLogicalCompare() {
        return this._logicalCompare.isSelected();
    }

    public boolean getIgnoreTablespace() {
        return this._ignoreTablespace.isSelected();
    }

    public boolean getMatchConstraintsByName() {
        return this._matchConstraintsByName.isSelected();
    }

    public boolean getReportConstraintNameDifferences() {
        return this._reportConstraintNameDifferences.isSelected();
    }

    public boolean getStatistics() {
        return this._statistics.isSelected();
    }

    public void enableIgnoreSchema(boolean bl) {
        this._ignoreSchema.setSelected(bl);
        this._ignoreSchema.setEnabled(bl);
        this._maintainSchema.setSelected(!bl);
    }

    @Override
    public void enableOptions(boolean bl) {
        super.enableOptions(bl);
    }
}

