/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl;

import java.awt.Component;
import java.io.File;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.utils.MnemonicUtil;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class TargetFormatHelper {
    public static DefaultMutableTreeNode getSummaryNode(TargetFormat targetFormat) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(DDLResources.getString("TARGET_OPTIONS"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(TargetFormatHelper.getSummaryItem(targetFormat.getSaveAsTypeString(), OracleIcons.getIcon((String)"filesave.png"), targetFormat.getSaveAs())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(TargetFormatHelper.getSummaryNLSItem("ENCODING", targetFormat.getEncoding())));
        return defaultMutableTreeNode;
    }

    public static String getDisplayName(String string) {
        String string2 = MnemonicUtil.extractLabelTextWithoutMnemonic(DDLResources.getString(string));
        if (string2.endsWith(":")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static String getLabelText(String string) {
        return DDLResources.getString(string);
    }

    public static JLabel getSummaryNLSItem(String string, String string2) {
        JLabel jLabel = new JLabel();
        jLabel.setText(TargetFormatHelper.getDisplayName(string) + ": " + string2);
        jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
        return jLabel;
    }

    public static JLabel getSummaryItem(String string, Icon icon, String string2) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string + ": " + string2);
        jLabel.setIcon(icon);
        return jLabel;
    }

    public static JLabel getSummaryItem(String string, String string2) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string + ": " + string2);
        jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
        return jLabel;
    }

    public static void openTargetInUI(final TargetFormat targetFormat, Writer writer, final String string, String string2) throws Exception {
        if (targetFormat.isWorkSheet() && writer != null) {
            final String string3 = writer.toString();
            final String string4 = string2;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RaptorDBAddin.getSqlOpener().openNewEditor(string3, string4);
                }
            });
        } else if (targetFormat.isClipboard() && writer != null) {
            String string5 = writer.toString();
            UIUtils.setClipboard((String)string5);
        } else if (targetFormat.isOpenTarget() && string != null && string.length() > 4 && string.endsWith("sql")) {
            final SqlNode sqlNode = new SqlNode(targetFormat.getURL(string));
            final String string6 = sqlNode.getShortLabel();
            sqlNode.setSaveEncoding(targetFormat.getEncoding());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object object;
                    if (targetFormat.isSingleFile() && new File(targetFormat.getSaveAs()).length() > 500000L) {
                        String string2 = ExportWizArb.format("EXCEEDS_AUTO_OPEN_SIZE", targetFormat.getSaveAs());
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)string2, (String)ExportWizArb.getString("TASK_SHORT_NAME"), null);
                        return;
                    }
                    List list = EditorManager.getEditorManager().getAllEditors();
                    Iterator iterator = list.iterator();
                    Editor editor = null;
                    while (iterator.hasNext()) {
                        editor = (Editor)iterator.next();
                        object = editor.getTabLabel();
                        if (!string.equals(object) && !string.equals(((String)object).replace('*', ' ').trim()) && !string6.equals(object) && !string6.equals(((String)object).replace('*', ' ').trim())) continue;
                        EditorManager.getEditorManager().closeEditors(Arrays.asList(editor));
                        break;
                    }
                    object = Context.newIdeContext((Node)sqlNode);
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions((Context)object);
                    openEditorOptions.setFlags(1);
                    EditorManager.getEditorManager().openEditor(openEditorOptions);
                }
            });
        }
    }
}

