/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.ddl.oracle.OracleObjectDDL;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;

public class OracleTempTabGroupDDL
extends OracleObjectDDL {
    protected String getDDLHeader(BasicDBObject basicDBObject) {
        return this.getHeader("Temporary Tablespace Group", basicDBObject.getObjectName());
    }

    protected String getQueryFile() {
        return "";
    }

    protected String getQueryKey(String string) {
        return "";
    }

    protected String doGetDDLScript(BasicDBObject basicDBObject) {
        return this.doGetDDL(basicDBObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doGetDDL(BasicDBObject basicDBObject) {
        String string = "select 'ALTER TABLESPACE '||tablespace_name||' TABLESPACE GROUP '||:OBJECT_NAME||';\n' as SQLSTRING from dba_tablespace_groups where group_name = :OBJECT_NAME  union all  select 'ALTER DATABASE DEFAULT TEMPORARY TABLESPACE '||property_value||';\n' as sql_string  from database_properties   where property_name = 'DEFAULT_TEMP_TABLESPACE'  and property_value = :OBJECT_NAME ";
        StringBuilder stringBuilder = new StringBuilder();
        Connection connection = basicDBObject.getConnection();
        ResultSet resultSet = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (Connections.getInstance().lock(connection)) {
            block6: {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    hashMap.put("OBJECT_NAME", basicDBObject.getObjectName());
                    resultSet = dBUtil.executeOracleQuery(string, hashMap);
                    if (resultSet == null) break block6;
                    while (resultSet.next()) {
                        stringBuilder.append(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return stringBuilder.toString();
    }
}

