/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.security;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.dialogs.security.QuotaObject;
import oracle.dbtools.raptor.dialogs.security.SubjectObject;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;

public class UserObject
extends SubjectObject {
    private boolean externalUser = false;
    private String externalName;
    private String password;
    private boolean expired = false;
    private boolean edition = false;
    private boolean locked = false;
    private boolean shardingCatalog = false;
    private boolean shardDDLEnabled = false;
    private boolean shardedUser = false;
    private String defTableSpace;
    private String tempTableSpace;
    private Map<String, QuotaObject> quotas = new HashMap<String, QuotaObject>();
    private List<String> tablespaceGroups = new ArrayList<String>();
    private boolean enableEdition = false;

    public UserObject(Connection connection, String string, boolean bl) {
        super(connection, string, bl);
        this.enableEdition = RaptorVersionTracker.checkVersion(connection, null, new Version("11.2"));
        this.loadSharding(connection);
        this.loadUser(connection, string);
        this.loadQuotas(connection, string);
        this.loadTablespaceGroups(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUser(Connection connection, String string) {
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        if (string != null) {
            try {
                callableStatement = connection.prepareCall(this.getQuery("get_user"));
                callableStatement.setString(1, string);
                resultSet = callableStatement.executeQuery();
                if (resultSet.next()) {
                    String string2;
                    String string3 = resultSet.getString(1);
                    if (string3.indexOf("LOCKED") != -1) {
                        this.locked = true;
                    }
                    if (string3.indexOf("EXPIRED") != -1) {
                        this.expired = true;
                    }
                    this.defTableSpace = resultSet.getString(2);
                    this.tempTableSpace = resultSet.getString(3);
                    String string4 = resultSet.getString(4);
                    if ("EXTERNAL".equals(string4)) {
                        this.externalUser = true;
                    }
                    this.externalName = resultSet.getString(5);
                    if (this.enableEdition && (string2 = resultSet.getString(6)).equals("Y")) {
                        this.edition = true;
                    }
                    if (this.shardingCatalog) {
                        this.shardedUser = resultSet.getString(7).equals("YES");
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
                try {
                    callableStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadQuotas(Connection connection, String string) {
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = connection.prepareCall(this.getQuery("get_quotas"));
            callableStatement.setString(1, string);
            callableStatement.setString(2, string);
            resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                String string5 = resultSet.getString(4);
                String string6 = resultSet.getString(5);
                QuotaObject quotaObject = new QuotaObject(string2, string3, string4, string5, string6);
                this.quotas.put(string2, quotaObject);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSharding(Connection connection) {
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = connection.prepareCall(this.getQuery("get_sharded_ddl"));
            resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                this.shardingCatalog = true;
                this.shardedUser = this.shardDDLEnabled = resultSet.getString(1).equals("ENABLED");
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTablespaceGroups(Connection connection) {
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = connection.prepareCall(this.getQuery("get_tablespace_groups"));
            resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                this.tablespaceGroups.add(string);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected void appendPreSql(StringBuffer stringBuffer) {
        if (!this.isAlter() && this.getSubjectName() != null && this.shardDDLEnabled != this.shardedUser) {
            stringBuffer.append("ALTER SESSION ");
            stringBuffer.append(this.shardedUser ? "ENABLE" : "DISABLE");
            stringBuffer.append(" SHARD DDL;\n");
        }
    }

    @Override
    protected void appendPostSql(StringBuffer stringBuffer) {
        if (!this.isAlter() && this.getSubjectName() != null && this.shardDDLEnabled != this.shardedUser) {
            stringBuffer.append("ALTER SESSION ");
            stringBuffer.append(this.shardDDLEnabled ? "ENABLE" : "DISABLE");
            stringBuffer.append(" SHARD DDL;\n");
        }
    }

    @Override
    protected void appendSubjectSql(StringBuffer stringBuffer) {
        stringBuffer.append("-- USER SQL\n");
        if (this.isAlter()) {
            stringBuffer.append("ALTER USER ");
            stringBuffer.append("\"" + this.getSubjectName() + "\"");
            if (this.externalUser) {
                stringBuffer.append(" IDENTIFIED EXTERNALLY AS '");
                stringBuffer.append(this.getExternalName());
                stringBuffer.append("'");
            } else if (this.password != null) {
                stringBuffer.append(" IDENTIFIED BY \"");
                stringBuffer.append(this.password);
                stringBuffer.append("\" ");
            }
            if (this.defTableSpace != null) {
                stringBuffer.append("\nDEFAULT TABLESPACE ");
                stringBuffer.append("\"" + this.defTableSpace + "\"");
            }
            if (this.tempTableSpace != null) {
                stringBuffer.append("\nTEMPORARY TABLESPACE ");
                stringBuffer.append("\"" + this.tempTableSpace + "\"");
            }
            if (this.expired) {
                stringBuffer.append("\nPASSWORD EXPIRE ");
            }
            if (this.locked) {
                stringBuffer.append("\nACCOUNT LOCK ");
            } else {
                stringBuffer.append("\nACCOUNT UNLOCK ");
            }
            if (this.enableEdition && this.edition) {
                stringBuffer.append("\nENABLE EDITIONS ");
            }
            stringBuffer.append(";\n");
        } else if (this.getSubjectName() != null) {
            stringBuffer.append("CREATE USER \"");
            stringBuffer.append(this.getSubjectName());
            stringBuffer.append("\"");
            if (this.externalUser) {
                stringBuffer.append(" IDENTIFIED EXTERNALLY");
            } else {
                stringBuffer.append(" IDENTIFIED BY \"");
                stringBuffer.append(this.password);
                stringBuffer.append("\" ");
            }
            stringBuffer.append(" ");
            if (this.defTableSpace != null) {
                stringBuffer.append("\nDEFAULT TABLESPACE ");
                stringBuffer.append("\"" + this.defTableSpace + "\"");
            }
            if (this.tempTableSpace != null) {
                stringBuffer.append("\nTEMPORARY TABLESPACE ");
                stringBuffer.append("\"" + this.tempTableSpace + "\"");
            }
            if (this.expired) {
                stringBuffer.append("\nPASSWORD EXPIRE ");
            }
            if (this.locked) {
                stringBuffer.append("\nACCOUNT LOCK ");
            }
            if (this.enableEdition && this.edition) {
                stringBuffer.append("\nENABLE EDITIONS ");
            }
            stringBuffer.append(";\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("-- QUOTAS\n");
        for (String string : this.quotas.keySet()) {
            QuotaObject quotaObject = this.quotas.get(string);
            if (quotaObject.isUnlimited()) {
                stringBuffer.append("ALTER USER ");
                stringBuffer.append("\"" + this.getSubjectName() + "\"");
                stringBuffer.append(" QUOTA UNLIMITED ON \"" + string + "\";\n");
                continue;
            }
            if (quotaObject.revUnlimited()) {
                stringBuffer.append("ALTER USER ");
                stringBuffer.append("\"" + this.getSubjectName() + "\"");
                stringBuffer.append(" QUOTA 0 ON \"" + string + "\";\n");
                continue;
            }
            if (quotaObject.getQuota() == null) continue;
            stringBuffer.append("ALTER USER ");
            stringBuffer.append("\"" + this.getSubjectName() + "\"");
            stringBuffer.append(" QUOTA " + quotaObject.getQuotaString() + " ON \"" + string + "\";\n");
        }
        stringBuffer.append("\n");
    }

    public String getDefTableSpace() {
        return this.defTableSpace;
    }

    public void setDefTableSpace(String string) {
        this.defTableSpace = string;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean bl) {
        this.expired = bl;
    }

    public boolean isExternalUser() {
        return this.externalUser;
    }

    public void setExternalUser(boolean bl) {
        this.externalUser = bl;
    }

    public boolean getEdition() {
        return this.edition;
    }

    public void setEdition(boolean bl) {
        this.edition = bl;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public String getPassword() {
        return this.password;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getTempTableSpace() {
        return this.tempTableSpace;
    }

    public void setTempTableSpace(String string) {
        this.tempTableSpace = string;
    }

    public void updateQuota(String string, boolean bl, String string2, String string3) {
        this.quotas.get(string).setUnlimited(bl);
        this.quotas.get(string).setQuota(string2);
        this.quotas.get(string).setUnit(string3);
    }

    public void updateQuota(QuotaObject quotaObject) {
        QuotaObject quotaObject2 = this.quotas.get(quotaObject.getName());
        quotaObject2.setUnlimited(quotaObject.isUnlimited());
        quotaObject2.setQuota(quotaObject.getQuota());
        quotaObject2.setUnit(quotaObject.getUnit());
    }

    public Map<String, QuotaObject> getQuotas() {
        return this.quotas;
    }

    public List<String> getTablespaceGroups() {
        return this.tablespaceGroups;
    }

    public boolean isShardingCatalog() {
        return this.shardingCatalog;
    }

    public boolean isShardedUser() {
        return this.shardedUser;
    }

    public void setShardedUser(boolean bl) {
        this.shardedUser = bl;
    }
}

