/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.net.URL;
import java.util.Properties;
import javax.swing.BorderFactory;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.editors.IStatusMessageProvider;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.db.DBNavigatorWindow;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;

public class ActiveViewStatusChanger
implements ActiveViewListener {
    public static DockLayoutPanel findTabGroupPanel(View view) {
        Container container;
        Component component = view.getGUI();
        Container container2 = container = null == component ? null : view.getGUI().getParent();
        while (container != null) {
            if (container instanceof DockLayoutPanel) {
                return (DockLayoutPanel)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public static void updateViewColor(View view) {
        Node node = view.getContext().getNode();
        String string = null;
        if (view instanceof DbEditor) {
            string = ((DbEditor)view).getConnectionName();
        } else if (view instanceof CodeEditor && node instanceof PlSqlNode) {
            string = ((PlSqlNode)node).getConnectionName();
        }
        if (string != null) {
            DockLayoutPanel dockLayoutPanel;
            Properties properties = Connections.getInstance().getConnectionInfo(string);
            String string2 = null;
            if (properties != null) {
                string2 = properties.getProperty("Connection-Color-For-Editors");
            }
            if ((dockLayoutPanel = ActiveViewStatusChanger.findTabGroupPanel(view)) != null) {
                try {
                    Color color = null;
                    if (string2 != null) {
                        color = new Color(Integer.parseInt(string2));
                        dockLayoutPanel.setBorder(BorderFactory.createLineBorder(color, 2));
                    } else {
                        dockLayoutPanel.setBorder(null);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        try {
            View view = activeViewEvent.getNewView();
            if (view instanceof IStatusMessageProvider) {
                Ide.getStatusBar().setText(((IStatusMessageProvider)activeViewEvent.getNewView()).getStatusMessage());
            }
            ActiveViewStatusChanger.updateViewColor(view);
            if (view instanceof IDBEditor || view instanceof DBNavigatorWindow) {
                String string = null;
                if (view instanceof IDBEditor) {
                    string = ((IDBEditor)view).getConnectionName();
                }
                Element element = view.getContext().getElement();
                if (string == null && element instanceof Locatable) {
                    String string2;
                    URL uRL = null;
                    uRL = element instanceof IViewerNode ? ((IViewerNode)element).getBaseNode().getURL() : ((Locatable)element).getURL();
                    if (uRL != null && DBURLFormatHelper.isDBURL(uRL) && (string2 = DBURLFormatHelper.getConnectionName(uRL)) != null) {
                        string = string2;
                    }
                }
                Connections.setActiveConnectionName(string);
            }
        }
        catch (Throwable throwable) {
            Logger.warn(this.getClass(), (Throwable)throwable);
        }
    }
}

