/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import oracle.bali.ewt.border.TitledPane;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.raptor.controls.SpringUtilities;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.extract.ui.panels.DdlOptionsPanel;

public class ExportDdlOptionsPanel
extends DdlOptionsPanel {
    private static final long serialVersionUID = 1L;
    private JPanel _optionsPanel;
    private JPanel _options2Panel;
    private ItemListener _exportListener;
    private boolean _exportListenerAdded = false;

    public ExportDdlOptionsPanel(DDLFormat dDLFormat) {
        super(dDLFormat);
    }

    public ExportDdlOptionsPanel(int n) {
        super(n);
    }

    @Override
    public DDLFormat getFormat() {
        super.getFormat();
        return this._format;
    }

    public JPanel getPanel() {
        int n;
        float f;
        this._optionsPanel = new JPanel(new SpringLayout());
        super.initComponents();
        this.addExportListener();
        this.setFormat(this._format);
        Integer n2 = 0;
        if (this._format.getShowByte()) {
            this._optionsPanel.add(this._byte);
            n2 = n2 + 1;
        }
        if (this._format.getShowForce()) {
            this._optionsPanel.add(this._force);
            n2 = n2 + 1;
        }
        if (this._format.getShowCascade()) {
            this._optionsPanel.add(this._cascade);
            n2 = n2 + 1;
        }
        if (this._format.getShowConstraint()) {
            this._optionsPanel.add(this._constraint);
            n2 = n2 + 1;
        }
        if (this._format.getShowDep()) {
            this._optionsPanel.add(this._dep);
            n2 = n2 + 1;
        }
        if (this._format.getShowDrop()) {
            this._optionsPanel.add(this._drop);
            n2 = n2 + 1;
        }
        if (this._format.getShowGrant()) {
            this._optionsPanel.add(this._grant);
            n2 = n2 + 1;
        }
        if (this._format.getShowPartitioning()) {
            this._optionsPanel.add(this._partitioning);
            n2 = n2 + 1;
        }
        if (this._format.getShowPretty()) {
            this._optionsPanel.add(this._pretty);
            n2 = n2 + 1;
        }
        if (this._format.getShowRefConstraint()) {
            this._optionsPanel.add(this._refConstraint);
            n2 = n2 + 1;
        }
        if (this._format.getShowSchema()) {
            this._optionsPanel.add(this._schema);
            n2 = n2 + 1;
        }
        if (this._format.getShowSegments()) {
            this._optionsPanel.add(this._segments);
            n2 = n2 + 1;
        }
        if (this._format.getShowTablespace()) {
            this._optionsPanel.add(this._tablespace);
            n2 = n2 + 1;
        }
        if (this._format.getShowTerminator()) {
            this._optionsPanel.add(this._terminiator);
            n2 = n2 + 1;
        }
        if (this._format.getShowTrigger()) {
            this._optionsPanel.add(this._trigger);
            n2 = n2 + 1;
        }
        if ((f = n2.floatValue() / 4.0f) > (float)(n = n2 / 4)) {
            this.addDummies(++n * 4 - n2);
        }
        SpringUtilities.makeCompactGrid((Container)this._optionsPanel, (int)n, (int)4, (int)10, (int)6, (int)10, (int)3);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._optionsPanel, new GridBagConstraints(0, 0, 1, 1, 0.7, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this._format.getShowAlter()) {
            this._options2Panel = new JPanel(new GridBagLayout());
            this._options2Panel.add((Component)this._alter, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
            jPanel.add((Component)this._options2Panel, new GridBagConstraints(0, 1, 1, 1, 0.7, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
            jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else if (this._format.getShowVersion()) {
            this._options2Panel = new JPanel(new GridBagLayout());
            this._options2Panel.add((Component)this._versionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 8, 0), 0, 0));
            this._options2Panel.add((Component)this._version, new GridBagConstraints(1, 0, 4, 1, 0.0, 0.0, 18, 2, new Insets(6, 8, 8, 0), 0, 0));
            jPanel.add((Component)this._options2Panel, new GridBagConstraints(0, 1, 1, 1, 0.7, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
            jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        TitledPane titledPane = null;
        titledPane = this._usage == PREFERENCES && this._format.getPreference() == 3 ? new TitledPane((Component)new JLabel(DDLResources.getString("DEPLOY_OPT_TITLE_PREF")), (Component)jPanel) : new TitledPane((Component)this._exportDDL, (Component)jPanel);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)titledPane, new GridBagConstraints(0, 0, 1, 1, 0.7, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel2;
    }

    private void addDummies(int n) {
        this._optionsPanel.add(this._dummy1);
        this._dummy1.setVisible(false);
        if (--n == 0) {
            return;
        }
        this._optionsPanel.add(this._dummy2);
        this._dummy2.setVisible(false);
        if (--n == 0) {
            return;
        }
        this._optionsPanel.add(this._dummy3);
        this._dummy3.setVisible(false);
    }

    public void setDefault() {
        this._schema.setSelected(true);
        this._segments.setSelected(false);
        this._partitioning.setSelected(false);
        this._tablespace.setSelected(false);
        this._terminiator.setSelected(true);
        this._pretty.setSelected(true);
        this._byte.setSelected(false);
        this._force.setSelected(false);
        this._alter.setSelected(false);
        this._drop.setSelected(false);
        this._cascade.setSelected(false);
        this._grant.setSelected(false);
        this._dep.setSelected(false);
        this._constraint.setSelected(true);
        this._refConstraint.setSelected(true);
        this._trigger.setSelected(true);
        this._truncate.setSelected(false);
    }

    public void allowDisable(boolean bl) {
        this._exportDDL.setSelected(!bl);
        this._exportDDL.setEnabled(bl);
        if (bl) {
            this.addExportListener();
        } else {
            this.removeExportListener();
        }
    }

    public void removeExportListener() {
        if (this._exportListenerAdded) {
            this._exportDDL.removeItemListener(this._exportListener);
        }
        this._exportListenerAdded = false;
    }

    void addExportListener() {
        if (!this._exportListenerAdded) {
            this._exportListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ExportDdlOptionsPanel.this.enableOptions(ExportDdlOptionsPanel.this._exportDDL.isSelected());
                }
            };
            this._exportDDL.addItemListener(this._exportListener);
            this._exportListenerAdded = true;
        }
    }
}

