/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.app.CompletionList;
import oracle.dbtools.app.SqlCompleter;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.db.ChameleonConnection;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.insight.UsersCache;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SqlHistory;
import oracle.dbtools.parser.plsql.SuggestedItem;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.parser.plsql.doc.Substr;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.insight.DBListInsightData;
import oracle.dbtools.raptor.insight.InsightCache;
import oracle.dbtools.raptor.insight.InsightTest;
import oracle.dbtools.raptor.insight.InsightableOracleDatabase;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.refactor.MultiFieldEdit;
import oracle.dbtools.raptor.templates.CodeTemplateUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.Insight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Pair;

public final class CompletionInsight
extends AbstractInsight
implements InsightProvider {
    public static boolean trace = false;
    public static boolean timing = false;
    private DBListInsightView _view = new DBListInsightView();
    DBListInsightData _lastLookup;
    private Node node;
    private String connName = null;
    int startCaretPosition;
    BackgroundParser parser = null;
    boolean raiselimit = false;
    boolean raiseHlimit = false;
    boolean raiseSlimit = false;
    boolean raiseTlimit = false;
    List<Member> members = new LinkedList<Member>();
    LexerToken prior = null;
    boolean isWorksheet = false;
    static List<CompletionInsight> instances = new LinkedList<CompletionInsight>();
    final List<String> bindVars;
    private char typedChar = '\u0000';
    boolean wasAutoInvoked;
    String identifierPrefix = "";
    private String alias = "";
    static int timeout = 0;
    long wait = 500L;
    private InsightThread worker = null;
    private static boolean firstInvocation;
    List<Integer> selectionOrder = new LinkedList<Integer>();
    public static final int minTSuggestions = 3;
    public static final int maxTSuggestions = 20;
    public static int tSuggestions;
    public static final int minSuggestions = 3;
    public static final int maxSuggestions = 20;
    public static int suggestions;
    static final String path = "/oracle/dbtools/raptor/insight/";
    static SqlProgram programInstance;
    Map<String, List<String>> iterTables = new HashMap<String, List<String>>();
    Map<String, List<String>> iterColumns = new HashMap<String, List<String>>();

    private String getConnName() {
        if (this.connName != null) {
            return this.connName;
        }
        if (this.node instanceof PlSqlNode && ((PlSqlNode)this.node).getConnectionName() != null) {
            PlSqlNode plSqlNode = (PlSqlNode)this.node;
            this.connName = plSqlNode.getConnectionName();
        } else if (this.node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)this.node;
            this.connName = DBURLFormatHelper.getConnectionName(this.node.getURL());
        }
        return this.connName;
    }

    public CompletionInsight(Context context, BackgroundParser backgroundParser) {
        this.parser = backgroundParser;
        this.bindVars = new LinkedList<String>();
        instances.add(this);
        this.node = context.getNode();
        if (!(this.node instanceof PlSqlNode)) {
            throw new AssertionError((Object)"Not PL/SQL editor");
        }
        this.parser = ((PlSqlNode)this.node).getParser();
        this.initMembers((PlSqlNode)this.node);
        DBConfig dBConfig = DBConfig.getInstance();
        if (dBConfig.getBoolean("ENABLECOMPLETIONPLSQLEDITOR").booleanValue() && DBURLFormatHelper.isDBURL(this.node.getURL())) {
            new Thread(){

                @Override
                public void run() {
                    UsersCache.fillIn((String)CompletionInsight.this.getConnName());
                    if (InsightableOracleDatabase.mode == InsightableOracleDatabase.Mode.CACHE_UNION || InsightableOracleDatabase.mode == InsightableOracleDatabase.Mode.CACHE_PARALLEL) {
                        InsightCache.fillIn(CompletionInsight.this.getConnName());
                    }
                }
            }.start();
        }
        this.setCellRenderer();
    }

    public CompletionInsight(String string, BackgroundParser backgroundParser, List<String> list) {
        DBConfig dBConfig;
        this.parser = backgroundParser;
        this.bindVars = list;
        instances.add(this);
        this.isWorksheet = true;
        this.connName = string;
        if (!string.startsWith("jdbc:oracle:thin:@") && (dBConfig = DBConfig.getInstance()).getBoolean("ENABLECOMPLETIONWORKSHEET").booleanValue()) {
            new Thread(){

                @Override
                public void run() {
                    UsersCache.fillIn((String)CompletionInsight.this.getConnName());
                    if (InsightableOracleDatabase.mode == InsightableOracleDatabase.Mode.CACHE_UNION || InsightableOracleDatabase.mode == InsightableOracleDatabase.Mode.CACHE_PARALLEL) {
                        InsightCache.fillIn(CompletionInsight.this.getConnName());
                    }
                }
            }.start();
        }
        this.setCellRenderer();
    }

    public CompletionInsight(String string, BackgroundParser backgroundParser) {
        this(string, backgroundParser, new LinkedList<String>());
    }

    public void setCellRenderer() {
        ListDataItemCellRenderer listDataItemCellRenderer = new ListDataItemCellRenderer(){
            boolean printOnce = true;

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (object instanceof SuggestedItem) {
                    JLabel jLabel = (JLabel)component;
                    SuggestedItem suggestedItem = (SuggestedItem)object;
                    EditorProperties editorProperties = EditorProperties.getProperties();
                    Font font = editorProperties.getFontHelper().getFont(0);
                    jLabel.setFont(font);
                    jLabel.setToolTipText(suggestedItem.getName());
                    jLabel.setIcon(suggestedItem.getIcon());
                    if ("KEYWORD".equals(suggestedItem.getType())) {
                        jLabel.setForeground(Color.BLUE);
                    }
                    if (suggestedItem.isDocSnippet()) {
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new BoxLayout(jPanel, 0));
                        JButton jButton = new JButton(OracleIcons.getIcon((String)"library.png"));
                        jButton.setBorder(BorderFactory.createRaisedBevelBorder());
                        jButton.setSize(new Dimension(suggestedItem.getIcon().getIconWidth(), suggestedItem.getIcon().getIconHeight()));
                        jButton.setEnabled(true);
                        jPanel.setToolTipText(suggestedItem.getName());
                        jPanel.add(jButton);
                        jLabel.setIcon(null);
                        jPanel.add(jLabel);
                        return jPanel;
                    }
                }
                return component;
            }

            public Dimension getPreferredSize() {
                int n;
                Dimension dimension = super.getPreferredSize();
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                if (trace && this.printOnce) {
                    System.out.println("dim.width=" + dimension2.width);
                    this.printOnce = false;
                }
                if ((n = dimension2.width / 4) < 250) {
                    n = 250;
                }
                return new Dimension(n, dimension.height);
            }
        };
        this._view.setCellRenderer((ListCellRenderer)listDataItemCellRenderer);
        int n = Toolkit.getDefaultToolkit().getScreenSize().height / 2 / (OracleIcons.getIcon((String)"table.png").getIconHeight() + 4);
        n = Math.max(n, 15);
        n = Math.min(n, 45);
        this._view.setVisibleRowCount(n);
        this._view.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                Object object = mouseEvent.getSource();
                if (object instanceof ListInsightView) {
                    SuggestedItem suggestedItem;
                    ListInsightView listInsightView = (ListInsightView)object;
                    if (mouseEvent.getX() <= listInsightView.getX() + 16 && (suggestedItem = (SuggestedItem)listInsightView.getSelectedValue()).isDocSnippet()) {
                        try {
                            Desktop.getDesktop().browse(new URI(suggestedItem.doc.getPublicURL()));
                        }
                        catch (Exception exception) {
                            oracle.javatools.util.Log.error((String)("Failed to go to URL, " + exception.getMessage()));
                        }
                    }
                }
            }
        });
    }

    private void initMembers(PlSqlNode plSqlNode) {
        if ("FUNCTION".equalsIgnoreCase(plSqlNode.getSrcType()) || "PROCEDURE".equalsIgnoreCase(plSqlNode.getSrcType())) {
            return;
        }
        plSqlNode.addMembersTo(this.members);
        if (plSqlNode.isBody()) {
            URL uRL = plSqlNode.getURL();
            String string = DBURLFormatHelper.getBaseType(uRL);
            URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), string.substring(0, string.indexOf(32))), DBURLFormatHelper.getName(uRL));
            PlSqlNode plSqlNode2 = PlSqlNode.find(uRL2);
            plSqlNode2.addMembersTo(this.members);
        }
    }

    protected InsightProvider createInsightProvider() {
        return this;
    }

    public void characterTyped(BasicEditorPane basicEditorPane, int n, char c) {
        DBConfig dBConfig = DBConfig.getInstance();
        if (RaptorExtensionConstants.isStandAlone()) {
            if (MultiFieldEdit.inEditMode) {
                basicEditorPane.putBooleanProperty("completion-enable-autopopup", false);
            } else if (!this.isWorksheet) {
                basicEditorPane.putIntegerProperty("completion-popup-delay", dBConfig.getInt("DELAYCOMPLETION"));
                basicEditorPane.putBooleanProperty("completion-enable-autopopup", dBConfig.getBoolean("ENABLECOMPLETIONPLSQLEDITOR").booleanValue());
            } else {
                basicEditorPane.putIntegerProperty("completion-popup-delay", dBConfig.getInt("DELAYCOMPLETION"));
                basicEditorPane.putBooleanProperty("completion-enable-autopopup", dBConfig.getBoolean("ENABLECOMPLETIONWORKSHEET").booleanValue());
            }
        }
        super.characterTyped(basicEditorPane, n, c);
    }

    public boolean isInsightTriggerChar(char c) {
        this.typedChar = c;
        return c != ';';
    }

    public void showInsight(boolean bl) {
        this.wasAutoInvoked = bl;
        super.showInsight(bl);
    }

    protected boolean isAutomaticPartialComplete(InsightData insightData) {
        return false;
    }

    String getAliacedPrefix() {
        if (this.alias.length() == 0) {
            return this.identifierPrefix;
        }
        return this.alias + "." + this.identifierPrefix;
    }

    public InsightData getInsightData(BasicEditorPane basicEditorPane) {
        if (Connections.getInstance().isTimesTen(this.getConnName())) {
            return null;
        }
        this._lastLookup = null;
        if (this.worker != null && this.worker.isAlive()) {
            return null;
        }
        this.worker = new InsightThread("InsightThread");
        this.worker.start();
        long l = System.currentTimeMillis();
        long l2 = this.wait = this.typedChar == '\u0000' ? 5000L : 750L;
        if (firstInvocation && this.wait < 2000L) {
            this.wait = 2000L;
            firstInvocation = false;
        }
        if (this.raiselimit) {
            this.wait = 15000L;
        }
        if (0 < timeout && this.typedChar == '\u0000') {
            this.wait = timeout;
        }
        while (this.worker.isAlive()) {
            if (this.wait < System.currentTimeMillis() - l) {
                Log.log((String)("Cancelled insight worker after waiting " + (System.currentTimeMillis() - l) + " ms"));
                DBUtil.cancelExecution((Thread)this.worker);
                break;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.typedChar = '\u0000';
        return this._lastLookup;
    }

    private boolean isKeywordsOnly(Collection<SuggestedItem> collection) {
        for (SuggestedItem suggestedItem : collection) {
            if ("KEYWORD".equals(suggestedItem.getType())) continue;
            return false;
        }
        return true;
    }

    private void suggestCallArguments(String string, String string2, String string3, ArrayList<LexerToken> arrayList, int n, SqlEarley sqlEarley, Matrix matrix, Set<String> set, InsightableOracleDatabase insightableOracleDatabase) {
        if (set.contains(string3)) {
            Parser.EarleyCell earleyCell;
            int n2;
            int n3 = n2 = n - 10 > 0 ? n - 10 : 0;
            while (!(n2 >= n || (earleyCell = matrix.get(n2, n)) != null && this.foundMatchedRule(string, string2, arrayList, sqlEarley, insightableOracleDatabase, n2, (Cell)earleyCell) || (earleyCell = matrix.get(n2, n - 1)) != null && this.foundMatchedRule(string, string2, arrayList, sqlEarley, insightableOracleDatabase, n2, (Cell)earleyCell))) {
                ++n2;
            }
        }
    }

    private boolean foundMatchedRule(String string, String string2, ArrayList<LexerToken> arrayList, SqlEarley sqlEarley, InsightableOracleDatabase insightableOracleDatabase, int n, Cell cell) {
        for (int i = 0; i < cell.size(); ++i) {
            String string3;
            int n2 = cell.getRule(i);
            String string4 = sqlEarley.allSymbols[sqlEarley.rules[n2].head];
            if (!string.equals(string4) || !string2.equals(string3 = sqlEarley.allSymbols[sqlEarley.rules[n2].rhs[0]])) continue;
            String string5 = arrayList.get((int)n).content.toUpperCase();
            String string6 = arrayList.get((int)(n + 1)).content;
            String string7 = null;
            try {
                if (".".equals(string6)) {
                    string7 = string5;
                    string5 = arrayList.get((int)(n + 2)).content.toUpperCase();
                }
                if (".".equals(string6 = arrayList.get((int)(n + 3)).content)) {
                    string7 = string5;
                    string5 = arrayList.get((int)(n + 4)).content.toUpperCase();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (string7 == null) {
                boolean bl = false;
                for (LexerToken lexerToken : arrayList) {
                    if ("BODY".equalsIgnoreCase(lexerToken.content)) {
                        bl = true;
                        continue;
                    }
                    if (!bl) continue;
                    string7 = lexerToken.content.toUpperCase();
                    break;
                }
            }
            insightableOracleDatabase.prepareArgumentsProc(string7, string5);
            return true;
        }
        return false;
    }

    private Matrix fixCode(ArrayList<LexerToken> arrayList, int n, SqlEarley sqlEarley, Matrix matrix, Set<String> set, Cell cell) {
        if (this.identifierPrefix.length() > 0) {
            if (arrayList.size() <= n) {
                return matrix;
            }
            if (trace) {
                System.out.println("deleted an identifier");
            }
            arrayList.remove(n);
            matrix = new Matrix((Parser)sqlEarley);
            sqlEarley.parse(arrayList, (Matriceable)matrix);
            cell = matrix.get(0, arrayList.size());
        }
        if (!this.isLegitimate(cell)) {
            int n2 = arrayList.size();
            this.fixCode(arrayList, n, set);
            matrix = new Matrix((Parser)sqlEarley);
            sqlEarley.parse(arrayList, (Matriceable)matrix);
            cell = matrix.get(0, arrayList.size());
            if (!this.isLegitimate(cell)) {
                Set<Long> set2 = CompletionInsight.predict(n + (arrayList.size() - n2), sqlEarley, matrix);
                TreeSet<String> treeSet = new TreeSet<String>();
                for (long l : set2) {
                    treeSet.add(SqlEarley.getInstance().allSymbols[Service.lX((long)l)]);
                }
                this.fixCode(arrayList, n + (arrayList.size() - n2), treeSet);
                matrix = new Matrix((Parser)sqlEarley);
                sqlEarley.parse(arrayList, (Matriceable)matrix);
            }
        }
        return matrix;
    }

    private void fixCode(ArrayList<LexerToken> arrayList, int n, Set<String> set) {
        LexerToken lexerToken = new LexerToken((CharSequence)"du$mY", -2, -1, Token.IDENTIFIER);
        LexerToken lexerToken2 = new LexerToken((CharSequence)"=", -2, -1, Token.OPERATION);
        LexerToken lexerToken3 = new LexerToken((CharSequence)")", -2, -1, Token.OPERATION);
        LexerToken lexerToken4 = new LexerToken((CharSequence)";", -2, -1, Token.OPERATION);
        if (set.contains("';'")) {
            this.insertTokens(arrayList, n, new LexerToken[]{lexerToken4});
            return;
        }
        if (this.prior != null && ("(".equals(this.prior.content) || arrayList.size() > 0 && arrayList.get((int)(arrayList.size() - 1)).type == Token.IDENTIFIER) && set.contains("')'")) {
            this.insertTokens(arrayList, n, new LexerToken[]{lexerToken3});
            return;
        }
        for (String string : set) {
            if (string.equals("condition") || string.startsWith("update_set_clause")) {
                this.insertTokens(arrayList, n, new LexerToken[]{lexerToken, lexerToken2, lexerToken});
                return;
            }
            if (!string.equals("'='")) continue;
            this.insertTokens(arrayList, n, new LexerToken[]{lexerToken2, lexerToken});
            return;
        }
        this.insertTokens(arrayList, n, new LexerToken[]{lexerToken});
        set.add("identifier");
    }

    private void insertTokens(ArrayList<LexerToken> arrayList, int n, LexerToken[] lexerTokenArray) {
        for (LexerToken lexerToken : lexerTokenArray) {
            arrayList.add(n++, lexerToken);
            if (!trace) continue;
            System.out.println("inserted " + lexerToken.content);
        }
    }

    private Map<String, String> parseRecord(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string.indexOf("RECORD") < 0) {
            return hashMap;
        }
        int n = string.indexOf(40);
        if (n < 0) {
            return hashMap;
        }
        int n2 = string.lastIndexOf(41);
        if (n2 < 0) {
            return hashMap;
        }
        string = string.substring(n + 1, n2 - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n3 = string2.indexOf(32);
            if (n3 < 0) continue;
            String string3 = string2.substring(0, n3);
            String string4 = string2.substring(n3 + 1).toUpperCase().trim();
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    private boolean isLegitimate(Cell cell) {
        if (cell == null) {
            return false;
        }
        for (int i = 0; i < cell.size(); ++i) {
            int n = cell.getRule(i);
            int n2 = cell.getPosition(i);
            if (n2 != SqlEarley.getInstance().rules[n].rhs.length) continue;
            return true;
        }
        return false;
    }

    public static Set<Long> predict(int n, SqlEarley sqlEarley, Matrix matrix) {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (int i = 0; i <= n; ++i) {
            Parser.EarleyCell earleyCell = matrix.get(i, n);
            if (earleyCell == null) continue;
            for (int j = 0; j < earleyCell.size(); ++j) {
                int n2;
                int n3 = earleyCell.getRule(j);
                int n4 = earleyCell.getPosition(j);
                if (n4 >= sqlEarley.rules[n3].rhs.length || (n2 = sqlEarley.rules[n3].head) == SqlEarley.getInstance().decl_id && sqlEarley.rules[n3].rhs[0] != SqlEarley.getInstance().identifier) continue;
                hashSet.add(Service.lPair((int)sqlEarley.rules[n3].rhs[n4], (int)CompletionInsight.nonAuxHead(n2)));
            }
        }
        return hashSet;
    }

    private static int nonAuxHead(int n) {
        SqlEarley sqlEarley = SqlEarley.getInstance();
        String string = sqlEarley.allSymbols[n];
        if (string.indexOf(91) == -1) {
            return n;
        }
        for (Parser.Tuple tuple : sqlEarley.rules) {
            for (int n2 : tuple.rhs) {
                if (n2 != n) continue;
                return tuple.head;
            }
        }
        return n;
    }

    private void refreshSuggestedItemsList(Set<SuggestedItem> set) {
        SuggestedItem[] suggestedItemArray = new SuggestedItem[set.size()];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (SuggestedItem suggestedItem : set) {
            boolean bl = false;
            String string = suggestedItem.getName();
            suggestedItemArray[n] = new SuggestedItem(suggestedItem, suggestedItem.getPrefixLength());
            suggestedItemArray[n++].doc = suggestedItem.doc;
            if ("COLUMN".equalsIgnoreCase(suggestedItem.getType())) {
                ++n2;
                continue;
            }
            if (!"TABLE".equalsIgnoreCase(suggestedItem.getType()) && !"VIEW".equalsIgnoreCase(suggestedItem.getType())) continue;
            ++n3;
        }
        this._lastLookup = new DBListInsightData(this);
        this._lastLookup.setData(suggestedItemArray);
        if (InsightTest.isTest) {
            return;
        }
        if (n2 > 1 || n3 > 1) {
            this._view.setSelectionMode(2);
        } else {
            this._view.setSelectionMode(0);
        }
        this._view.setData((InsightData)this._lastLookup);
        this._view.revalidate();
    }

    private void addSelectFrom(Collection<SuggestedItem> collection, String string) {
        if (!"SELECT * FROM".startsWith(string.toUpperCase())) {
            return;
        }
        SuggestedItem suggestedItem = new SuggestedItem("KEYWORD", "", "SELECT * FROM");
        if (!collection.contains(suggestedItem)) {
            collection.add(suggestedItem);
        }
    }

    private Map<String, String> mapString2String(List<LexerToken> list, Map<ParseNode, ParseNode> map) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (ParseNode parseNode : map.keySet()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = parseNode.from; i < parseNode.to; ++i) {
                stringBuffer.append(list.get((int)i).content);
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            ParseNode parseNode2 = map.get(parseNode);
            for (int i = parseNode2.from; i < parseNode2.to; ++i) {
                stringBuffer2.append(list.get((int)i).content);
            }
            treeMap.put(stringBuffer.toString(), stringBuffer2.toString());
        }
        return treeMap;
    }

    private Set<SuggestedItem> suggestedKeywords(Set<String> set, String string) {
        TreeSet<SuggestedItem> treeSet = new TreeSet<SuggestedItem>();
        String string2 = "'" + string;
        SuggestedItem[] suggestedItemArray = set.iterator();
        while (suggestedItemArray.hasNext()) {
            SuggestedItem suggestedItem;
            SuggestedItem[] suggestedItemArray2 = suggestedItemArray.next();
            if (!suggestedItemArray2.startsWith(string2) || suggestedItemArray2.startsWith("xml") || treeSet.contains(suggestedItem = new SuggestedItem("KEYWORD", null, suggestedItemArray2.substring(1, suggestedItemArray2.length() - 1)))) continue;
            treeSet.add(suggestedItem);
        }
        for (SuggestedItem suggestedItem : suggestedItemArray = new SuggestedItem[]{new SuggestedItem("KEYWORD", null, "SQL"), new SuggestedItem("KEYWORD", null, "NEXTVAL"), new SuggestedItem("KEYWORD", null, "CURRVAL"), new SuggestedItem("KEYWORD", null, "*")}) {
            treeSet.remove(suggestedItem);
        }
        if (treeSet.size() > 3) {
            for (SuggestedItem suggestedItem : suggestedItemArray = new SuggestedItem[]{new SuggestedItem("KEYWORD", null, "%"), new SuggestedItem("KEYWORD", null, "("), new SuggestedItem("KEYWORD", null, "."), new SuggestedItem("KEYWORD", null, ":"), new SuggestedItem("KEYWORD", null, ";"), new SuggestedItem("KEYWORD", null, "@")}) {
                treeSet.remove(suggestedItem);
            }
        }
        if (treeSet.size() > 5) {
            treeSet.clear();
        }
        return treeSet;
    }

    private Set<SuggestedItem> suggestedSnippets(Set<Long> set, String string, LexerToken lexerToken, Matrix matrix, int n) {
        TreeSet<SuggestedItem> treeSet = new TreeSet<SuggestedItem>();
        if (string.length() == 0) {
            return treeSet;
        }
        try {
            treeSet.addAll(CompletionInsight.addTemplates(set, string, lexerToken, matrix, n - 1));
        }
        catch (Error error) {
            oracle.javatools.util.Log.error((String)("Failed to add templates: " + error.getMessage()));
        }
        treeSet.addAll(SqlHistory.addTemplates(set, string, lexerToken, matrix, n - 1));
        try {
            treeSet.addAll(this.legacyTemplates(string));
        }
        catch (Error error) {
            oracle.javatools.util.Log.error((String)"Failed to init legacy templates; OK if running InsightTest");
        }
        for (long l : set) {
            int n2 = Service.lX((long)l);
            if (n2 != IdentifiersDb.instance.table_reference && n2 != IdentifiersDb.instance.subquery) continue;
            this.addSelectFrom(treeSet, string);
            break;
        }
        return treeSet;
    }

    private List<SuggestedItem> legacyTemplates(String string) {
        Map map = CodeTemplateUtil.getModel();
        LinkedList<SuggestedItem> linkedList = new LinkedList<SuggestedItem>();
        for (String string2 : map.keySet()) {
            Object object;
            String string3;
            if (tSuggestions <= linkedList.size() || (string3 = (String)map.get(string2)) == null || string3.length() == 0 || !string2.toUpperCase().startsWith(string.toUpperCase()) && !string3.toUpperCase().startsWith(string.toUpperCase())) continue;
            StringBuffer stringBuffer = new StringBuffer(string3);
            Matcher matcher = CodeTemplateUtil._tmpVariablePattern.matcher(string3);
            int n = 0;
            while (matcher.find() && (n = stringBuffer.indexOf((String)(object = matcher.group()), n)) >= 0) {
                if (n > 0 && stringBuffer.charAt(n - 1) == '\\') {
                    stringBuffer.deleteCharAt(n - 1);
                    continue;
                }
                String string4 = CodeTemplateUtil.computeVariable(null, (String)object);
                if (string4 == null || string4.equals(object)) continue;
                stringBuffer.replace(n, n + ((String)object).length(), string4);
                n += string4.length();
            }
            string3 = stringBuffer.toString();
            object = new SuggestedItem("TEMPLATE", null, string3);
            object.setPrefixLength(string.length());
            linkedList.add((SuggestedItem)object);
        }
        if (linkedList.size() == 3 && tSuggestions == 3) {
            linkedList.add(new SuggestedItem("TEMPLATE", null, "..."));
        }
        return linkedList;
    }

    private Set<SuggestedItem> suggestedBindVars(int n, ParseNode parseNode, Set<String> set, String string) {
        TreeSet<SuggestedItem> treeSet = new TreeSet<SuggestedItem>();
        if (!set.contains("identifier")) {
            return treeSet;
        }
        ParseNode parseNode2 = parseNode.descendant(n, n, IdentifiersDb.instance.bind_var);
        if (parseNode2 == null) {
            return treeSet;
        }
        for (String string2 : this.bindVars) {
            if (!string2.toUpperCase().startsWith(string.toUpperCase())) continue;
            treeSet.add(new SuggestedItem("TEMPLATE", null, string2));
        }
        return treeSet;
    }

    static int filterOutComments(int n, List<LexerToken> list, List<LexerToken> list2) {
        int n2 = 0;
        int n3 = -1;
        for (LexerToken lexerToken : list) {
            if (!(lexerToken.begin >= n || n >= lexerToken.end && lexerToken.end >= 0 || lexerToken.type != Token.COMMENT && lexerToken.type != Token.LINE_COMMENT && lexerToken.type != Token.QUOTED_STRING)) {
                return -1;
            }
            if (n == lexerToken.end && lexerToken.type == Token.LINE_COMMENT) {
                return -1;
            }
            if ((lexerToken.begin <= n && n < lexerToken.end || n == lexerToken.end && lexerToken.type == Token.IDENTIFIER) && n3 == -1) {
                n3 = n2;
            }
            if (lexerToken.type == Token.DQUOTED_STRING && lexerToken.begin < n && n <= lexerToken.end) {
                if (lexerToken.content.toUpperCase().contains("FROM") || lexerToken.content.toUpperCase().contains("WHERE")) {
                    return -2;
                }
                if (n3 == -1) {
                    n3 = n2;
                }
            }
            if (lexerToken.type == Token.WS || lexerToken.type == Token.COMMENT || lexerToken.type == Token.LINE_COMMENT) continue;
            list2.add(lexerToken);
            ++n2;
        }
        if (n3 == -1) {
            n3 = list2.size();
        }
        return n3;
    }

    static String suggestPlsqlDoc(String string, int n, List<LexerToken> list) {
        for (LexerToken lexerToken : list) {
            if (lexerToken.begin > n || n >= lexerToken.end && lexerToken.end >= 0) continue;
            if (lexerToken.type == Token.LINE_COMMENT || lexerToken.type == Token.QUOTED_STRING) {
                return null;
            }
            int n2 = lexerToken.begin + 2;
            int n3 = string.indexOf(40, n2);
            if (n3 < 0) {
                return null;
            }
            int n4 = string.indexOf(41, n2);
            if (n4 < 0) {
                return null;
            }
            String string2 = string.substring(n2, n3);
            if (60 < string2.length()) {
                return null;
            }
            boolean bl = string2.toLowerCase().contains("function");
            boolean bl2 = string2.toLowerCase().contains("procedure");
            if (!bl && !bl2) {
                return null;
            }
            String string3 = string.substring(n3 + 1, n4);
            string3 = string3.replace("\n", "");
            string3 = string3.replace("\r", "");
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            Object object = "";
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                object = (String)object + "\n    @param " + string4;
            }
            if (bl) {
                object = (String)object + "\n    @return ";
            }
            return "\n    " + (String)object + "\n    */";
        }
        return null;
    }

    public static Pair<ParseNode, ParseNode> findTableAlias(ParseNode parseNode) {
        if (!(parseNode.contains(IdentifiersDb.instance.table_reference) || parseNode.contains(IdentifiersDb.instance.cartesian_product) || parseNode.contains(IdentifiersDb.instance.aliased_dml_table_expression_clause))) {
            return null;
        }
        Pair pair = null;
        if (parseNode.children().size() == 0 || parseNode.children().size() == 3) {
            pair = new Pair((Object)parseNode, (Object)parseNode);
        } else if (parseNode.children().size() == 2) {
            ParseNode parseNode2 = null;
            ParseNode parseNode3 = null;
            for (ParseNode parseNode4 : parseNode.children()) {
                if (parseNode4.contains(IdentifiersDb.instance.query_table_expression) || parseNode4.contains(IdentifiersDb.instance.dml_table_expression_clause)) {
                    parseNode3 = parseNode4;
                    continue;
                }
                parseNode2 = parseNode4;
            }
            if (parseNode2 != null && parseNode3 != null) {
                pair = new Pair(parseNode2, parseNode3);
            }
        }
        return pair;
    }

    private SuggestedItem createDatabaseDataItem(List<LexerToken> list, ParseNode parseNode, ParseNode parseNode2) {
        LexerToken lexerToken = list.get(parseNode2.from);
        if (lexerToken.begin > 0) {
            ParseNode parseNode3 = parseNode2.parent();
            if (parseNode3 != null) {
                if (parseNode3.contains(IdentifiersDb.instance.prm_spec) || parseNode3.contains(IdentifiersDb.instance.object_d)) {
                    for (ParseNode parseNode4 : parseNode3.children()) {
                        if (!parseNode4.contains(IdentifiersDb.instance.object_d_rhs) && !parseNode4.contains(IdentifiersDb.instance.unconstrained_type) && !parseNode4.contains(IdentifiersDb.instance.unconstrained_type_wo_datetime)) continue;
                        String string = list.get((int)parseNode4.from).content.toUpperCase();
                        if (!(string.indexOf("CHAR") >= 0 || "INTEGER".equals(string) || "NUMBER".equals(string) || "DATE".equals(string) || "TIMESTAMP".equals(string) || "BOOLEAN".equals(string))) {
                            string = "USER DEFINED";
                        }
                        return new SuggestedItem(string, null, lexerToken.content);
                    }
                }
                if (parseNode3.contains(IdentifiersDb.instance.subprg_spec)) {
                    LexerToken lexerToken2 = list.get(parseNode2.from - 1);
                    if ("function".equalsIgnoreCase(lexerToken2.content)) {
                        return new SuggestedItem("FUNCTION", null, lexerToken.content);
                    }
                    if ("procedure".equalsIgnoreCase(lexerToken2.content)) {
                        return new SuggestedItem("PROCEDURE", null, lexerToken.content);
                    }
                }
            } else {
                return new SuggestedItem("USER DEFINED", null, lexerToken.content);
            }
        }
        return null;
    }

    public InsightData updateInsightData(BasicEditorPane basicEditorPane, InsightData insightData) {
        return null;
    }

    public ListInsightView getInsightView() {
        return this._view;
    }

    private List<SuggestedItem> joinConditions(Set<SuggestedItem> set, InsightableOracleDatabase insightableOracleDatabase) {
        LinkedList<SuggestedItem> linkedList = new LinkedList<SuggestedItem>();
        int n = 0;
        block0: for (SuggestedItem suggestedItem : set) {
            String string = suggestedItem.getName();
            int n2 = string.indexOf(46);
            if (n2 <= 0 || !"COLUMN".equals(suggestedItem.getType()) || "DATE".equals(suggestedItem.columnType)) continue;
            for (SuggestedItem suggestedItem2 : set) {
                String string2 = suggestedItem2.getName();
                int n3 = string2.indexOf(46);
                if (n3 <= 0 || suggestedItem.compareTo(suggestedItem2) <= 0 || !"COLUMN".equals(suggestedItem.getType()) || !suggestedItem2.columnType.equals(suggestedItem.columnType) || !this.colNamesMatch(string, string2, insightableOracleDatabase)) continue;
                linkedList.add(new SuggestedItem("EQUIJOIN CONDITION", null, string + " = " + string2));
                if (++n <= 50) continue;
                break block0;
            }
        }
        return linkedList;
    }

    private boolean colNamesMatch(String string, String string2, InsightableOracleDatabase insightableOracleDatabase) {
        int n = string.indexOf(46);
        int n2 = string2.indexOf(46);
        String string3 = string.substring(n + 1).toUpperCase();
        String string4 = string2.substring(n2 + 1).toUpperCase();
        if (string3 == null) {
            return false;
        }
        if (string3.equals(string4)) {
            return true;
        }
        String string5 = insightableOracleDatabase.getTable(string.substring(0, n)).toUpperCase();
        String string6 = insightableOracleDatabase.getTable(string2.substring(0, n2)).toUpperCase();
        return string3.startsWith(string5) && string4.equals(string3 + "_ID") || string3.startsWith(string5) && string4.equals(string3 + "_NAME") || string4.startsWith(string6) && string3.equals(string4 + "_ID") || string4.startsWith(string6) && string3.equals(string4 + "_NAME") || this.tabColNamesMatch(string3, string5) && string3.endsWith("_ID") && this.tabColNamesMatch(string4, string6) && string4.endsWith("_ID") || this.tabColNamesMatch(string3, string5) && string3.endsWith("_NAME") && this.tabColNamesMatch(string4, string6) && string4.endsWith("_NAME");
    }

    private boolean tabColNamesMatch(String string, String string2) {
        if (string2.length() < 5 || string.length() < 5) {
            return false;
        }
        for (int i = 0; i < string2.length() - 5; ++i) {
            String string3 = string2.substring(i, i + 5);
            if (!string.contains(string3)) continue;
            return true;
        }
        return false;
    }

    public static List<SuggestedItem> addTemplates(Set<Long> set, String string, LexerToken lexerToken, Matrix matrix, int n) {
        Collection<Comparable> collection;
        HashSet<Substr> hashSet = new HashSet<Substr>();
        Substr.listSuggestions(set, (String)string, null, (Map)HarvestDoc.getTemplates(), hashSet, (int)suggestions);
        if (lexerToken != null && lexerToken.type == Token.IDENTIFIER) {
            collection = CompletionInsight.predict(n, SqlEarley.getInstance(), matrix);
            Substr.listSuggestions(collection, (String)lexerToken.content, (String)string.toLowerCase(), (Map)HarvestDoc.getTemplates(), hashSet, (int)suggestions);
        }
        if ((collection = SuggestedItem.addSuggestions(hashSet, "SNIPPET")).size() == 3 && suggestions == 3) {
            collection.add(new SuggestedItem("SNIPPET", null, "..."));
        }
        return collection;
    }

    public void semanticAnalysis(String string) throws Exception {
        this.iterTables = new HashMap<String, List<String>>();
        this.iterColumns = new HashMap<String, List<String>>();
        if (programInstance == null) {
            programInstance = new SqlProgram(Service.readFile(CompletionInsight.class, (String)"/oracle/dbtools/raptor/insight/insight.prg"));
        }
        programInstance.run(string, null, (Object)this);
    }

    void iter_tables(Parsed parsed, Map<String, ParseNode> map) {
        String string = map.get("table").content(parsed.getSrc());
        String string2 = map.get("iter").content(parsed.getSrc());
        List<String> list = this.iterTables.get(string2);
        if (list == null) {
            list = new LinkedList<String>();
            this.iterTables.put(string2, list);
        }
        list.add(string);
    }

    void iter_columns(Parsed parsed, Map<String, ParseNode> map) {
        String string = map.get("col").content(parsed.getSrc());
        String string2 = map.get("iter").content(parsed.getSrc());
        List<String> list = this.iterColumns.get(string2);
        if (list == null) {
            list = new LinkedList<String>();
            this.iterColumns.put(string2, list);
        }
        list.add(string);
    }

    static {
        try {
            Properties properties = System.getProperties();
            Object object = properties.get("sqldev.insight.timeout");
            if (object != null) {
                if (object instanceof String) {
                    timeout = Integer.parseInt((String)object);
                }
                System.out.println("pr.getProperty(\"sqldev.insight.timeout\")=" + timeout);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        firstInvocation = true;
        tSuggestions = 3;
        suggestions = 3;
        programInstance = null;
    }

    class InsightThread
    extends Thread {
        public InsightThread(String string) {
            super(string);
        }

        @Override
        public void run() {
            CompletionInsight.this.startCaretPosition = CompletionInsight.this.getCaretPosition();
            try {
                HashSet<SuggestedItem> hashSet = new HashSet<SuggestedItem>();
                SqlCompleter sqlCompleter = new SqlCompleter(ChameleonConnection.getConnection((String)CompletionInsight.this.getConnName()));
                CompletionList completionList = sqlCompleter.complete(CompletionInsight.this.parser.text, CompletionInsight.this.startCaretPosition);
                CompletionInsight.this.identifierPrefix = "";
                if (completionList.prefix != null) {
                    CompletionInsight.this.identifierPrefix = completionList.prefix.content;
                }
                for (CompletionItem completionItem : completionList.entries) {
                    String string = "N/A";
                    if (completionItem.type == CompletionItem.Type.JAVA_PACKAGE || completionItem.type == CompletionItem.Type.PACKAGE || completionItem.type == CompletionItem.Type.JAVA_CLASS) {
                        string = "PACKAGE";
                    } else if (completionItem.type == CompletionItem.Type.JAVA_METHOD || completionItem.type == CompletionItem.Type.FUNCTION) {
                        string = "FUNCTION";
                    } else if (completionItem.type == CompletionItem.Type.PROCEDURE) {
                        string = "PROCEDURE";
                    } else if (completionItem.type == CompletionItem.Type.ARGUMENT) {
                        string = "ARGUMENT";
                    } else if (completionItem.type == CompletionItem.Type.CONDITION) {
                        string = "EQUIJOIN CONDITION";
                    } else if (completionItem.type == CompletionItem.Type.COLUMN) {
                        string = "COLUMN";
                    } else if (completionItem.type == CompletionItem.Type.TABLE) {
                        string = "TABLE";
                    } else if (completionItem.type == CompletionItem.Type.VIEW) {
                        string = "VIEW";
                    } else if (completionItem.type == CompletionItem.Type.KEYWORD) {
                        string = "KEYWORD";
                    } else if (completionItem.type == CompletionItem.Type.USER) {
                        string = "SCHEMA";
                    } else if (completionItem.type == CompletionItem.Type.SEQUENCE) {
                        string = "SEQUENCE";
                    } else if (completionItem.type == CompletionItem.Type.SYNONYM) {
                        string = "SYNONYM";
                    } else if (completionItem.type == CompletionItem.Type.PARTIALLY_RECOGNIZED_SYNTAX) continue;
                    SuggestedItem suggestedItem = new SuggestedItem(string, null, completionItem.entry);
                    suggestedItem.highlight = CompletionInsight.this.identifierPrefix;
                    hashSet.add(suggestedItem);
                }
                CompletionInsight.this.refreshSuggestedItemsList(hashSet);
                if (!CompletionInsight.this.isKeywordsOnly(hashSet)) {
                    return;
                }
                hashSet.addAll(CompletionInsight.this.legacyTemplates(CompletionInsight.this.identifierPrefix));
                CompletionInsight.this.refreshSuggestedItemsList(hashSet);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private final class DBListInsightView
    extends ListInsightView {
        DBListInsightView() {
            final ListSelectionModel listSelectionModel = this.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    listSelectionEvent.getFirstIndex();
                    if (listSelectionModel.isSelectionEmpty()) {
                        CompletionInsight.this.selectionOrder.clear();
                        return;
                    }
                    int n = listSelectionModel.getMinSelectionIndex();
                    int n2 = listSelectionModel.getMaxSelectionIndex();
                    for (int i = n; i <= n2; ++i) {
                        if (listSelectionModel.isSelectedIndex(i)) {
                            if (CompletionInsight.this.selectionOrder.contains(i)) continue;
                            CompletionInsight.this.selectionOrder.add(i);
                            continue;
                        }
                        CompletionInsight.this.selectionOrder.remove(new Integer(i));
                    }
                }
            });
        }

        protected ListModel getListModel(ListInsightData listInsightData) {
            return listInsightData.getListModel();
        }

        public void selectDefault() {
            if (!CompletionInsight.this.wasAutoInvoked) {
                super.selectDefault();
            }
        }

        public boolean complete(Insight insight) {
            int n = this.getSelectedIndex();
            ListModel listModel = this.getModel();
            if (n < 0 || n >= listModel.getSize()) {
                return false;
            }
            return super.complete(insight);
        }
    }
}

