/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.insight.UsersCache;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.insight.DBListInsightData;
import oracle.dbtools.raptor.insight.InsightCache;
import oracle.dbtools.raptor.insight.InsightableOracleDatabase;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.util.Service;

public class InsightTest {
    static Integer singleTest = null;
    static String testUrl = "jdbc:oracle:thin:@localhost:1521/xe,hr,hr";
    private static boolean raiselimit;
    private static int maxTestNo;
    private static Set<Integer> failedTests;
    private static CompletionInsight insight;
    Set<RuleTuple> rules = this.insightRules();
    Earley earley = new Earley(this.rules){

        protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
            LexerToken lexerToken = list.get(n);
            return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER || n2 == this.identifier && lexerToken.type == Token.DQUOTED_STRING || n2 == this.identifier && lexerToken.type == Token.BQUOTED_STRING;
        }
    };
    private int output;
    private int assertion;
    private int query;
    private int comment;
    private int marker;
    private int prompt;
    private int dotted_name;
    private int sql_prefix;
    private int sql_postfix;
    static boolean isTest;
    private static Map<Integer, Long> timeStats;

    public InsightTest() {
        this.output = (Integer)this.earley.symbolIndexes.get("output");
        this.assertion = (Integer)this.earley.symbolIndexes.get("assertion");
        this.query = (Integer)this.earley.symbolIndexes.get("query");
        this.comment = (Integer)this.earley.symbolIndexes.get("comment");
        this.marker = (Integer)this.earley.symbolIndexes.get("marker");
        this.prompt = (Integer)this.earley.symbolIndexes.get("cue");
        this.dotted_name = (Integer)this.earley.symbolIndexes.get("dotted_name");
        this.sql_prefix = (Integer)this.earley.symbolIndexes.get("sql_fragment");
        this.sql_postfix = (Integer)this.earley.symbolIndexes.get("sql_fragment");
    }

    public static void main(String[] stringArray) throws Exception {
        new InsightTest().test();
    }

    void test() throws Exception {
        isTest = true;
        BackgroundParser backgroundParser = new BackgroundParser();
        insight = new CompletionInsight(testUrl, backgroundParser);
        UsersCache.fillIn((String)testUrl);
        if (InsightableOracleDatabase.mode == InsightableOracleDatabase.Mode.CACHE_UNION || InsightableOracleDatabase.mode == InsightableOracleDatabase.Mode.CACHE_PARALLEL) {
            InsightCache.fillIn(testUrl);
        }
        String string = Service.readFile((String)"db/src/oracle/dbtools/raptor/insight/insight.test");
        List list = LexerToken.parse((String)string, (String)"`");
        Matrix matrix = new Matrix((Parser)this.earley);
        this.earley.parse(list, (Matriceable)matrix);
        SyntaxError syntaxError = SyntaxError.checkSyntax((String)string, (String[])new String[]{"atest"}, (List)list, (Earley)this.earley, (Matrix)matrix);
        if (syntaxError != null) {
            System.out.println("Syntax Error");
            System.out.println("at line#" + syntaxError.line);
            System.out.println(syntaxError.code);
            System.out.println(syntaxError.marker);
            System.out.println("Expected:  ");
            for (String string2 : syntaxError.getSuggestions()) {
                System.out.print(string2 + ",");
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode parseNode = this.earley.forest(list, matrix);
        long l = System.currentTimeMillis();
        this.atest(parseNode, list, string);
        long l2 = System.currentTimeMillis();
        System.out.println("Total test time = " + (l2 - l));
        System.out.println(InsightTest.topNtimings());
        if (failedTests.size() == 0) {
            System.out.println("*** ALL " + maxTestNo + " TESTS are OK *** ---> ");
        } else {
            System.out.println("*** TEST FAILED! *** ---> " + failedTests.toString());
        }
    }

    private Set<RuleTuple> insightRules() {
        try {
            String string = Service.readFile(InsightTest.class, (String)"insight.grammar");
            List list = LexerToken.parse((String)string, (boolean)false, (int)49);
            ParseNode parseNode = Grammar.parseGrammarFile((List)list, (String)string);
            TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
            Grammar.grammar((ParseNode)parseNode, (List)list, treeSet);
            return treeSet;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)"VT: failed to init grammar for insight test");
        }
    }

    private static String topNtimings() {
        StringBuilder stringBuilder = new StringBuilder("Top 5 timings:\n");
        TreeMap<Long, Integer> treeMap = new TreeMap<Long, Integer>();
        for (int n : timeStats.keySet()) {
            long l = timeStats.get(n);
            if (treeMap.size() < 6) {
                treeMap.put(l, n);
                continue;
            }
            Long l2 = (Long)treeMap.firstKey();
            if (l2 == null || l2 >= l) continue;
            treeMap.remove(l2);
            treeMap.put(l, n);
        }
        Iterator<Integer> iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            long l = (Long)((Object)iterator.next());
            stringBuilder.append("Test#" + treeMap.get(l) + "=" + l + "\n");
        }
        return stringBuilder.toString();
    }

    private void atest(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        if (parseNode.contains(this.assertion)) {
            if (singleTest != null && singleTest != maxTestNo) {
                return;
            }
            System.out.print("TEST#" + maxTestNo + " -> ");
            if (this.assertion(parseNode, list, string, maxTestNo)) {
                System.out.println("OK \n");
            } else {
                System.out.println("*** Failed ***\n");
            }
            return;
        }
        if (parseNode.contains(this.output)) {
            if (singleTest != null && singleTest != maxTestNo) {
                return;
            }
            Iterator iterator = parseNode.children().iterator();
            if (iterator.hasNext()) {
                ParseNode parseNode2 = (ParseNode)iterator.next();
                System.out.println("TEST#" + maxTestNo + " ->\n" + this.query(parseNode2, list, string));
                return;
            }
            return;
        }
        if (parseNode.contains(this.comment)) {
            this.comment(parseNode, list, string);
            return;
        }
        for (ParseNode parseNode3 : parseNode.children()) {
            this.atest(parseNode3, list, string);
        }
    }

    private boolean assertion(ParseNode parseNode, List<LexerToken> list, String string, int n) {
        List<String> list2 = null;
        Map<String, Boolean> map = null;
        for (Object object : parseNode.children()) {
            if (object.contains(this.query)) {
                list2 = this.query((ParseNode)object, list, string);
                continue;
            }
            if (!object.contains(this.prompt)) continue;
            map = this.prompt((ParseNode)object, list, string);
        }
        for (Object object : map.keySet()) {
            boolean bl = (Boolean)map.get(object);
            Object object2 = object;
            if (((String)object2).charAt(0) != '\"' && ((String)object2).charAt(((String)object2).length() - 1) != '\"') {
                object2 = ((String)object2).toLowerCase();
            } else {
                object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                object2 = ((String)object2).replace("\r", "");
            }
            boolean bl2 = false;
            for (String string2 : list2) {
                String string3 = string2;
                if (string3.charAt(0) != '\"' && string3.charAt(string3.length() - 1) != '\"') {
                    string3 = string3.toLowerCase();
                } else {
                    string3 = string3.substring(1, string3.length() - 1);
                    string3 = string3.replace("\r", "");
                }
                if (!((String)object2).equals(string3)) continue;
                bl2 = true;
                break;
            }
            if ((bl2 || !bl) && (!bl2 || bl)) continue;
            System.out.println((bl ? "no" : "unexpected") + " match for " + (String)object);
            failedTests.add(n);
            return false;
        }
        return true;
    }

    private Map<String, Boolean> prompt(ParseNode parseNode, List<LexerToken> list, String string) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (parseNode.contains(this.dotted_name)) {
            String string2 = parseNode.content(list);
            hashMap.put(string2, true);
            return hashMap;
        }
        String string3 = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(this.prompt) && !parseNode2.contains(this.dotted_name)) {
                hashMap.putAll(this.prompt(parseNode2, list, string));
                continue;
            }
            String string4 = parseNode2.content(list);
            if ("-".equals(string3)) {
                hashMap.put(string4, false);
            } else if (!"-".equals(string4)) {
                hashMap.put(string4, true);
            }
            string3 = string4;
        }
        return hashMap;
    }

    private List<String> query(ParseNode parseNode, List<LexerToken> list, String string) {
        String string2 = null;
        String string3 = "";
        int n = -1;
        ParseNode parseNode2 = null;
        for (ParseNode parseNode3 : parseNode.children()) {
            if (parseNode3.contains(this.marker)) {
                if (string2 == null) {
                    string2 = "";
                }
                n = string2.length() + (parseNode2 == null || list.get((int)parseNode3.from).begin == list.get((int)(parseNode2.to - 1)).end ? 0 : 1);
            }
            if (parseNode3.contains(this.sql_prefix) || parseNode3.contains(this.sql_postfix)) {
                if (n == -1) {
                    string2 = this.sql_fragment(parseNode3, list, string);
                } else {
                    string3 = this.sql_fragment(parseNode3, list, string);
                }
            }
            parseNode2 = parseNode3;
        }
        return this.output(string2 + "  " + string3, n);
    }

    private List<String> output(String string, int n) {
        long l = System.currentTimeMillis();
        InsightTest.insight.parser.text = string;
        InsightTest.insight.parser.parse();
        InsightTest.insight.raiselimit = raiselimit;
        DBListInsightData dBListInsightData = InsightTest.insight._lastLookup;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Object object : dBListInsightData.getMatchingData()) {
            linkedList.add(object.toString());
        }
        long l2 = System.currentTimeMillis();
        timeStats.put(maxTestNo, l2 - l);
        return linkedList;
    }

    private String sql_fragment(ParseNode parseNode, List<LexerToken> list, String string) {
        if (parseNode.from + 1 == parseNode.to) {
            String string2 = list.get((int)parseNode.from).content;
            if (string2.charAt(0) == '\"' || string2.charAt(0) == '`') {
                string2 = string2.substring(1, string2.length() - 1);
            }
            return string2;
        }
        Object object = "";
        for (ParseNode parseNode2 : parseNode.children()) {
            object = (String)object + " " + this.sql_fragment(parseNode2, list, string);
        }
        return ((String)object).replace(". ", ".").replace(" .", ".");
    }

    private ParseNode comment(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        String string2 = string.substring(list.get((int)(parseNode.from + 1)).begin, list.get((int)(parseNode.to - 1)).end - 1);
        int n = Integer.parseInt(string2);
        if (maxTestNo < n) {
            maxTestNo = n;
        }
        if (singleTest != null && singleTest != n) {
            return null;
        }
        return null;
    }

    static {
        CompletionInsight.trace = false;
        CompletionInsight.timing = false;
        raiselimit = true;
        maxTestNo = 0;
        failedTests = new TreeSet<Integer>();
        isTest = false;
        timeStats = new HashMap<Integer, Long>();
    }
}

