/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.javafx.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.javafx.scene.SceneFactory;
import oracle.dbtools.raptor.javafx.fxml.FxmlInfo;
import oracle.dbtools.raptor.javafx.fxml.FxmlInfoBuilder;
import oracle.dbtools.raptor.javafx.query.FxQueryController;
import oracle.dbtools.raptor.javafx.ui.JFXPanelFactory;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;

public abstract class FxQueryViewer
extends AsynchronousViewerEditor {
    private String fqConnectionName;
    private JFXPanel fxPanel;
    private JPanel gui;
    private boolean initFxComplete;
    private final List<FxmlInfo> fxmlInfoList = new ArrayList<FxmlInfo>();
    private FxQueryViewer parentFxQueryViewer;

    protected Scene createSceneImpl() {
        assert (this.fxmlInfoList.size() == 1);
        FxmlInfo fxmlInfo = this.fxmlInfoList.get(0);
        fxmlInfo.setConnection(this.getFqConnectionName());
        return SceneFactory.createScene((Parent)fxmlInfo.getFxmlUI());
    }

    public String getFqConnectionName() {
        return this.fqConnectionName;
    }

    protected void setFqConnectionName(String string) {
        this.fqConnectionName = string;
    }

    @Override
    public synchronized void doSetContext(Context context) {
        if (context != null) {
            try {
                Node node = context.getNode();
                if (!(node instanceof ViewerNode)) {
                    throw new IllegalArgumentException("Context Node must be a ViewerNode");
                }
                ViewerNode viewerNode = (ViewerNode)node;
                DBObject dBObject = viewerNode.getDBObject();
                this.fqConnectionName = dBObject.getConnectionName();
                viewerNode.setPinned(true);
            }
            catch (Exception exception) {
                Logger.severe(this.getClass(), (Throwable)exception);
            }
            super.setContext(context);
        }
    }

    @Override
    protected JComponent createViewerUI() {
        if (null == this.gui) {
            try {
                this.gui = new JPanel(new BorderLayout());
                this.fxPanel = JFXPanelFactory.createJFXPanel();
                if (this.fxPanel != null) {
                    this.gui.add((Component)this.fxPanel, "Center");
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FxQueryViewer.this.initFX(FxQueryViewer.this.fxPanel);
                        }
                    });
                    while (!this.initFxComplete) {
                        Thread.sleep(200L);
                    }
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EditorManager.getEditorManager().closeEditors(Collections.singletonList(FxQueryViewer.this));
                        }
                    });
                }
            }
            catch (Exception exception) {
                Logger.severe(this.getClass(), (Throwable)exception);
            }
        }
        return this.gui;
    }

    @Override
    public void openImpl(boolean bl) {
        super.openImpl(bl);
        for (int i = 1; i < 1; ++i) {
        }
    }

    @Override
    public void update(Object object, UpdateMessage updateMessage) {
        for (int i = 1; i < 1; ++i) {
        }
    }

    @Override
    public void closeImpl(boolean bl) {
        if (this.fxPanel != null) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (FxmlInfo fxmlInfo : FxQueryViewer.this.fxmlInfoList) {
                        fxmlInfo.setConnection(null);
                    }
                    FxQueryViewer.this.fxmlInfoList.clear();
                }
            });
        }
        super.closeImpl(bl);
    }

    @Override
    protected void updateContent(boolean bl) {
    }

    @Override
    protected void cleanUp() {
    }

    @Override
    public Object getPrintable() {
        return null;
    }

    protected void add(MetaResource metaResource) {
        this.add(FxmlInfoBuilder.create().fxmlFile(metaResource.getResourcePath()).classLoader(metaResource.getClassLoader()).build());
    }

    protected void add(FxmlInfo fxmlInfo) {
        if (!this.fxmlInfoList.contains(fxmlInfo)) {
            this.fxmlInfoList.add(fxmlInfo);
            FxQueryController fxQueryController = fxmlInfo.getController();
            if (fxQueryController != null) {
                fxQueryController.setFxQueryViewer(this);
                fxQueryController.setParentFxQueryViewer(this.parentFxQueryViewer);
            }
        }
    }

    public void setParentFxQueryViewer(FxQueryViewer fxQueryViewer) {
        this.parentFxQueryViewer = fxQueryViewer;
    }

    private void initFX(JFXPanel jFXPanel) {
        try {
            Scene scene = this.createScene();
            jFXPanel.setScene(scene);
            this.initFxComplete = true;
        }
        catch (Exception exception) {
            Logger.severe(this.getClass(), (Throwable)exception);
        }
    }

    private Scene createScene() {
        Scene scene = this.createSceneImpl();
        return scene;
    }
}

