/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.sql.Connection;
import java.util.Collections;
import java.util.Map;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.javatools.db.DBException;

public final class ConnectionInfo {
    private final String m_cName;
    private Connection m_conn;
    private final Version m_version;
    private final String m_type;
    private final String m_catalog;
    private final String m_schema;

    public ConnectionInfo(String string, Connection connection, Version version, String string2, String string3, String string4) {
        this.m_cName = string;
        this.m_conn = connection;
        this.m_version = version;
        this.m_type = string2;
        this.m_catalog = string3;
        this.m_schema = string4;
    }

    public String getConnectionName() {
        return this.m_cName;
    }

    public Connection getConnection() {
        try {
            Connection connection = Connections.getInstance().getConnection(this.m_cName, false);
            if (connection != null) {
                this.m_conn = connection;
            }
        }
        catch (DBException dBException) {
            ExceptionHandler.handleException((Throwable)dBException);
        }
        return this.m_conn;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public String getConnectionType() {
        return this.m_type;
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String[] getSupportedTypesForConnection() {
        return null;
    }

    public Map<String, Object> getInitialContext() {
        return Collections.emptyMap();
    }
}

